/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.searchsettings.algorithm_settings;

import com.compomics.util.examples.BareBonesBrowserLaunch;
import com.compomics.util.experiment.biology.PTM;
import com.compomics.util.experiment.biology.PTMFactory;
import com.compomics.util.experiment.identification.identification_parameters.XtandemParameters;
import com.compomics.util.gui.GuiUtilities;
import com.compomics.util.gui.error_handlers.HelpDialog;
import com.compomics.util.gui.ptm.ModificationsDialog;
import com.compomics.util.gui.ptm.PtmDialogParent;
import com.compomics.util.gui.renderers.AlignedListCellRenderer;
import com.compomics.util.preferences.ModificationProfile;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import no.uib.jsparklines.extra.NimbusCheckBoxRenderer;
import no.uib.jsparklines.renderers.JSparklinesBarChartTableCellRenderer;
import no.uib.jsparklines.renderers.JSparklinesColorTableCellRenderer;
import org.jfree.chart.plot.PlotOrientation;

public class XTandemSettingsDialog
extends JDialog
implements PtmDialogParent {
    private XtandemParameters xtandemParameters;
    private ModificationProfile modificationProfile;
    private double fragmentIonMassAccuracy;
    private boolean cancelled = false;
    private ArrayList<String> modificationTableToolTips;
    private PTMFactory ptmFactory = PTMFactory.getInstance();
    private JPanel advancedSearchSettingsPanel;
    private JLabel advancedSettingsWarningLabel;
    private JPanel backgroundPanel;
    private JButton closeButton;
    private JLabel dynamicRangeLbl;
    private JTextField dynamicRangeTxt;
    private JLabel eValueLbl;
    private JTextField eValueTxt;
    private JTextField maxEValueRefineTxt;
    private JLabel maxEValueRefinmentLbl;
    private JLabel minFragMzLbl;
    private JTextField minFragmentMzTxt;
    private JLabel minPeaksLbl;
    private JTextField minPeaksTxt;
    private JLabel minPrecMassLbl;
    private JTextField minPrecMassTxt;
    private JScrollPane modificationsJScrollPane;
    private JTable modificationsTable;
    private JLabel nPeaksLbl;
    private JTextField nPeaksTxt;
    private JComboBox noiseSuppressionCmb;
    private JLabel noiseSuppressionLabel;
    private JButton okButton;
    private JButton openDialogHelpJButton;
    private JButton openModificationSettingsJButton;
    private JComboBox outputHistogramsCmb;
    private JLabel outputHistogramsLabel;
    private JComboBox outputProteinsCmb;
    private JLabel outputProteinsLabel;
    private JComboBox outputSequencesCmb;
    private JLabel outputSequencesLabel;
    private JPanel outputSettingsPanel;
    private JComboBox outputSpectraCmb;
    private JLabel outputSpectraLabel;
    private JLabel pointMutationLabel;
    private JComboBox pointMutationsCmb;
    private JComboBox potentialModificationsCmb;
    private JComboBox quickAcetylCmb;
    private JLabel quickAcetylLabel;
    private JComboBox quickPyroCmb;
    private JLabel quickPyroLabel;
    private JComboBox refinementCmb;
    private JLabel refinementLabel;
    private JPanel refinementModificationsJPanel;
    private JLabel refinementModificationsLabel;
    private JPanel refinementSettingsPanel;
    private JComboBox semiEnzymaticCmb;
    private JLabel semiEnzymaticLabel;
    private JLabel skylinePathValueLbl;
    private JTextField skylineTxt;
    private JComboBox snapsCmb;
    private JLabel snapsLabel;
    private JPanel spectrumImportSettingsPanel;
    private JComboBox spectrumSynthesisCmb;
    private JLabel spectrumSynthesisLabel;
    private JComboBox stpBiasCmb;
    private JLabel stpBiasLabel;
    private JComboBox unanticipatedCleavageCmb;
    private JLabel unanticipatedCleavageLabel;
    private JLabel usePotentialModsLabel;

    public XTandemSettingsDialog(Frame parent, XtandemParameters xtandemParameters, ModificationProfile modificationProfile, double fragmentIonMassAccuracy) {
        super(parent, true);
        this.xtandemParameters = xtandemParameters;
        this.modificationProfile = new ModificationProfile(modificationProfile);
        this.fragmentIonMassAccuracy = fragmentIonMassAccuracy;
        this.initComponents();
        this.setUpGUI();
        this.fillGUI();
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    private void setUpGUI() {
        this.noiseSuppressionCmb.setRenderer(new AlignedListCellRenderer(0));
        this.quickAcetylCmb.setRenderer(new AlignedListCellRenderer(0));
        this.quickPyroCmb.setRenderer(new AlignedListCellRenderer(0));
        this.stpBiasCmb.setRenderer(new AlignedListCellRenderer(0));
        this.outputProteinsCmb.setRenderer(new AlignedListCellRenderer(0));
        this.outputSequencesCmb.setRenderer(new AlignedListCellRenderer(0));
        this.outputSpectraCmb.setRenderer(new AlignedListCellRenderer(0));
        this.outputHistogramsCmb.setRenderer(new AlignedListCellRenderer(0));
        this.refinementCmb.setRenderer(new AlignedListCellRenderer(0));
        this.unanticipatedCleavageCmb.setRenderer(new AlignedListCellRenderer(0));
        this.semiEnzymaticCmb.setRenderer(new AlignedListCellRenderer(0));
        this.potentialModificationsCmb.setRenderer(new AlignedListCellRenderer(0));
        this.pointMutationsCmb.setRenderer(new AlignedListCellRenderer(0));
        this.snapsCmb.setRenderer(new AlignedListCellRenderer(0));
        this.spectrumSynthesisCmb.setRenderer(new AlignedListCellRenderer(0));
        this.modificationTableToolTips = new ArrayList();
        this.modificationTableToolTips.add(null);
        this.modificationTableToolTips.add("Modification Name");
        this.modificationTableToolTips.add("Modification Mass");
        this.modificationTableToolTips.add("Variable Refinement Modification");
        this.modificationTableToolTips.add("Fixed Refinement Modification");
        this.modificationsJScrollPane.getViewport().setOpaque(false);
        this.modificationsTable.getTableHeader().setReorderingAllowed(false);
        this.setAllModificationTableProperties();
    }

    private void setAllModificationTableProperties() {
        this.modificationsTable.getColumn(" ").setCellRenderer((TableCellRenderer)new JSparklinesColorTableCellRenderer());
        this.modificationsTable.getColumn(" ").setMaxWidth(35);
        this.modificationsTable.getColumn(" ").setMinWidth(35);
        this.modificationsTable.getColumn("Mass").setMaxWidth(100);
        this.modificationsTable.getColumn("Mass").setMinWidth(100);
        this.modificationsTable.getColumn("F").setCellRenderer((TableCellRenderer)new NimbusCheckBoxRenderer());
        this.modificationsTable.getColumn("V").setCellRenderer((TableCellRenderer)new NimbusCheckBoxRenderer());
        this.modificationsTable.getColumn("F").setMaxWidth(30);
        this.modificationsTable.getColumn("F").setMinWidth(30);
        this.modificationsTable.getColumn("V").setMaxWidth(30);
        this.modificationsTable.getColumn("V").setMinWidth(30);
    }

    private void fillGUI() {
        if (this.xtandemParameters.getDynamicRange() != null) {
            this.dynamicRangeTxt.setText(this.xtandemParameters.getDynamicRange() + "");
        }
        if (this.xtandemParameters.getnPeaks() != null) {
            this.nPeaksTxt.setText(this.xtandemParameters.getnPeaks() + "");
        }
        if (this.xtandemParameters.getMinFragmentMz() != null) {
            this.minFragmentMzTxt.setText(this.xtandemParameters.getMinFragmentMz() + "");
        }
        if (this.xtandemParameters.getMinPeaksPerSpectrum() != null) {
            this.minPeaksTxt.setText(this.xtandemParameters.getMinPeaksPerSpectrum() + "");
        }
        if (this.xtandemParameters.isUseNoiseSuppression().booleanValue()) {
            this.noiseSuppressionCmb.setSelectedIndex(0);
            this.minPrecMassTxt.setEnabled(true);
        } else {
            this.noiseSuppressionCmb.setSelectedIndex(1);
            this.minPrecMassTxt.setEnabled(false);
        }
        if (this.xtandemParameters.getMinPrecursorMass() != null) {
            this.minPrecMassTxt.setText(this.xtandemParameters.getMinPrecursorMass() + "");
        }
        if (this.xtandemParameters.isProteinQuickAcetyl().booleanValue()) {
            this.quickAcetylCmb.setSelectedIndex(0);
        } else {
            this.quickAcetylCmb.setSelectedIndex(1);
        }
        if (this.xtandemParameters.isQuickPyrolidone().booleanValue()) {
            this.quickPyroCmb.setSelectedIndex(0);
        } else {
            this.quickPyroCmb.setSelectedIndex(1);
        }
        if (this.xtandemParameters.isStpBias().booleanValue()) {
            this.stpBiasCmb.setSelectedIndex(0);
        } else {
            this.stpBiasCmb.setSelectedIndex(1);
        }
        if (this.xtandemParameters.isRefine().booleanValue()) {
            this.refinementCmb.setSelectedIndex(0);
            this.maxEValueRefineTxt.setEnabled(true);
            this.unanticipatedCleavageCmb.setEnabled(true);
            this.semiEnzymaticCmb.setEnabled(true);
            this.potentialModificationsCmb.setEnabled(true);
            this.pointMutationsCmb.setEnabled(true);
            this.snapsCmb.setEnabled(true);
            this.spectrumSynthesisCmb.setEnabled(true);
        } else {
            this.refinementCmb.setSelectedIndex(1);
            this.maxEValueRefineTxt.setEnabled(false);
            this.unanticipatedCleavageCmb.setEnabled(false);
            this.semiEnzymaticCmb.setEnabled(false);
            this.potentialModificationsCmb.setEnabled(false);
            this.pointMutationsCmb.setEnabled(false);
            this.snapsCmb.setEnabled(false);
            this.spectrumSynthesisCmb.setEnabled(false);
        }
        if (this.xtandemParameters.getMaximumExpectationValueRefinement() != null) {
            this.maxEValueRefineTxt.setText(this.xtandemParameters.getMaximumExpectationValueRefinement() + "");
        }
        if (this.xtandemParameters.isRefineUnanticipatedCleavages().booleanValue()) {
            this.unanticipatedCleavageCmb.setSelectedIndex(0);
        } else {
            this.unanticipatedCleavageCmb.setSelectedIndex(1);
        }
        if (this.xtandemParameters.isRefineSemi().booleanValue()) {
            this.semiEnzymaticCmb.setSelectedIndex(0);
        } else {
            this.semiEnzymaticCmb.setSelectedIndex(1);
        }
        if (this.xtandemParameters.isPotentialModificationsForFullRefinment().booleanValue()) {
            this.potentialModificationsCmb.setSelectedIndex(0);
        } else {
            this.potentialModificationsCmb.setSelectedIndex(1);
        }
        if (this.xtandemParameters.isRefinePointMutations().booleanValue()) {
            this.pointMutationsCmb.setSelectedIndex(0);
        } else {
            this.pointMutationsCmb.setSelectedIndex(1);
        }
        if (this.xtandemParameters.isRefineSnaps().booleanValue()) {
            this.snapsCmb.setSelectedIndex(0);
        } else {
            this.snapsCmb.setSelectedIndex(1);
        }
        if (this.xtandemParameters.isRefineSpectrumSynthesis().booleanValue()) {
            this.spectrumSynthesisCmb.setSelectedIndex(0);
        } else {
            this.spectrumSynthesisCmb.setSelectedIndex(1);
        }
        if (this.xtandemParameters.getMaxEValue() != null) {
            this.eValueTxt.setText(this.xtandemParameters.getMaxEValue() + "");
        }
        if (this.xtandemParameters.isOutputProteins().booleanValue()) {
            this.outputProteinsCmb.setSelectedIndex(0);
            this.outputSequencesCmb.setEnabled(true);
            if (this.xtandemParameters.isOutputSequences().booleanValue()) {
                this.outputSequencesCmb.setSelectedIndex(0);
            } else {
                this.outputSequencesCmb.setSelectedIndex(1);
            }
        } else {
            this.outputProteinsCmb.setSelectedIndex(1);
            this.outputSequencesCmb.setEnabled(false);
            this.outputSequencesCmb.setSelectedIndex(1);
        }
        if (this.xtandemParameters.isOutputSpectra().booleanValue()) {
            this.outputSpectraCmb.setSelectedIndex(0);
        } else {
            this.outputSpectraCmb.setSelectedIndex(1);
        }
        if (this.xtandemParameters.isOutputHistograms().booleanValue()) {
            this.outputHistogramsCmb.setSelectedIndex(0);
        } else {
            this.outputHistogramsCmb.setSelectedIndex(1);
        }
        if (this.xtandemParameters.getSkylinePath() != null) {
            this.skylineTxt.setText(this.xtandemParameters.getSkylinePath() + "");
        }
        this.updateModificationList();
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public XtandemParameters getInput() {
        XtandemParameters result = new XtandemParameters();
        String input = this.dynamicRangeTxt.getText().trim();
        if (!input.equals("")) {
            result.setDynamicRange(new Double(input));
        }
        if (!(input = this.nPeaksTxt.getText().trim()).equals("")) {
            result.setnPeaks(new Integer(input));
        }
        if (!(input = this.minFragmentMzTxt.getText().trim()).equals("")) {
            result.setMinFragmentMz(new Double(input));
        }
        if (!(input = this.minPeaksTxt.getText().trim()).equals("")) {
            result.setMinPeaksPerSpectrum(new Integer(input));
        }
        result.setUseNoiseSuppression(this.noiseSuppressionCmb.getSelectedIndex() == 0);
        input = this.minPrecMassTxt.getText().trim();
        if (!input.equals("")) {
            result.setMinPrecursorMass(new Double(input));
        }
        result.setProteinQuickAcetyl(this.quickAcetylCmb.getSelectedIndex() == 0);
        result.setQuickPyrolidone(this.quickPyroCmb.getSelectedIndex() == 0);
        result.setStpBias(this.stpBiasCmb.getSelectedIndex() == 0);
        result.setRefine(this.refinementCmb.getSelectedIndex() == 0);
        input = this.maxEValueRefineTxt.getText().trim();
        if (!input.equals("")) {
            result.setMaximumExpectationValueRefinement(new Double(input));
        }
        result.setRefineUnanticipatedCleavages(this.unanticipatedCleavageCmb.getSelectedIndex() == 0);
        result.setRefineSemi(this.semiEnzymaticCmb.getSelectedIndex() == 0);
        result.setPotentialModificationsForFullRefinment(this.potentialModificationsCmb.getSelectedIndex() == 0);
        result.setRefinePointMutations(this.pointMutationsCmb.getSelectedIndex() == 0);
        result.setRefineSnaps(this.snapsCmb.getSelectedIndex() == 0);
        result.setRefineSpectrumSynthesis(this.spectrumSynthesisCmb.getSelectedIndex() == 0);
        input = this.eValueTxt.getText().trim();
        if (!input.equals("")) {
            result.setMaxEValue(new Double(input));
        }
        result.setOutputProteins(this.outputProteinsCmb.getSelectedIndex() == 0);
        result.setOutputSequences(this.outputSequencesCmb.getSelectedIndex() == 0);
        result.setOutputSpectra(this.outputSpectraCmb.getSelectedIndex() == 0);
        result.setOutputHistograms(this.outputHistogramsCmb.getSelectedIndex() == 0);
        input = this.skylineTxt.getText().trim();
        if (!input.equals("")) {
            result.setSkylinePath(input);
        }
        return result;
    }

    public ModificationProfile getModificationProfile() {
        return this.modificationProfile;
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.spectrumImportSettingsPanel = new JPanel();
        this.dynamicRangeLbl = new JLabel();
        this.dynamicRangeTxt = new JTextField();
        this.nPeaksTxt = new JTextField();
        this.nPeaksLbl = new JLabel();
        this.minFragMzLbl = new JLabel();
        this.minFragmentMzTxt = new JTextField();
        this.minPeaksLbl = new JLabel();
        this.minPeaksTxt = new JTextField();
        this.minPrecMassLbl = new JLabel();
        this.minPrecMassTxt = new JTextField();
        this.noiseSuppressionCmb = new JComboBox();
        this.noiseSuppressionLabel = new JLabel();
        this.advancedSearchSettingsPanel = new JPanel();
        this.quickPyroCmb = new JComboBox();
        this.quickAcetylCmb = new JComboBox();
        this.quickAcetylLabel = new JLabel();
        this.quickPyroLabel = new JLabel();
        this.stpBiasLabel = new JLabel();
        this.stpBiasCmb = new JComboBox();
        this.refinementSettingsPanel = new JPanel();
        this.refinementCmb = new JComboBox();
        this.refinementLabel = new JLabel();
        this.semiEnzymaticLabel = new JLabel();
        this.semiEnzymaticCmb = new JComboBox();
        this.maxEValueRefineTxt = new JTextField();
        this.maxEValueRefinmentLbl = new JLabel();
        this.pointMutationLabel = new JLabel();
        this.pointMutationsCmb = new JComboBox();
        this.snapsLabel = new JLabel();
        this.snapsCmb = new JComboBox();
        this.spectrumSynthesisCmb = new JComboBox();
        this.spectrumSynthesisLabel = new JLabel();
        this.unanticipatedCleavageCmb = new JComboBox();
        this.unanticipatedCleavageLabel = new JLabel();
        this.usePotentialModsLabel = new JLabel();
        this.potentialModificationsCmb = new JComboBox();
        this.refinementModificationsJPanel = new JPanel();
        this.refinementModificationsLabel = new JLabel();
        this.openModificationSettingsJButton = new JButton();
        this.modificationsJScrollPane = new JScrollPane();
        this.modificationsTable = new JTable(){

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent e) {
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        String tip = (String)XTandemSettingsDialog.this.modificationTableToolTips.get(realIndex);
                        return tip;
                    }
                };
            }
        };
        this.outputSettingsPanel = new JPanel();
        this.eValueLbl = new JLabel();
        this.eValueTxt = new JTextField();
        this.outputSequencesLabel = new JLabel();
        this.outputSequencesCmb = new JComboBox();
        this.outputProteinsCmb = new JComboBox();
        this.outputProteinsLabel = new JLabel();
        this.outputSpectraLabel = new JLabel();
        this.outputSpectraCmb = new JComboBox();
        this.skylineTxt = new JTextField();
        this.skylinePathValueLbl = new JLabel();
        this.outputHistogramsCmb = new JComboBox();
        this.outputHistogramsLabel = new JLabel();
        this.okButton = new JButton();
        this.closeButton = new JButton();
        this.openDialogHelpJButton = new JButton();
        this.advancedSettingsWarningLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Advanced X!Tandem Settings");
        this.setResizable(false);
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.spectrumImportSettingsPanel.setBorder(BorderFactory.createTitledBorder("Spectrum Import"));
        this.spectrumImportSettingsPanel.setOpaque(false);
        this.dynamicRangeLbl.setText("Dynamic Range (Da)    (?)");
        this.dynamicRangeLbl.setToolTipText("Open X!Tandem parameter details");
        this.dynamicRangeLbl.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                XTandemSettingsDialog.this.dynamicRangeLblMouseReleased(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                XTandemSettingsDialog.this.dynamicRangeLblMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                XTandemSettingsDialog.this.dynamicRangeLblMouseExited(evt);
            }
        });
        this.dynamicRangeTxt.setHorizontalAlignment(0);
        this.dynamicRangeTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                XTandemSettingsDialog.this.dynamicRangeTxtKeyReleased(evt);
            }
        });
        this.nPeaksTxt.setHorizontalAlignment(0);
        this.nPeaksTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                XTandemSettingsDialog.this.nPeaksTxtKeyReleased(evt);
            }
        });
        this.nPeaksLbl.setText("Number of Peaks    (?)");
        this.nPeaksLbl.setToolTipText("Open X!Tandem parameter details");
        this.nPeaksLbl.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                XTandemSettingsDialog.this.nPeaksLblMouseReleased(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                XTandemSettingsDialog.this.nPeaksLblMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                XTandemSettingsDialog.this.nPeaksLblMouseExited(evt);
            }
        });
        this.minFragMzLbl.setText("Minimum Fragment m/z    (?)");
        this.minFragMzLbl.setToolTipText("Open X!Tandem parameter details");
        this.minFragMzLbl.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                XTandemSettingsDialog.this.minFragMzLblMouseReleased(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                XTandemSettingsDialog.this.minFragMzLblMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                XTandemSettingsDialog.this.minFragMzLblMouseExited(evt);
            }
        });
        this.minFragmentMzTxt.setHorizontalAlignment(0);
        this.minFragmentMzTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                XTandemSettingsDialog.this.minFragmentMzTxtKeyReleased(evt);
            }
        });
        this.minPeaksLbl.setText("Minimum Peaks    (?)");
        this.minPeaksLbl.setToolTipText("Open X!Tandem parameter details");
        this.minPeaksLbl.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                XTandemSettingsDialog.this.minPeaksLblMouseReleased(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                XTandemSettingsDialog.this.minPeaksLblMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                XTandemSettingsDialog.this.minPeaksLblMouseExited(evt);
            }
        });
        this.minPeaksTxt.setHorizontalAlignment(0);
        this.minPeaksTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                XTandemSettingsDialog.this.minPeaksTxtKeyReleased(evt);
            }
        });
        this.minPrecMassLbl.setText("Minimum Precursor Mass    (?)");
        this.minPrecMassLbl.setToolTipText("Open X!Tandem parameter details");
        this.minPrecMassLbl.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                XTandemSettingsDialog.this.minPrecMassLblMouseReleased(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                XTandemSettingsDialog.this.minPrecMassLblMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                XTandemSettingsDialog.this.minPrecMassLblMouseExited(evt);
            }
        });
        this.minPrecMassTxt.setHorizontalAlignment(0);
        this.minPrecMassTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                XTandemSettingsDialog.this.minPrecMassTxtKeyReleased(evt);
            }
        });
        this.noiseSuppressionCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.noiseSuppressionCmb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XTandemSettingsDialog.this.noiseSuppressionCmbActionPerformed(evt);
            }
        });
        this.noiseSuppressionLabel.setText("Noise Suppression    (?)");
        this.noiseSuppressionLabel.setToolTipText("Open X!Tandem parameter details");
        this.noiseSuppressionLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                XTandemSettingsDialog.this.noiseSuppressionLabelMouseReleased(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                XTandemSettingsDialog.this.noiseSuppressionLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                XTandemSettingsDialog.this.noiseSuppressionLabelMouseExited(evt);
            }
        });
        GroupLayout spectrumImportSettingsPanelLayout = new GroupLayout(this.spectrumImportSettingsPanel);
        this.spectrumImportSettingsPanel.setLayout(spectrumImportSettingsPanelLayout);
        spectrumImportSettingsPanelLayout.setHorizontalGroup(spectrumImportSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(spectrumImportSettingsPanelLayout.createSequentialGroup().addContainerGap().addGroup(spectrumImportSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(spectrumImportSettingsPanelLayout.createSequentialGroup().addGroup(spectrumImportSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.dynamicRangeLbl, -2, 265, -2).addComponent(this.nPeaksLbl, -2, 265, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(spectrumImportSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.nPeaksTxt, -2, 151, -2).addComponent(this.dynamicRangeTxt, -2, 151, -2))).addGroup(spectrumImportSettingsPanelLayout.createSequentialGroup().addComponent(this.minFragMzLbl, -2, 265, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.minFragmentMzTxt, -2, 151, -2)).addGroup(spectrumImportSettingsPanelLayout.createSequentialGroup().addComponent(this.minPeaksLbl, -2, 265, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.minPeaksTxt, -2, 151, -2)).addGroup(spectrumImportSettingsPanelLayout.createSequentialGroup().addGroup(spectrumImportSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.minPrecMassLbl, -2, 265, -2).addComponent(this.noiseSuppressionLabel, -2, 265, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(spectrumImportSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.minPrecMassTxt, -2, 151, -2).addComponent(this.noiseSuppressionCmb, -2, 151, -2)))).addContainerGap()));
        spectrumImportSettingsPanelLayout.setVerticalGroup(spectrumImportSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(spectrumImportSettingsPanelLayout.createSequentialGroup().addContainerGap().addGroup(spectrumImportSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dynamicRangeLbl).addComponent(this.dynamicRangeTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(spectrumImportSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nPeaksTxt, -2, -1, -2).addComponent(this.nPeaksLbl)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(spectrumImportSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.minFragmentMzTxt, -2, -1, -2).addComponent(this.minFragMzLbl)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(spectrumImportSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.minPeaksTxt, -2, -1, -2).addComponent(this.minPeaksLbl)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(spectrumImportSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.noiseSuppressionCmb, -2, -1, -2).addComponent(this.noiseSuppressionLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(spectrumImportSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.minPrecMassTxt, -2, -1, -2).addComponent(this.minPrecMassLbl)).addContainerGap(-1, Short.MAX_VALUE)));
        this.advancedSearchSettingsPanel.setBorder(BorderFactory.createTitledBorder("Advanced Search"));
        this.advancedSearchSettingsPanel.setOpaque(false);
        this.quickPyroCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.quickPyroCmb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XTandemSettingsDialog.this.quickPyroCmbActionPerformed(evt);
            }
        });
        this.quickAcetylCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.quickAcetylCmb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XTandemSettingsDialog.this.quickAcetylCmbActionPerformed(evt);
            }
        });
        this.quickAcetylLabel.setText("Quick Acetyl    (?)");
        this.quickAcetylLabel.setToolTipText("Open X!Tandem parameter details");
        this.quickAcetylLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                XTandemSettingsDialog.this.quickAcetylLabelMouseReleased(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                XTandemSettingsDialog.this.quickAcetylLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                XTandemSettingsDialog.this.quickAcetylLabelMouseExited(evt);
            }
        });
        this.quickPyroLabel.setText("Quick Pyrolidone    (?)");
        this.quickPyroLabel.setToolTipText("Open X!Tandem parameter details");
        this.quickPyroLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                XTandemSettingsDialog.this.quickPyroLabelMouseReleased(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                XTandemSettingsDialog.this.quickPyroLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                XTandemSettingsDialog.this.quickPyroLabelMouseExited(evt);
            }
        });
        this.stpBiasLabel.setText("stP bias    (?)");
        this.stpBiasLabel.setToolTipText("Open X!Tandem parameter details");
        this.stpBiasLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                XTandemSettingsDialog.this.stpBiasLabelMouseReleased(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                XTandemSettingsDialog.this.stpBiasLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                XTandemSettingsDialog.this.stpBiasLabelMouseExited(evt);
            }
        });
        this.stpBiasCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        GroupLayout advancedSearchSettingsPanelLayout = new GroupLayout(this.advancedSearchSettingsPanel);
        this.advancedSearchSettingsPanel.setLayout(advancedSearchSettingsPanelLayout);
        advancedSearchSettingsPanelLayout.setHorizontalGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addContainerGap().addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.quickPyroLabel, -2, 265, -2).addComponent(this.quickAcetylLabel, -2, 265, -2).addComponent(this.stpBiasLabel, -2, 265, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.stpBiasCmb, -2, 151, -2).addComponent(this.quickPyroCmb, -2, 151, -2).addComponent(this.quickAcetylCmb, GroupLayout.Alignment.TRAILING, -2, 151, -2)).addContainerGap()));
        advancedSearchSettingsPanelLayout.setVerticalGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addContainerGap().addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.quickAcetylLabel).addComponent(this.quickAcetylCmb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.quickPyroCmb, -2, -1, -2).addComponent(this.quickPyroLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.stpBiasCmb, -2, -1, -2).addComponent(this.stpBiasLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        this.refinementSettingsPanel.setBorder(BorderFactory.createTitledBorder("Refinement"));
        this.refinementSettingsPanel.setOpaque(false);
        this.refinementCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.refinementCmb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XTandemSettingsDialog.this.refinementCmbActionPerformed(evt);
            }
        });
        this.refinementLabel.setText("Refinement    (?)");
        this.refinementLabel.setToolTipText("Open X!Tandem parameter details");
        this.refinementLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                XTandemSettingsDialog.this.refinementLabelMouseReleased(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                XTandemSettingsDialog.this.refinementLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                XTandemSettingsDialog.this.refinementLabelMouseExited(evt);
            }
        });
        this.semiEnzymaticLabel.setText("Semi-Enzymatic Cleavage    (?)");
        this.semiEnzymaticLabel.setToolTipText("Open X!Tandem parameter details");
        this.semiEnzymaticLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                XTandemSettingsDialog.this.semiEnzymaticLabelMouseReleased(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                XTandemSettingsDialog.this.semiEnzymaticLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                XTandemSettingsDialog.this.semiEnzymaticLabelMouseExited(evt);
            }
        });
        this.semiEnzymaticCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.maxEValueRefineTxt.setHorizontalAlignment(0);
        this.maxEValueRefineTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                XTandemSettingsDialog.this.maxEValueRefineTxtKeyReleased(evt);
            }
        });
        this.maxEValueRefinmentLbl.setText("Maximum Valid Expectation Value    (?)");
        this.maxEValueRefinmentLbl.setToolTipText("Open X!Tandem parameter details");
        this.maxEValueRefinmentLbl.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                XTandemSettingsDialog.this.maxEValueRefinmentLblMouseReleased(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                XTandemSettingsDialog.this.maxEValueRefinmentLblMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                XTandemSettingsDialog.this.maxEValueRefinmentLblMouseExited(evt);
            }
        });
        this.pointMutationLabel.setText("Point Mutations    (?)");
        this.pointMutationLabel.setToolTipText("Open X!Tandem parameter details");
        this.pointMutationLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                XTandemSettingsDialog.this.pointMutationLabelMouseReleased(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                XTandemSettingsDialog.this.pointMutationLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                XTandemSettingsDialog.this.pointMutationLabelMouseExited(evt);
            }
        });
        this.pointMutationsCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.snapsLabel.setText("snAPs    (?)");
        this.snapsLabel.setToolTipText("Open X!Tandem parameter details");
        this.snapsLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                XTandemSettingsDialog.this.snapsLabelMouseReleased(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                XTandemSettingsDialog.this.snapsLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                XTandemSettingsDialog.this.snapsLabelMouseExited(evt);
            }
        });
        this.snapsCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.spectrumSynthesisCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.spectrumSynthesisLabel.setText("Spectrum Synthesis    (?)");
        this.spectrumSynthesisLabel.setToolTipText("Open X!Tandem parameter details");
        this.spectrumSynthesisLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                XTandemSettingsDialog.this.spectrumSynthesisLabelMouseReleased(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                XTandemSettingsDialog.this.spectrumSynthesisLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                XTandemSettingsDialog.this.spectrumSynthesisLabelMouseExited(evt);
            }
        });
        this.unanticipatedCleavageCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.unanticipatedCleavageLabel.setText("Unanticipated Cleavage    (?)");
        this.unanticipatedCleavageLabel.setToolTipText("Open X!Tandem parameter details");
        this.unanticipatedCleavageLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                XTandemSettingsDialog.this.unanticipatedCleavageLabelMouseReleased(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                XTandemSettingsDialog.this.unanticipatedCleavageLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                XTandemSettingsDialog.this.unanticipatedCleavageLabelMouseExited(evt);
            }
        });
        this.usePotentialModsLabel.setText("Potential Modifications for Full Refinement    (?)");
        this.usePotentialModsLabel.setToolTipText("Open X!Tandem parameter details");
        this.usePotentialModsLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                XTandemSettingsDialog.this.usePotentialModsLabelMouseReleased(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                XTandemSettingsDialog.this.usePotentialModsLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                XTandemSettingsDialog.this.usePotentialModsLabelMouseExited(evt);
            }
        });
        this.potentialModificationsCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.refinementModificationsJPanel.setOpaque(false);
        this.refinementModificationsLabel.setText("Refinement Modifications    (?)");
        this.refinementModificationsLabel.setToolTipText("Open X!Tandem parameter details");
        this.refinementModificationsLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                XTandemSettingsDialog.this.refinementModificationsLabelMouseReleased(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                XTandemSettingsDialog.this.refinementModificationsLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                XTandemSettingsDialog.this.refinementModificationsLabelMouseExited(evt);
            }
        });
        this.openModificationSettingsJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/edit_gray.png")));
        this.openModificationSettingsJButton.setToolTipText("Edit Modifications");
        this.openModificationSettingsJButton.setBorder(null);
        this.openModificationSettingsJButton.setBorderPainted(false);
        this.openModificationSettingsJButton.setContentAreaFilled(false);
        this.openModificationSettingsJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/edit.png")));
        this.openModificationSettingsJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                XTandemSettingsDialog.this.openModificationSettingsJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                XTandemSettingsDialog.this.openModificationSettingsJButtonMouseExited(evt);
            }
        });
        this.openModificationSettingsJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XTandemSettingsDialog.this.openModificationSettingsJButtonActionPerformed(evt);
            }
        });
        this.modificationsJScrollPane.setPreferredSize(new Dimension(100, 60));
        this.modificationsTable.setModel(new DefaultTableModel(new Object[0][], new String[]{" ", "Name", "Mass", "V", "F"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Object.class, String.class, Double.class, Boolean.class, Boolean.class};
                this.canEdit = new boolean[]{false, false, false, true, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.modificationsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent evt) {
                XTandemSettingsDialog.this.modificationsTableMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                XTandemSettingsDialog.this.modificationsTableMouseReleased(evt);
            }
        });
        this.modificationsTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                XTandemSettingsDialog.this.modificationsTableMouseMoved(evt);
            }
        });
        this.modificationsJScrollPane.setViewportView(this.modificationsTable);
        GroupLayout refinementModificationsJPanelLayout = new GroupLayout(this.refinementModificationsJPanel);
        this.refinementModificationsJPanel.setLayout(refinementModificationsJPanelLayout);
        refinementModificationsJPanelLayout.setHorizontalGroup(refinementModificationsJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(refinementModificationsJPanelLayout.createSequentialGroup().addComponent(this.refinementModificationsLabel, -1, -1, Short.MAX_VALUE).addGap(246, 246, 246).addComponent(this.openModificationSettingsJButton).addGap(2, 2, 2)).addComponent(this.modificationsJScrollPane, -1, -1, Short.MAX_VALUE));
        refinementModificationsJPanelLayout.setVerticalGroup(refinementModificationsJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(refinementModificationsJPanelLayout.createSequentialGroup().addGroup(refinementModificationsJPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.refinementModificationsLabel).addComponent(this.openModificationSettingsJButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.modificationsJScrollPane, -1, -1, Short.MAX_VALUE)));
        GroupLayout refinementSettingsPanelLayout = new GroupLayout(this.refinementSettingsPanel);
        this.refinementSettingsPanel.setLayout(refinementSettingsPanelLayout);
        refinementSettingsPanelLayout.setHorizontalGroup(refinementSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(refinementSettingsPanelLayout.createSequentialGroup().addContainerGap().addGroup(refinementSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.refinementModificationsJPanel, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, refinementSettingsPanelLayout.createSequentialGroup().addComponent(this.usePotentialModsLabel, -2, 265, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.potentialModificationsCmb, -2, 149, -2)).addGroup(refinementSettingsPanelLayout.createSequentialGroup().addComponent(this.refinementLabel, -2, 265, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.refinementCmb, -2, 149, -2)).addGroup(refinementSettingsPanelLayout.createSequentialGroup().addComponent(this.semiEnzymaticLabel, -2, 265, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.semiEnzymaticCmb, -2, 149, -2)).addGroup(GroupLayout.Alignment.TRAILING, refinementSettingsPanelLayout.createSequentialGroup().addComponent(this.maxEValueRefinmentLbl, -2, 265, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.maxEValueRefineTxt, -2, 151, -2)).addGroup(GroupLayout.Alignment.TRAILING, refinementSettingsPanelLayout.createSequentialGroup().addComponent(this.pointMutationLabel, -2, 265, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.pointMutationsCmb, -2, 149, -2)).addGroup(GroupLayout.Alignment.TRAILING, refinementSettingsPanelLayout.createSequentialGroup().addComponent(this.snapsLabel, -2, 265, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.snapsCmb, -2, 149, -2)).addGroup(refinementSettingsPanelLayout.createSequentialGroup().addComponent(this.spectrumSynthesisLabel, -2, 265, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.spectrumSynthesisCmb, -2, 149, -2)).addGroup(refinementSettingsPanelLayout.createSequentialGroup().addComponent(this.unanticipatedCleavageLabel, -2, 265, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.unanticipatedCleavageCmb, -2, 149, -2))).addContainerGap()));
        refinementSettingsPanelLayout.setVerticalGroup(refinementSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(refinementSettingsPanelLayout.createSequentialGroup().addContainerGap().addGroup(refinementSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.refinementCmb, -2, -1, -2).addComponent(this.refinementLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(refinementSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maxEValueRefineTxt, -2, -1, -2).addComponent(this.maxEValueRefinmentLbl)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(refinementSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.unanticipatedCleavageCmb, -2, -1, -2).addComponent(this.unanticipatedCleavageLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(refinementSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.semiEnzymaticCmb, -2, -1, -2).addComponent(this.semiEnzymaticLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(refinementSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.potentialModificationsCmb, -2, -1, -2).addComponent(this.usePotentialModsLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(refinementSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.pointMutationsCmb, -2, -1, -2).addComponent(this.pointMutationLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(refinementSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.snapsCmb, -2, -1, -2).addComponent(this.snapsLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(refinementSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.spectrumSynthesisCmb, -2, -1, -2).addComponent(this.spectrumSynthesisLabel)).addGap(18, 18, 18).addComponent(this.refinementModificationsJPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.outputSettingsPanel.setBorder(BorderFactory.createTitledBorder("Output"));
        this.outputSettingsPanel.setOpaque(false);
        this.eValueLbl.setText("E-value Cutoff    (?)");
        this.eValueLbl.setToolTipText("Open X!Tandem parameter details");
        this.eValueLbl.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                XTandemSettingsDialog.this.eValueLblMouseReleased(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                XTandemSettingsDialog.this.eValueLblMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                XTandemSettingsDialog.this.eValueLblMouseExited(evt);
            }
        });
        this.eValueTxt.setHorizontalAlignment(0);
        this.eValueTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                XTandemSettingsDialog.this.eValueTxtKeyReleased(evt);
            }
        });
        this.outputSequencesLabel.setText("Output Sequences    (?)");
        this.outputSequencesLabel.setToolTipText("Open X!Tandem parameter details");
        this.outputSequencesLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                XTandemSettingsDialog.this.outputSequencesLabelMouseReleased(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                XTandemSettingsDialog.this.outputSequencesLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                XTandemSettingsDialog.this.outputSequencesLabelMouseExited(evt);
            }
        });
        this.outputSequencesCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.outputProteinsCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.outputProteinsCmb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XTandemSettingsDialog.this.outputProteinsCmbActionPerformed(evt);
            }
        });
        this.outputProteinsLabel.setText("Output Proteins    (?)");
        this.outputProteinsLabel.setToolTipText("Open X!Tandem parameter details");
        this.outputProteinsLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                XTandemSettingsDialog.this.outputProteinsLabelMouseReleased(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                XTandemSettingsDialog.this.outputProteinsLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                XTandemSettingsDialog.this.outputProteinsLabelMouseExited(evt);
            }
        });
        this.outputSpectraLabel.setText("Output Spectra    (?)");
        this.outputSpectraLabel.setToolTipText("Open X!Tandem parameter details");
        this.outputSpectraLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                XTandemSettingsDialog.this.outputSpectraLabelMouseReleased(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                XTandemSettingsDialog.this.outputSpectraLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                XTandemSettingsDialog.this.outputSpectraLabelMouseExited(evt);
            }
        });
        this.outputSpectraCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.skylineTxt.setHorizontalAlignment(0);
        this.skylinePathValueLbl.setText("Skyline Path    (?)");
        this.skylinePathValueLbl.setToolTipText("Open X!Tandem parameter details");
        this.skylinePathValueLbl.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                XTandemSettingsDialog.this.skylinePathValueLblMouseReleased(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                XTandemSettingsDialog.this.skylinePathValueLblMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                XTandemSettingsDialog.this.skylinePathValueLblMouseExited(evt);
            }
        });
        this.outputHistogramsCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.outputHistogramsLabel.setText("Output Histograms    (?)");
        this.outputHistogramsLabel.setToolTipText("Open X!Tandem parameter details");
        this.outputHistogramsLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                XTandemSettingsDialog.this.outputHistogramsLabelMouseReleased(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                XTandemSettingsDialog.this.outputHistogramsLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                XTandemSettingsDialog.this.outputHistogramsLabelMouseExited(evt);
            }
        });
        GroupLayout outputSettingsPanelLayout = new GroupLayout(this.outputSettingsPanel);
        this.outputSettingsPanel.setLayout(outputSettingsPanelLayout);
        outputSettingsPanelLayout.setHorizontalGroup(outputSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(outputSettingsPanelLayout.createSequentialGroup().addContainerGap().addGroup(outputSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(outputSettingsPanelLayout.createSequentialGroup().addComponent(this.eValueLbl, -2, 265, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.eValueTxt, -2, 151, -2)).addGroup(outputSettingsPanelLayout.createSequentialGroup().addComponent(this.skylinePathValueLbl, -2, 265, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.skylineTxt, -2, 151, -2)).addGroup(outputSettingsPanelLayout.createSequentialGroup().addGroup(outputSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.outputSequencesLabel, -2, 265, -2).addComponent(this.outputProteinsLabel, -2, 265, -2).addComponent(this.outputSpectraLabel, -2, 265, -2).addComponent(this.outputHistogramsLabel, -2, 265, -2)).addGroup(outputSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(outputSettingsPanelLayout.createSequentialGroup().addGap(4, 4, 4).addGroup(outputSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.outputSequencesCmb, GroupLayout.Alignment.TRAILING, -2, 151, -2).addComponent(this.outputProteinsCmb, -2, 151, -2))).addGroup(GroupLayout.Alignment.LEADING, outputSettingsPanelLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(outputSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.outputHistogramsCmb, GroupLayout.Alignment.TRAILING, -2, 151, -2).addComponent(this.outputSpectraCmb, -2, 151, -2)))))).addContainerGap(-1, Short.MAX_VALUE)));
        outputSettingsPanelLayout.setVerticalGroup(outputSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(outputSettingsPanelLayout.createSequentialGroup().addContainerGap().addGroup(outputSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.eValueLbl).addComponent(this.eValueTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(outputSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.outputProteinsLabel).addComponent(this.outputProteinsCmb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(outputSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.outputSequencesCmb, -2, -1, -2).addComponent(this.outputSequencesLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(outputSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.outputSpectraCmb, -2, -1, -2).addComponent(this.outputSpectraLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(outputSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.outputHistogramsCmb, -2, -1, -2).addComponent(this.outputHistogramsLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(outputSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.skylinePathValueLbl).addComponent(this.skylineTxt, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XTandemSettingsDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XTandemSettingsDialog.this.closeButtonActionPerformed(evt);
            }
        });
        this.openDialogHelpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help.GIF")));
        this.openDialogHelpJButton.setToolTipText("Help");
        this.openDialogHelpJButton.setBorder(null);
        this.openDialogHelpJButton.setBorderPainted(false);
        this.openDialogHelpJButton.setContentAreaFilled(false);
        this.openDialogHelpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                XTandemSettingsDialog.this.openDialogHelpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                XTandemSettingsDialog.this.openDialogHelpJButtonMouseExited(evt);
            }
        });
        this.openDialogHelpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XTandemSettingsDialog.this.openDialogHelpJButtonActionPerformed(evt);
            }
        });
        this.advancedSettingsWarningLabel.setText("Note: The advanced settings are for expert use only. See the help for details.");
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.advancedSearchSettingsPanel, -2, -1, -2).addComponent(this.spectrumImportSettingsPanel, -2, -1, -2).addComponent(this.outputSettingsPanel, -2, -1, -2)).addGap(0, 6, Short.MAX_VALUE).addComponent(this.refinementSettingsPanel, -2, -1, -2)).addGroup(backgroundPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.openDialogHelpJButton).addGap(18, 18, 18).addComponent(this.advancedSettingsWarningLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton, -2, 59, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton))).addContainerGap()));
        backgroundPanelLayout.linkSize(0, this.advancedSearchSettingsPanel, this.outputSettingsPanel, this.refinementSettingsPanel, this.spectrumImportSettingsPanel);
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(backgroundPanelLayout.createSequentialGroup().addComponent(this.spectrumImportSettingsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.advancedSearchSettingsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.outputSettingsPanel, -2, -1, -2)).addComponent(this.refinementSettingsPanel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.openDialogHelpJButton).addComponent(this.okButton).addComponent(this.closeButton).addComponent(this.advancedSettingsWarningLabel)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -2, -1, -2));
        this.pack();
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.cancelled = true;
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.validateInput(true)) {
            this.dispose();
        }
    }

    private void outputProteinsCmbActionPerformed(ActionEvent evt) {
        if (this.outputProteinsCmb.getSelectedIndex() == 0) {
            this.outputSequencesCmb.setEnabled(true);
        } else {
            this.outputSequencesCmb.setSelectedIndex(1);
            this.outputSequencesCmb.setEnabled(false);
        }
    }

    private void eValueTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void maxEValueRefineTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void refinementCmbActionPerformed(ActionEvent evt) {
        if (this.refinementCmb.getSelectedIndex() == 0) {
            this.maxEValueRefineTxt.setEnabled(true);
            this.unanticipatedCleavageCmb.setEnabled(true);
            this.semiEnzymaticCmb.setEnabled(true);
            this.potentialModificationsCmb.setEnabled(true);
            this.pointMutationsCmb.setEnabled(true);
            this.snapsCmb.setEnabled(true);
            this.spectrumSynthesisCmb.setEnabled(true);
        } else {
            this.maxEValueRefineTxt.setEnabled(false);
            this.unanticipatedCleavageCmb.setEnabled(false);
            this.semiEnzymaticCmb.setEnabled(false);
            this.potentialModificationsCmb.setEnabled(false);
            this.pointMutationsCmb.setEnabled(false);
            this.snapsCmb.setEnabled(false);
            this.spectrumSynthesisCmb.setEnabled(false);
        }
    }

    private void quickAcetylCmbActionPerformed(ActionEvent evt) {
        if (this.quickAcetylCmb.getSelectedIndex() == 0) {
            for (String modName : this.modificationProfile.getFixedModifications()) {
                PTM ptm = this.ptmFactory.getPTM(modName);
                if (ptm.getType() != 5 && ptm.getType() != 6 && ptm.getType() != 1 && ptm.getType() != 2 || !(Math.abs(ptm.getMass() - 42.010565) < this.fragmentIonMassAccuracy)) continue;
                JOptionPane.showMessageDialog(this, "The quick acetyl option might conflict with " + modName + ".", "Modification Conflict", 0);
                this.quickAcetylCmb.setSelectedIndex(1);
                break;
            }
        }
    }

    private void quickPyroCmbActionPerformed(ActionEvent evt) {
        if (this.quickPyroCmb.getSelectedIndex() == 0) {
            for (String modName : this.modificationProfile.getFixedModifications()) {
                PTM ptm = this.ptmFactory.getPTM(modName);
                if (ptm.getType() != 5 && ptm.getType() != 6 && ptm.getType() != 1 && ptm.getType() != 2 || !(Math.abs(ptm.getMass() + 17.026549) < this.fragmentIonMassAccuracy)) continue;
                JOptionPane.showMessageDialog(this, "The quick pyrolidone option might conflict with " + modName + ".", "Modification Conflict", 0);
                this.quickAcetylCmb.setSelectedIndex(1);
                break;
            }
        }
    }

    private void noiseSuppressionCmbActionPerformed(ActionEvent evt) {
        if (this.noiseSuppressionCmb.getSelectedIndex() == 0) {
            this.minPrecMassTxt.setEnabled(true);
        } else {
            this.minPrecMassTxt.setEnabled(false);
        }
    }

    private void minPrecMassTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void minPeaksTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void minFragmentMzTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void nPeaksTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void dynamicRangeTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void dynamicRangeLblMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void dynamicRangeLblMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void dynamicRangeLblMouseReleased(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("http://www.thegpm.org/TANDEM/api/sdr.html");
        this.setCursor(new Cursor(0));
    }

    private void minFragMzLblMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void minFragMzLblMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void minFragMzLblMouseReleased(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("http://www.thegpm.org/TANDEM/api/smfmz.html");
        this.setCursor(new Cursor(0));
    }

    private void nPeaksLblMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void nPeaksLblMouseReleased(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("http://www.thegpm.org/TANDEM/api/stp.html");
        this.setCursor(new Cursor(0));
    }

    private void nPeaksLblMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void minPeaksLblMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void minPeaksLblMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void minPeaksLblMouseReleased(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("http://www.thegpm.org/TANDEM/api/smp.html");
        this.setCursor(new Cursor(0));
    }

    private void noiseSuppressionLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void noiseSuppressionLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void noiseSuppressionLabelMouseReleased(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("http://www.thegpm.org/TANDEM/api/suns.html");
        this.setCursor(new Cursor(0));
    }

    private void minPrecMassLblMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void minPrecMassLblMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void minPrecMassLblMouseReleased(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("http://www.thegpm.org/TANDEM/api/smpmh.html");
        this.setCursor(new Cursor(0));
    }

    private void quickAcetylLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void quickAcetylLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void quickAcetylLabelMouseReleased(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("http://www.thegpm.org/TANDEM/api/pqa.html");
        this.setCursor(new Cursor(0));
    }

    private void quickPyroLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void quickPyroLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void quickPyroLabelMouseReleased(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("http://www.thegpm.org/TANDEM/api/pqp.html");
        this.setCursor(new Cursor(0));
    }

    private void stpBiasLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void stpBiasLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void stpBiasLabelMouseReleased(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("http://www.thegpm.org/TANDEM/api/pstpb.html");
        this.setCursor(new Cursor(0));
    }

    private void eValueLblMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void eValueLblMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void eValueLblMouseReleased(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("http://www.thegpm.org/TANDEM/api/omvev.html");
        this.setCursor(new Cursor(0));
    }

    private void outputProteinsLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void outputProteinsLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void outputProteinsLabelMouseReleased(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("http://www.thegpm.org/TANDEM/api/oprot.html");
        this.setCursor(new Cursor(0));
    }

    private void outputSequencesLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void outputSequencesLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void outputSequencesLabelMouseReleased(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("http://www.thegpm.org/TANDEM/api/osequ.html");
        this.setCursor(new Cursor(0));
    }

    private void outputSpectraLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void outputSpectraLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void outputSpectraLabelMouseReleased(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("http://www.thegpm.org/TANDEM/api/ospec.html");
        this.setCursor(new Cursor(0));
    }

    private void outputHistogramsLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void outputHistogramsLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void outputHistogramsLabelMouseReleased(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("http://www.thegpm.org/TANDEM/api/ohist.html");
        this.setCursor(new Cursor(0));
    }

    private void skylinePathValueLblMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void skylinePathValueLblMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void skylinePathValueLblMouseReleased(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("http://www.thegpm.org/TANDEM/api/ssp.html");
        this.setCursor(new Cursor(0));
    }

    private void refinementLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void refinementLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void refinementLabelMouseReleased(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("http://www.thegpm.org/TANDEM/api/refine.html");
        this.setCursor(new Cursor(0));
    }

    private void maxEValueRefinmentLblMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void maxEValueRefinmentLblMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void maxEValueRefinmentLblMouseReleased(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("http://www.thegpm.org/TANDEM/api/refmvev.html");
        this.setCursor(new Cursor(0));
    }

    private void unanticipatedCleavageLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void unanticipatedCleavageLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void unanticipatedCleavageLabelMouseReleased(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("http://www.thegpm.org/TANDEM/api/ruc.html");
        this.setCursor(new Cursor(0));
    }

    private void semiEnzymaticLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void semiEnzymaticLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void semiEnzymaticLabelMouseReleased(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("http://www.thegpm.org/TANDEM/api/rcsemi.html");
        this.setCursor(new Cursor(0));
    }

    private void usePotentialModsLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void usePotentialModsLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void usePotentialModsLabelMouseReleased(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("http://www.thegpm.org/TANDEM/api/rupmffr.html");
        this.setCursor(new Cursor(0));
    }

    private void pointMutationLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void pointMutationLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void pointMutationLabelMouseReleased(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("http://www.thegpm.org/TANDEM/api/rpm.html");
        this.setCursor(new Cursor(0));
    }

    private void snapsLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void snapsLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void snapsLabelMouseReleased(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("http://www.thegpm.org/TANDEM/api/rsaps.html");
        this.setCursor(new Cursor(0));
    }

    private void spectrumSynthesisLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void spectrumSynthesisLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void spectrumSynthesisLabelMouseReleased(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("http://www.thegpm.org/TANDEM/api/rss.html");
        this.setCursor(new Cursor(0));
    }

    private void modificationsTableMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void modificationsTableMouseReleased(MouseEvent evt) {
        int row = this.modificationsTable.rowAtPoint(evt.getPoint());
        int column = this.modificationsTable.columnAtPoint(evt.getPoint());
        if (row != -1) {
            if (column == this.modificationsTable.getColumn(" ").getModelIndex()) {
                Color newColor = JColorChooser.showDialog(this, "Pick a Color", (Color)this.modificationsTable.getValueAt(row, column));
                if (newColor != null) {
                    this.ptmFactory.setColor((String)this.modificationsTable.getValueAt(row, 1), newColor);
                    this.modificationsTable.setValueAt(newColor, row, 0);
                    ((DefaultTableModel)this.modificationsTable.getModel()).fireTableDataChanged();
                    this.modificationsTable.repaint();
                }
            } else if (column == this.modificationsTable.getColumn("V").getModelIndex() && this.modificationsTable.getValueAt(row, column) != null) {
                boolean selected = (Boolean)this.modificationsTable.getValueAt(row, column);
                String ptmName = (String)this.modificationsTable.getValueAt(row, 1);
                if (selected) {
                    if (!this.modificationProfile.getRefinementVariableModifications().contains(ptmName)) {
                        this.modificationProfile.addRefinementVariableModification(this.ptmFactory.getPTM(ptmName));
                    }
                } else {
                    this.modificationProfile.removeRefinementVariableModification(ptmName);
                }
                this.updateModificationList();
                if (row < this.modificationsTable.getRowCount()) {
                    this.modificationsTable.setRowSelectionInterval(row, row);
                } else if (row - 1 < this.modificationsTable.getRowCount() && row >= 0) {
                    this.modificationsTable.setRowSelectionInterval(row - 1, row - 1);
                }
            } else if (column == this.modificationsTable.getColumn("F").getModelIndex() && this.modificationsTable.getValueAt(row, column) != null) {
                boolean selected = (Boolean)this.modificationsTable.getValueAt(row, column);
                String ptmName = (String)this.modificationsTable.getValueAt(row, 1);
                if (selected) {
                    if (!this.modificationProfile.getRefinementFixedModifications().contains(ptmName)) {
                        this.modificationProfile.addRefinementFixedModification(this.ptmFactory.getPTM(ptmName));
                    }
                } else {
                    this.modificationProfile.removeRefinementFixedModification(ptmName);
                }
                this.updateModificationList();
                if (row < this.modificationsTable.getRowCount()) {
                    this.modificationsTable.setRowSelectionInterval(row, row);
                } else if (row - 1 < this.modificationsTable.getRowCount() && row >= 0) {
                    this.modificationsTable.setRowSelectionInterval(row - 1, row - 1);
                }
            }
        }
    }

    private void modificationsTableMouseMoved(MouseEvent evt) {
        int row = this.modificationsTable.rowAtPoint(evt.getPoint());
        int column = this.modificationsTable.columnAtPoint(evt.getPoint());
        if (row != -1) {
            if (column == this.modificationsTable.getColumn(" ").getModelIndex()) {
                this.setCursor(new Cursor(12));
            } else {
                this.setCursor(new Cursor(0));
            }
        }
    }

    private void openModificationSettingsJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void openModificationSettingsJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void openModificationSettingsJButtonActionPerformed(ActionEvent evt) {
        new ModificationsDialog((Frame)this.getParent(), this, true);
    }

    private void refinementModificationsLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void refinementModificationsLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void refinementModificationsLabelMouseReleased(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("http://www.thegpm.org/TANDEM/api/refpmm.html");
        this.setCursor(new Cursor(0));
    }

    private void openDialogHelpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void openDialogHelpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void openDialogHelpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog(this, this.getClass().getResource("/helpFiles/XTandemSettingsDialog.html"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/searchgui.gif")), "SearchGUI - Help", 500, 50);
        this.setCursor(new Cursor(0));
    }

    public boolean validateInput(boolean showMessage) {
        boolean valid = true;
        valid = GuiUtilities.validateDoubleInput(this, this.eValueLbl, this.eValueTxt, "e-value cutoff", "E-value Cutoff Error", true, showMessage, valid);
        valid = GuiUtilities.validateDoubleInput(this, this.dynamicRangeLbl, this.dynamicRangeTxt, "dynamic range cutoff", "Dynamic Range Cutoff Error", true, showMessage, valid);
        valid = GuiUtilities.validateIntegerInput(this, this.nPeaksLbl, this.nPeaksTxt, "number of peaks", "Number of Peaks Error", true, showMessage, valid);
        valid = GuiUtilities.validateDoubleInput(this, this.minFragMzLbl, this.minFragmentMzTxt, "minimal fragment m/z", "Minimal Fragment MZ Error", true, showMessage, valid);
        valid = GuiUtilities.validateIntegerInput(this, this.minPeaksLbl, this.minPeaksTxt, "minimal number of peaks", "Minimal Number of Peaks Error", true, showMessage, valid);
        valid = GuiUtilities.validateDoubleInput(this, this.minPrecMassLbl, this.minPrecMassTxt, "minimal precursor mass", "Minimal Precursor Mass Error", true, showMessage, valid);
        valid = GuiUtilities.validateDoubleInput(this, this.maxEValueRefinmentLbl, this.maxEValueRefineTxt, "maximal e-value for the refinement", "Maximal Refinement E-Value Error", true, showMessage, valid);
        this.okButton.setEnabled(valid);
        return valid;
    }

    private void updateModificationList() {
        ArrayList<String> allModificationsList = this.ptmFactory.getPTMs();
        Object[] allModificationsAsArray = new String[allModificationsList.size()];
        for (int i = 0; i < allModificationsList.size(); ++i) {
            allModificationsAsArray[i] = allModificationsList.get(i);
        }
        Arrays.sort(allModificationsAsArray);
        this.modificationsTable.setModel(new DefaultTableModel(new Object[0][], new String[]{" ", "Name", "Mass", "V", "F"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Object.class, String.class, Double.class, Boolean.class, Boolean.class};
                this.canEdit = new boolean[]{false, false, false, true, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        for (Object mod : allModificationsAsArray) {
            ((DefaultTableModel)this.modificationsTable.getModel()).addRow(new Object[]{this.ptmFactory.getColor((String)mod), mod, this.ptmFactory.getPTM((String)mod).getMass(), this.modificationProfile.getRefinementVariableModifications().contains(mod), this.modificationProfile.getRefinementFixedModifications().contains(mod)});
        }
        ((DefaultTableModel)this.modificationsTable.getModel()).fireTableDataChanged();
        this.modificationsTable.repaint();
        double maxMass = Double.MIN_VALUE;
        double minMass = Double.MAX_VALUE;
        for (String ptm : this.ptmFactory.getPTMs()) {
            if (this.ptmFactory.getPTM(ptm).getMass() > maxMass) {
                maxMass = this.ptmFactory.getPTM(ptm).getMass();
            }
            if (!(this.ptmFactory.getPTM(ptm).getMass() < minMass)) continue;
            minMass = this.ptmFactory.getPTM(ptm).getMass();
        }
        this.setAllModificationTableProperties();
        this.modificationsTable.getColumn("Mass").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(minMass), Double.valueOf(maxMass)));
        ((JSparklinesBarChartTableCellRenderer)this.modificationsTable.getColumn("Mass").getCellRenderer()).showNumberAndChart(true, 50);
        if (this.modificationsTable.getRowCount() > 0) {
            this.modificationsTable.setRowSelectionInterval(0, 0);
        }
    }

    @Override
    public void updateModifications() {
        this.updateModificationList();
    }
}

