/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.Serializable;
import java.util.Collections;
import org.biojava.bio.BioError;
import org.biojava.bio.symbol.AbstractSymbolList;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;

class WindowedSymbolList
extends AbstractSymbolList
implements Serializable {
    private final SymbolList source;
    private final Alphabet alpha;
    private final int width;

    public SymbolList getSource() {
        return this.source;
    }

    public WindowedSymbolList(SymbolList source, int width) throws IllegalArgumentException {
        if (source.length() % width != 0) {
            throw new IllegalArgumentException("The source length must be divisible by the window width: " + source.length() + " % " + width + " = " + source.length() % width);
        }
        this.source = source;
        Alphabet a = source.getAlphabet();
        this.alpha = AlphabetManager.getCrossProductAlphabet(Collections.nCopies(width, a));
        this.width = width;
    }

    public Alphabet getAlphabet() {
        return this.alpha;
    }

    public int length() {
        return this.source.length() / this.width;
    }

    public Symbol symbolAt(int index) throws IndexOutOfBoundsException {
        if (index < 1 || index > this.length()) {
            throw new IndexOutOfBoundsException("index must be within (1 .. " + this.length() + "), not " + index);
        }
        index = (index - 1) * this.width + 1;
        try {
            return this.alpha.getSymbol(this.source.subList(index, index + this.width - 1).toList());
        }
        catch (IllegalSymbolException iae) {
            throw new BioError("Alphabet changed underneath me", iae);
        }
    }
}

