/*
 * Decompiled with CFR 0.152.
 */
package jas.hist.test;

import jas.hist.HistogramUpdate;
import jas.hist.Rebinnable2DHistogramData;
import jas.hist.Statistics;
import java.util.Observable;

public class Gauss2D
extends Observable
implements Rebinnable2DHistogramData {
    double ymax = Math.random();
    double[] m_tupleX;
    double[] m_tupleY;
    int m_entries;
    String m_name;
    protected static final int MAXSIZE = 10000;

    public Gauss2D(String name, int entries) {
        if (entries > 10000) {
            throw new IllegalArgumentException("Gauss2D: Size too big");
        }
        this.m_tupleX = new double[10000];
        this.m_tupleY = new double[10000];
        this.m_entries = entries;
        this.m_name = name;
        for (int j = 0; j < 10000; ++j) {
            double k = Math.random() + Math.random() + Math.random() + Math.random() + Math.random() + Math.random();
            double l = Math.random() + Math.random() + Math.random() + Math.random() + Math.random() + Math.random();
            this.m_tupleX[j] = k / 6.0;
            this.m_tupleY[j] = this.ymax * l / 6.0;
        }
    }

    public String getTitle() {
        return this.m_name;
    }

    public double getXMin() {
        return 0.0;
    }

    public double getXMax() {
        return 1.0;
    }

    public double getYMin() {
        return 0.0;
    }

    public double getYMax() {
        return this.ymax;
    }

    public boolean isRebinnable() {
        return true;
    }

    public String[] getXAxisLabels() {
        return null;
    }

    public String[] getYAxisLabels() {
        return null;
    }

    public int getXBins() {
        return 40;
    }

    public int getYBins() {
        return 40;
    }

    public int getXAxisType() {
        return 1;
    }

    public int getYAxisType() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[][][] rebin(int Xbins, double Xmin, double Xmax, int Ybins, double Ymin, double Ymax, boolean wantErrors, boolean hurry, boolean overflow) {
        Gauss2D gauss2D = this;
        synchronized (gauss2D) {
            this.setChanged();
        }
        double[][] hist = new double[Xbins + (overflow ? 2 : 0)][Ybins + (overflow ? 2 : 0)];
        double XbinWidth = (Xmax - Xmin) / (double)Xbins;
        double YbinWidth = (Ymax - Ymin) / (double)Ybins;
        for (int k = 0; k < this.m_entries; ++k) {
            int Xbin = (int)((this.m_tupleX[k] - Xmin) / XbinWidth);
            int Ybin = (int)((this.m_tupleY[k] - Ymin) / YbinWidth);
            if (Xbin >= 0 && Xbin < Xbins && Ybin >= 0 && Ybin < Ybins) {
                double[] dArray = hist[Xbin];
                int n = Ybin;
                dArray[n] = dArray[n] + 1.0;
                continue;
            }
            if (!overflow) continue;
            if (Xbin < 0) {
                Xbin = Xbins;
            }
            if (Xbin > Xbins) {
                Xbin = Xbins + 1;
            }
            if (Ybin < 0) {
                Ybin = Ybins;
            }
            if (Ybin > Ybins) {
                Ybin = Ybins + 1;
            }
            double[] dArray = hist[Xbin];
            int n = Ybin;
            dArray[n] = dArray[n] + 1.0;
        }
        double[][][] result = new double[][][]{hist};
        return result;
    }

    public int getSize() {
        return this.m_entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSize(int newSize) {
        if (newSize > 10000) {
            throw new IllegalArgumentException("Gauss: Size too big");
        }
        this.m_entries = newSize;
        Gauss2D gauss2D = this;
        synchronized (gauss2D) {
            this.notifyObservers(new HistogramUpdate(2, true));
        }
    }

    public double getXData(int i) {
        return this.m_tupleX[i];
    }

    public double getYData(int i) {
        return this.m_tupleY[i];
    }

    public Statistics getStatistics() {
        return null;
    }
}

