/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util.intr;

import cytoscape.util.intr.LongEnumerator;
import java.io.Serializable;

public final class LongLongHash
implements Serializable {
    private static final int[] PRIMES = new int[]{11, 23, 53, 113, 251, 509, 1019, 2039, 4079, 8179, 16369, 32749, 65521, 131063, 262133, 524269, 1048571, 0x1FFFF7, 0x3FFFEF, 8388587, 0xFFFFDF, 33554393, 67108837, 134217689, 0xFFFFFC7, 0x1FFFFFDF, 0x3FFFFFDD, Integer.MAX_VALUE};
    private static final int INITIAL_SIZE = PRIMES[0];
    private static final double THRESHOLD_FACTOR = 0.77;
    private long[] m_keys = new long[INITIAL_SIZE];
    private long[] m_vals = new long[INITIAL_SIZE];
    private int m_elements;
    private int m_size;
    private int m_thresholdSize;
    private long m_prevKey;
    private int m_prevInx;
    private long[] m_keyDump = null;
    private long[] m_valDump = null;

    public LongLongHash() {
        this.empty();
    }

    public final void empty() {
        this.m_elements = 0;
        this.m_size = INITIAL_SIZE;
        this.m_thresholdSize = (int)(0.77 * (double)this.m_size);
        for (int i = 0; i < this.m_size; ++i) {
            this.m_keys[i] = -1L;
            this.m_vals[i] = -1L;
        }
        this.m_prevKey = -1L;
        this.m_prevInx = -1;
    }

    public final int size() {
        return this.m_elements;
    }

    public final long put(long key, long value) {
        if (key < 0L) {
            throw new IllegalArgumentException("key is negative");
        }
        if (value < 0L) {
            throw new IllegalArgumentException("value is negative");
        }
        if (this.m_elements == this.m_thresholdSize) {
            this.incrSize();
        }
        if (key != this.m_prevKey) {
            int incr = 0;
            this.m_prevInx = (int)(key % (long)this.m_size);
            while (this.m_keys[this.m_prevInx] >= 0L && this.m_keys[this.m_prevInx] != key) {
                if (incr == 0) {
                    incr = 1 + (int)(key % (long)(this.m_size - 1));
                }
                this.m_prevInx = (this.m_prevInx + incr) % this.m_size;
            }
            this.m_prevKey = key;
        }
        long returnVal = this.m_vals[this.m_prevInx];
        this.m_vals[this.m_prevInx] = value;
        this.m_keys[this.m_prevInx] = key;
        this.m_elements = (int)((long)this.m_elements + (returnVal >>> 63));
        return returnVal;
    }

    public final long get(long key) {
        if (key < 0L) {
            throw new IllegalArgumentException("key is negative");
        }
        if (key != this.m_prevKey) {
            int incr = 0;
            this.m_prevInx = (int)(key % (long)this.m_size);
            while (this.m_keys[this.m_prevInx] >= 0L && this.m_keys[this.m_prevInx] != key) {
                if (incr == 0) {
                    incr = 1 + (int)(key % (long)(this.m_size - 1));
                }
                this.m_prevInx = (this.m_prevInx + incr) % this.m_size;
            }
            this.m_prevKey = key;
        }
        return this.m_vals[this.m_prevInx];
    }

    public final LongEnumerator keys() {
        return this.enumeration(this.m_keys);
    }

    public final LongEnumerator values() {
        return this.enumeration(this.m_vals);
    }

    private final LongEnumerator enumeration(final long[] arr) {
        final int numElements = this.m_elements;
        return new LongEnumerator(){
            int elements;
            int index;
            {
                this.elements = numElements;
                this.index = -1;
            }

            public int numRemaining() {
                return this.elements;
            }

            public long nextLong() {
                while (arr[++this.index] < 0L) {
                }
                --this.elements;
                return arr[this.index];
            }
        };
    }

    private final void incrSize() {
        int newSize;
        try {
            int primesInx = 0;
            while (this.m_size != PRIMES[primesInx++]) {
            }
            newSize = PRIMES[primesInx];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalStateException("too many elements in this hashtable");
        }
        if (this.m_keys.length < newSize) {
            this.m_keyDump = this.m_keys;
            this.m_valDump = this.m_vals;
            this.m_keys = new long[newSize];
            this.m_vals = new long[newSize];
        } else {
            System.arraycopy(this.m_keys, 0, this.m_keyDump, 0, this.m_size);
            System.arraycopy(this.m_vals, 0, this.m_valDump, 0, this.m_size);
        }
        for (int i = 0; i < newSize; ++i) {
            this.m_keys[i] = -1L;
            this.m_vals[i] = -1L;
        }
        this.m_size = newSize;
        this.m_thresholdSize = (int)(0.77 * (double)this.m_size);
        int oldIndex = -1;
        for (int i = 0; i < this.m_elements; ++i) {
            while (this.m_keyDump[++oldIndex] < 0L) {
            }
            int incr = 0;
            int newIndex = (int)(this.m_keyDump[oldIndex] % (long)this.m_size);
            while (this.m_keys[newIndex] >= 0L) {
                if (incr == 0) {
                    incr = 1 + (int)(this.m_keyDump[oldIndex] % (long)(this.m_size - 1));
                }
                newIndex = (newIndex + incr) % this.m_size;
            }
            this.m_keys[newIndex] = this.m_keyDump[oldIndex];
            this.m_vals[newIndex] = this.m_valDump[oldIndex];
        }
        this.m_prevKey = -1L;
        this.m_prevInx = -1;
    }
}

