/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.logger;

import cytoscape.CytoscapeInit;
import cytoscape.logger.CyLogHandler;
import cytoscape.logger.LogLevel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CyLogger {
    private static HashMap<String, CyLogger> logMap = new HashMap();
    private static HashMap<LogLevel, List<CyLogHandler>> globalHandlerMap = new HashMap();
    private HashMap<LogLevel, List<CyLogHandler>> handlerMap = new HashMap();
    private String loggerName = null;
    private boolean debugging = false;

    public static CyLogger getLogger(String name) {
        CyLogger logger = null;
        logger = logMap.containsKey(name) ? logMap.get(name) : new CyLogger(name);
        return logger;
    }

    public static CyLogger getLogger(Class logClass) {
        return CyLogger.getLogger(logClass.getName());
    }

    public static CyLogger getLogger() {
        return CyLogger.getLogger("cytoscape");
    }

    protected CyLogger(String name) {
        this.loggerName = name;
        logMap.put(name, this);
        Properties properties = CytoscapeInit.getProperties();
        if (properties != null) {
            this.debugging = false;
            String debug = properties.getProperty("cytoscape.debug");
            this.debugging = Boolean.parseBoolean(debug);
        }
    }

    public void debug(String message) {
        this.log(message, LogLevel.LOG_DEBUG);
    }

    public void debug(String message, Throwable exception) {
        this.log(message, LogLevel.LOG_DEBUG, exception);
    }

    public void info(String message) {
        this.log(message, LogLevel.LOG_INFO);
    }

    public void info(String message, Throwable exception) {
        this.log(message, LogLevel.LOG_INFO, exception);
    }

    public void warn(String message) {
        this.log(message, LogLevel.LOG_WARN);
    }

    public void warn(String message, Throwable exception) {
        this.log(message, LogLevel.LOG_WARN, exception);
    }

    public void warning(String message) {
        this.log(message, LogLevel.LOG_WARN);
    }

    public void warning(String message, Throwable exception) {
        this.log(message, LogLevel.LOG_WARN, exception);
    }

    public void error(String message) {
        this.log(message, LogLevel.LOG_ERROR);
    }

    public void error(String message, Throwable exception) {
        this.log(message, LogLevel.LOG_ERROR, exception);
    }

    public void fatal(String message) {
        this.log(message, LogLevel.LOG_FATAL);
    }

    public void fatal(String message, Throwable exception) {
        this.log(message, LogLevel.LOG_FATAL, exception);
    }

    public void setDebug(boolean debug) {
        this.debugging = debug;
    }

    public boolean isDebugging() {
        return this.debugging;
    }

    public void log(String message, LogLevel level, Throwable t) {
        if (message != null && message.length() > 0) {
            message = message + "\n";
        }
        if (t != null) {
            message = message + this.getStack(t);
        }
        this.log(message, level);
    }

    public void log(String message, LogLevel level) {
        if (level == LogLevel.LOG_DEBUG && !this.debugging) {
            return;
        }
        String formattedMessage = this.loggerName + "[" + (Object)((Object)level) + "]: " + message;
        if (globalHandlerMap.size() == 0 && this.handlerMap.size() == 0) {
            System.out.println(formattedMessage);
            return;
        }
        List<CyLogHandler> handlerList = this.getHandlers(globalHandlerMap, level);
        handlerList.addAll(this.getHandlers(this.handlerMap, level));
        for (CyLogHandler handler : handlerList) {
            handler.handleLog(level, formattedMessage);
        }
    }

    public void addLogHandler(CyLogHandler handler, String loggerName, LogLevel level) {
        List<Object> list = null;
        HashMap<LogLevel, List<CyLogHandler>> map = null;
        map = loggerName == null ? globalHandlerMap : this.handlerMap;
        list = map.containsKey((Object)level) ? map.get((Object)level) : new ArrayList();
        list.add(handler);
        map.put(level, list);
    }

    public void addLogHandler(CyLogHandler handler, LogLevel level) {
        this.addLogHandler(handler, null, level);
    }

    public List<CyLogHandler> getLogHandlers(String loggerName, LogLevel level) {
        HashMap<LogLevel, List<CyLogHandler>> map = null;
        map = loggerName == null ? globalHandlerMap : this.handlerMap;
        if (map.containsKey((Object)level)) {
            return map.get((Object)level);
        }
        return null;
    }

    public List<CyLogHandler> getLogHandlers(LogLevel level) {
        return this.getLogHandlers(null, level);
    }

    public CyLogHandler removeLogHandler(CyLogHandler handler, String loggerName, LogLevel level) {
        HashMap<LogLevel, List<CyLogHandler>> map = null;
        map = loggerName == null ? globalHandlerMap : this.handlerMap;
        if (!map.containsKey((Object)level)) {
            return null;
        }
        List<CyLogHandler> list = map.get((Object)level);
        if (list.contains(handler)) {
            list.remove(handler);
            map.put(level, list);
            return handler;
        }
        return null;
    }

    public CyLogHandler removeLogHandler(CyLogHandler handler, LogLevel level) {
        return this.removeLogHandler(handler, null, level);
    }

    private List<CyLogHandler> getHandlers(HashMap<LogLevel, List<CyLogHandler>> map, LogLevel targetLevel) {
        ArrayList<CyLogHandler> list = new ArrayList<CyLogHandler>();
        for (LogLevel level : map.keySet()) {
            if (!targetLevel.applies(level)) continue;
            list.addAll((Collection<CyLogHandler>)map.get((Object)level));
        }
        return list;
    }

    private String getStack(Throwable t) {
        if (t == null) {
            return "";
        }
        String message = "\nCaused by:\n";
        message = t.getMessage() != null ? message + t.getMessage() : message + t.toString();
        StackTraceElement[] stackArray = t.getStackTrace();
        for (int i = 0; stackArray != null && i < stackArray.length; ++i) {
            message = message + "\n      at " + stackArray[i].toString();
        }
        return message + "\n" + this.getStack(t.getCause());
    }
}

