/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.giny;

import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.giny.CyEdgeDepot;
import cytoscape.giny.CyNodeDepot;
import cytoscape.giny.CytoscapeRootGraph;
import cytoscape.giny.FingCyNetwork;
import cytoscape.util.intr.ArrayIntIterator;
import cytoscape.util.intr.IntIterator;
import fing.model.FingExtensibleRootGraph;
import giny.model.Edge;
import giny.model.Node;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class CytoscapeFingRootGraph
extends FingExtensibleRootGraph
implements CytoscapeRootGraph {
    Map<String, Integer> node_name_index_map = new HashMap<String, Integer>();
    Map<String, Integer> edge_name_index_map = new HashMap<String, Integer>();

    public CytoscapeFingRootGraph() {
        super(new CyNodeDepot(), new CyEdgeDepot());
    }

    public CyNetwork createNetwork(Collection nodes, Collection edges) {
        Node[] node = nodes.toArray(new Node[0]);
        Edge[] edge = edges.toArray(new Edge[0]);
        return this.createNetwork(node, edge);
    }

    public CyNetwork createNetwork(Node[] nodes, Edge[] edges) {
        final Node[] nodeArr = nodes != null ? nodes : new Node[]{};
        final Edge[] edgeArr = edges != null ? edges : new Edge[]{};
        final CytoscapeFingRootGraph root = this;
        try {
            return new FingCyNetwork(this, new IntIterator(){
                private int index = 0;

                public boolean hasNext() {
                    return this.index < nodeArr.length;
                }

                public int nextInt() {
                    if (nodeArr[this.index] == null || nodeArr[this.index].getRootGraph() != root) {
                        throw new IllegalArgumentException();
                    }
                    return nodeArr[this.index++].getRootGraphIndex();
                }
            }, new IntIterator(){
                private int index = 0;

                public boolean hasNext() {
                    return this.index < edgeArr.length;
                }

                public int nextInt() {
                    if (edgeArr[this.index] == null || edgeArr[this.index].getRootGraph() != root) {
                        throw new IllegalArgumentException();
                    }
                    return edgeArr[this.index++].getRootGraphIndex();
                }
            });
        }
        catch (IllegalArgumentException exc) {
            return null;
        }
    }

    public CyNetwork createNetwork(int[] nodeInx, int[] edgeInx) {
        if (nodeInx == null) {
            nodeInx = new int[]{};
        }
        if (edgeInx == null) {
            edgeInx = new int[]{};
        }
        try {
            return new FingCyNetwork(this, new ArrayIntIterator(nodeInx, 0, nodeInx.length), new ArrayIntIterator(edgeInx, 0, edgeInx.length));
        }
        catch (IllegalArgumentException exc) {
            return null;
        }
    }

    public CyNode getNode(String identifier) {
        Integer nodeId = this.node_name_index_map.get(identifier);
        if (nodeId != null) {
            return (CyNode)this.getNode(nodeId);
        }
        return null;
    }

    public CyEdge getEdge(String identifier) {
        Integer edgeId = this.edge_name_index_map.get(identifier);
        if (edgeId != null) {
            return (CyEdge)this.getEdge(edgeId);
        }
        return null;
    }

    public void setNodeIdentifier(String identifier, int index) {
        if (index == 0) {
            this.node_name_index_map.remove(identifier);
        } else {
            this.node_name_index_map.put(identifier, index);
        }
    }

    public void setEdgeIdentifier(String identifier, int index) {
        if (index == 0) {
            this.edge_name_index_map.remove(identifier);
        } else {
            this.edge_name_index_map.put(identifier, index);
        }
    }
}

