/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.readers;

import cytoscape.data.CyAttributesImpl;
import cytoscape.data.readers.CyAttributesReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class CyAttributesReaderTest
extends TestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testRead1() throws IOException {
        CyAttributesImpl cyAttributes;
        String attributeName;
        block3: {
            attributeName = "TestNodeAttribute1";
            cyAttributes = new CyAttributesImpl();
            File file = new File("testData/galFiltered.nodeAttrs1");
            FileReader reader = null;
            try {
                reader = new FileReader(file);
                CyAttributesReader.loadAttributes(cyAttributes, reader);
                Object var6_5 = null;
                if (reader == null) break block3;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (reader != null) {
                    reader.close();
                }
                throw throwable;
            }
            reader.close();
        }
        byte type = cyAttributes.getType(attributeName);
        CyAttributesReaderTest.assertEquals((byte)3, type);
        Integer value = cyAttributes.getIntegerAttribute("YKR026C", attributeName);
        CyAttributesReaderTest.assertEquals(1, value);
        value = cyAttributes.getIntegerAttribute("YMR043W", attributeName);
        CyAttributesReaderTest.assertEquals(2, value);
        value = cyAttributes.getIntegerAttribute("YBR043C", attributeName);
        CyAttributesReaderTest.assertEquals(3, value);
        value = cyAttributes.getIntegerAttribute("Nerius", attributeName);
        CyAttributesReaderTest.assertTrue(value == null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testRead2() throws IOException {
        CyAttributesImpl cyAttributes;
        block3: {
            cyAttributes = new CyAttributesImpl();
            File file = new File("testData/galFiltered.edgeAttrs2");
            FileReader reader = null;
            try {
                reader = new FileReader(file);
                CyAttributesReader.loadAttributes(cyAttributes, reader);
                Object var5_4 = null;
                if (reader == null) break block3;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (reader != null) {
                    reader.close();
                }
                throw throwable;
            }
            reader.close();
        }
        byte type = cyAttributes.getType("TestEdgeAttribute2");
        CyAttributesReaderTest.assertEquals((byte)3, type);
        Integer value = cyAttributes.getIntegerAttribute("YKR026C (pp) YGL122C", "TestEdgeAttribute2");
        CyAttributesReaderTest.assertEquals(2, value);
        value = cyAttributes.getIntegerAttribute("YDR382W (pp) YFL029C", "TestEdgeAttribute2");
        CyAttributesReaderTest.assertEquals(3, value);
        value = cyAttributes.getIntegerAttribute("YBL026W (pp) YOR127C", "TestEdgeAttribute2");
        CyAttributesReaderTest.assertEquals(3, value);
        value = cyAttributes.getIntegerAttribute("Nerius", "TestEdgeAttribute2");
        CyAttributesReaderTest.assertTrue(value == null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testRead3() throws IOException {
        CyAttributesImpl cyAttributes;
        block3: {
            cyAttributes = new CyAttributesImpl();
            File file = new File("testData/explicitDouble.attribute");
            FileReader reader = null;
            try {
                reader = new FileReader(file);
                CyAttributesReader.loadAttributes(cyAttributes, reader);
                Object var5_4 = null;
                if (reader == null) break block3;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (reader != null) {
                    reader.close();
                }
                throw throwable;
            }
            reader.close();
        }
        byte type = cyAttributes.getType("Score");
        CyAttributesReaderTest.assertEquals((byte)2, type);
        Double value = cyAttributes.getDoubleAttribute("a", "Score");
        CyAttributesReaderTest.assertEquals(1.0, value, 0.01);
        value = cyAttributes.getDoubleAttribute("c", "Score");
        CyAttributesReaderTest.assertEquals(3.7, value, 0.01);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkReadSimpleLists(String fileToRead, char sep) throws IOException {
        CyAttributesImpl cyAttributes;
        String attributeName;
        block3: {
            attributeName = "GO_molecular_function_level_4";
            cyAttributes = new CyAttributesImpl();
            File file = new File(fileToRead);
            FileReader reader = null;
            try {
                reader = new FileReader(file);
                CyAttributesReader.loadAttributes(cyAttributes, reader);
                Object var8_7 = null;
                if (reader == null) break block3;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (reader != null) {
                    reader.close();
                }
                throw throwable;
            }
            reader.close();
        }
        byte type = cyAttributes.getType(attributeName);
        CyAttributesReaderTest.assertEquals((byte)-2, type);
        List list = cyAttributes.getListAttribute("AP1G1", attributeName);
        CyAttributesReaderTest.assertEquals(3, list.size());
        String value = (String)list.get(0);
        CyAttributesReaderTest.assertEquals("intracellular", value);
        value = (String)list.get(1);
        CyAttributesReaderTest.assertEquals("clathrin" + sep + "adaptor", value);
        value = (String)list.get(2);
        CyAttributesReaderTest.assertEquals("intracellular" + sep + "transporter", value);
        list = cyAttributes.getListAttribute("CDH3", attributeName);
        CyAttributesReaderTest.assertEquals(1, list.size());
        value = (String)list.get(0);
        CyAttributesReaderTest.assertEquals("cell" + sep + "adhesion" + sep + "molecule", value);
    }

    public void testReadSimpleLists1() throws IOException {
        System.clearProperty("cytoscape.decode.attributes");
        this.checkReadSimpleLists("testData/implicitStringArray.attribute", ' ');
    }

    public void testReadSimpleLists2() throws IOException {
        System.clearProperty("cytoscape.decode.attributes");
        this.checkReadSimpleLists("testData/implicitStringArrayEnc.attribute", ' ');
    }

    public void testReadSimpleLists3() throws IOException {
        System.setProperty("cytoscape.decode.attributes", "false");
        this.checkReadSimpleLists("testData/implicitStringArray.attribute", ' ');
    }

    public void testReadSimpleLists4() throws IOException {
        System.setProperty("cytoscape.decode.attributes", "false");
        this.checkReadSimpleLists("testData/implicitStringArrayEnc.attribute", '+');
    }

    public void testReadSimpleLists5() throws IOException {
        System.setProperty("cytoscape.decode.attributes", "true");
        this.checkReadSimpleLists("testData/implicitStringArray.attribute", ' ');
    }

    public void testReadSimpleLists6() throws IOException {
        System.setProperty("cytoscape.decode.attributes", "true");
        this.checkReadSimpleLists("testData/implicitStringArrayEnc.attribute", ' ');
    }

    public static void main(String[] args) {
        TestRunner.run(CyAttributesReaderTest.class);
    }
}

