/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.command;

import cytoscape.command.CyCommandHandler;
import cytoscape.command.CyCommandManager;
import cytoscape.command.CyCommandNamespace;
import cytoscape.layout.Tunable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCommandHandler
implements CyCommandHandler {
    protected Map<String, List<Tunable>> argumentMap = new HashMap<String, List<Tunable>>();
    protected Map<String, String> descriptionMap = new HashMap<String, String>();
    protected CyCommandNamespace namespace = null;

    public AbstractCommandHandler(CyCommandNamespace ns) {
        this.namespace = ns;
    }

    @Override
    public List<String> getCommands() {
        return new ArrayList<String>(this.argumentMap.keySet());
    }

    @Override
    public List<String> getArguments(String command) {
        if (!this.argumentMap.containsKey(command)) {
            return null;
        }
        ArrayList<String> argList = new ArrayList<String>();
        for (Tunable t : this.argumentMap.get(command)) {
            argList.add(t.getName());
        }
        return argList;
    }

    @Override
    public Map<String, Object> getSettings(String command) {
        Map<String, Object> kvSettings = this.createKVSettings(command);
        if (kvSettings != null) {
            return kvSettings;
        }
        return null;
    }

    @Override
    public Map<String, Tunable> getTunables(String command) {
        if (this.argumentMap.containsKey(command)) {
            HashMap<String, Tunable> tunableMap = new HashMap<String, Tunable>();
            for (Tunable t : this.argumentMap.get(command)) {
                tunableMap.put(t.getName(), t);
            }
            return tunableMap;
        }
        return null;
    }

    @Override
    public String getDescription(String command) {
        if (this.descriptionMap.containsKey(command)) {
            return this.descriptionMap.get(command);
        }
        return null;
    }

    protected Map<String, Object> createKVMap(Collection<Tunable> tList) {
        HashMap<String, Object> kvSettings = new HashMap<String, Object>();
        for (Tunable t : tList) {
            Object v = t.getValue();
            if (v != null) {
                kvSettings.put(t.getName(), v.toString());
                continue;
            }
            kvSettings.put(t.getName(), null);
        }
        return kvSettings;
    }

    protected Collection<Tunable> createTunableCollection(Map<String, Object> args) {
        ArrayList<Tunable> tCol = new ArrayList<Tunable>();
        for (String key : args.keySet()) {
            Tunable t = AbstractCommandHandler.makeTunable(key, args.get(key));
            if (t == null) continue;
            tCol.add(t);
        }
        return tCol;
    }

    protected void addDescription(String command, String description) {
        if (this.descriptionMap == null) {
            this.descriptionMap = new HashMap<String, String>();
        }
        this.descriptionMap.put(command, description);
    }

    protected void addArgument(String command) {
        if (this.argumentMap == null) {
            this.argumentMap = new HashMap<String, List<Tunable>>();
        }
        if (!this.argumentMap.containsKey(command)) {
            this.argumentMap.put(command, new ArrayList());
            CyCommandManager.register(this.namespace, command, this);
        }
    }

    protected void addArgument(String command, String vKey) {
        this.addArgument(command, vKey, null);
    }

    protected void addArgument(String command, String vKey, String value) {
        Tunable t = new Tunable(vKey, vKey, 3, value);
        this.addArgument(command, t);
    }

    protected void addArgument(String command, Tunable t) {
        if (this.argumentMap == null) {
            this.argumentMap = new HashMap<String, List<Tunable>>();
        }
        if (!this.argumentMap.containsKey(command)) {
            this.argumentMap.put(command, new ArrayList());
            CyCommandManager.register(this.namespace, command, this);
        }
        List<Tunable> tList = this.argumentMap.get(command);
        tList.add(t);
    }

    protected String getArg(String command, String key, Map<String, Object> args) {
        String value = null;
        if (this.argumentMap.containsKey(command)) {
            List<Tunable> tL = this.argumentMap.get(command);
            for (Tunable t : tL) {
                if (!t.getName().equals(key)) continue;
                Object v = t.getValue();
                if (v == null) break;
                value = v.toString();
                break;
            }
        }
        if (args == null || args.size() == 0 || !args.containsKey(key)) {
            return value;
        }
        return args.get(key).toString();
    }

    private Map<String, Object> createKVSettings(String command) {
        if (!this.argumentMap.containsKey(command)) {
            return null;
        }
        return this.createKVMap((Collection<Tunable>)this.argumentMap.get(command));
    }

    public static Tunable makeTunable(String name, Object value) {
        Class<?> vClass = value.getClass();
        if (vClass == Double.class || vClass == Float.class) {
            return new Tunable(name, name, 1, value);
        }
        if (vClass == Integer.class) {
            return new Tunable(name, name, 0, value);
        }
        if (vClass == Boolean.class) {
            return new Tunable(name, name, 2, value);
        }
        if (vClass == String.class) {
            return new Tunable(name, name, 3, value);
        }
        return new Tunable(name, name, 3, value.toString());
    }
}

