/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.actions;

import cytoscape.Cytoscape;
import cytoscape.actions.SaveSessionTask;
import cytoscape.task.ui.JTaskConfig;
import cytoscape.task.util.TaskManager;
import cytoscape.util.CyFileFilter;
import cytoscape.util.CytoscapeAction;
import cytoscape.util.FileUtil;
import java.awt.event.ActionEvent;
import java.io.File;

public class SaveSessionAction
extends CytoscapeAction {
    public static final String SESSION_EXT = ".cys";

    public SaveSessionAction(String label) {
        super(label);
        this.setPreferredMenu("File");
        this.setAcceleratorCombo(83, 2);
    }

    public SaveSessionAction() {
    }

    public void actionPerformed(ActionEvent e) {
        String name = Cytoscape.getCurrentSessionFileName();
        if (name == null) {
            File file = FileUtil.getFile("Save Current Session as CYS File", FileUtil.SAVE, new CyFileFilter[0]);
            if (file == null) {
                return;
            }
            name = file.getAbsolutePath();
            if (!name.endsWith(SESSION_EXT)) {
                name = name + SESSION_EXT;
            }
            Cytoscape.setCurrentSessionFileName(name);
        }
        SaveSessionTask task = new SaveSessionTask(name);
        JTaskConfig jTaskConfig = new JTaskConfig();
        jTaskConfig.displayCancelButton(false);
        jTaskConfig.setOwner(Cytoscape.getDesktop());
        jTaskConfig.displayCloseButton(true);
        jTaskConfig.displayStatus(true);
        jTaskConfig.setAutoDispose(true);
        TaskManager.executeTask(task, jTaskConfig);
    }
}

