/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.util;

import edu.rit.util.Timer;
import edu.rit.util.TimerTask;
import java.util.Vector;

public class TimerThread
extends Thread {
    private static final int INCR = 4;
    private TimeoutInfo[] myQueue = new TimeoutInfo[5];
    private int mySize = 0;
    private boolean iamRunning = true;
    private static TimerThread theDefaultTimerThread = null;

    public static synchronized TimerThread getDefault() {
        if (theDefaultTimerThread == null) {
            theDefaultTimerThread = new TimerThread();
            theDefaultTimerThread.setDaemon(true);
            theDefaultTimerThread.start();
        }
        return theDefaultTimerThread;
    }

    public Timer createTimer(TimerTask timerTask) {
        return new Timer(this, timerTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        TimerThread timerThread = this;
        synchronized (timerThread) {
            this.iamRunning = false;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (Thread.currentThread() != this) {
            throw new IllegalStateException("Wrong thread called the run() method");
        }
        try {
            while (this.iamRunning) {
                long l = System.currentTimeMillis();
                Vector<TimeoutInfo> vector = null;
                Object object = this;
                synchronized (object) {
                    if (this.mySize == 0) {
                        this.wait();
                        l = System.currentTimeMillis();
                    } else {
                        long l2 = this.myQueue[1].myTimeout - l;
                        if (l2 > 0L) {
                            this.wait(l2);
                            l = System.currentTimeMillis();
                        }
                    }
                    vector = new Vector<TimeoutInfo>();
                    while (this.mySize > 0 && this.myQueue[1].myTimeout <= l) {
                        vector.add(this.myQueue[1]);
                        this.myQueue[1] = this.myQueue[this.mySize];
                        this.myQueue[this.mySize] = null;
                        --this.mySize;
                        this.siftDown(this.mySize);
                    }
                }
                object = vector.iterator();
                while (object.hasNext()) {
                    ((TimeoutInfo)object.next()).myTimer.trigger(l);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            System.err.println("TimerThread interrupted");
            interruptedException.printStackTrace(System.err);
        }
    }

    synchronized void schedule(long l, Timer timer) {
        if (this.mySize == this.myQueue.length - 1) {
            TimeoutInfo[] timeoutInfoArray = new TimeoutInfo[this.myQueue.length + 4];
            System.arraycopy(this.myQueue, 1, timeoutInfoArray, 1, this.mySize);
            this.myQueue = timeoutInfoArray;
        }
        ++this.mySize;
        this.myQueue[this.mySize] = new TimeoutInfo(l, timer);
        this.siftUp(this.mySize);
        this.notifyAll();
    }

    private void siftUp(int n) {
        int n2 = n;
        while (n2 != 1) {
            int n3 = n2 / 2;
            if (this.myQueue[n3].myTimeout <= this.myQueue[n2].myTimeout) break;
            TimeoutInfo timeoutInfo = this.myQueue[n3];
            this.myQueue[n3] = this.myQueue[n2];
            this.myQueue[n2] = timeoutInfo;
            n2 = n3;
        }
    }

    private void siftDown(int n) {
        int n2;
        int n3 = 1;
        while ((n2 = 2 * n3) <= n) {
            if (n2 + 1 <= n && this.myQueue[n2 + 1].myTimeout < this.myQueue[n2].myTimeout) {
                ++n2;
            }
            if (this.myQueue[n3].myTimeout <= this.myQueue[n2].myTimeout) break;
            TimeoutInfo timeoutInfo = this.myQueue[n2];
            this.myQueue[n2] = this.myQueue[n3];
            this.myQueue[n3] = timeoutInfo;
            n3 = n2;
        }
    }

    private static class TimeoutInfo {
        public long myTimeout;
        public Timer myTimer;

        public TimeoutInfo(long l, Timer timer) {
            this.myTimeout = l;
            this.myTimer = timer;
        }
    }
}

