/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.draw.item;

import edu.rit.draw.Drawing;
import edu.rit.draw.item.Fill;
import edu.rit.draw.item.Outline;
import edu.rit.draw.item.Point;
import edu.rit.draw.item.RectangularItem;
import edu.rit.draw.item.Size;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class Rectangle
extends RectangularItem {
    public static final double NORMAL_WIDTH = 72.0;
    public static final double NORMAL_HEIGHT = 72.0;
    public static final double NORMAL_ROUND = 0.0;
    private static final long serialVersionUID = -1131516846619887544L;
    private double myRound = theDefaultRound;
    private static double theDefaultWidth = 72.0;
    private static double theDefaultHeight = 72.0;
    private static double theDefaultRound = 0.0;

    public Rectangle() {
        this.width = theDefaultWidth;
        this.height = theDefaultHeight;
        this.myRound = theDefaultRound;
    }

    public Rectangle(Rectangle rectangle) {
        super(rectangle);
        this.myRound = rectangle.myRound;
    }

    public static Size defaultSize() {
        return new Size(theDefaultWidth, theDefaultHeight);
    }

    public static void defaultSize(Size size) {
        if (size.width < 0.0 || size.height < 0.0) {
            throw new IllegalArgumentException();
        }
        theDefaultWidth = size.width;
        theDefaultHeight = size.height;
    }

    public static double defaultWidth() {
        return theDefaultWidth;
    }

    public static void defaultWidth(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException();
        }
        theDefaultWidth = d;
    }

    public static double defaultHeight() {
        return theDefaultHeight;
    }

    public static void defaultHeight(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException();
        }
        theDefaultHeight = d;
    }

    public static double defaultRound() {
        return theDefaultRound;
    }

    public static void defaultRound(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException();
        }
        theDefaultRound = d;
    }

    public Rectangle outline(Outline outline) {
        this.doOutline(outline);
        return this;
    }

    public Rectangle fill(Fill fill) {
        this.doFill(fill);
        return this;
    }

    public Rectangle size(Size size) {
        this.doSize(size);
        return this;
    }

    public Rectangle width(double d) {
        this.doWidth(d);
        return this;
    }

    public Rectangle height(double d) {
        this.doHeight(d);
        return this;
    }

    public Rectangle nw(double d, double d2) {
        this.doNw(d, d2);
        return this;
    }

    public Rectangle nw(Point point) {
        this.doNw(point.x, point.y);
        return this;
    }

    public Rectangle n(double d, double d2) {
        this.doN(d, d2);
        return this;
    }

    public Rectangle n(Point point) {
        this.doN(point.x, point.y);
        return this;
    }

    public Rectangle ne(double d, double d2) {
        this.doNe(d, d2);
        return this;
    }

    public Rectangle ne(Point point) {
        this.doNe(point.x, point.y);
        return this;
    }

    public Rectangle w(double d, double d2) {
        this.doW(d, d2);
        return this;
    }

    public Rectangle w(Point point) {
        this.doW(point.x, point.y);
        return this;
    }

    public Rectangle c(double d, double d2) {
        this.doC(d, d2);
        return this;
    }

    public Rectangle c(Point point) {
        this.doC(point.x, point.y);
        return this;
    }

    public Rectangle e(double d, double d2) {
        this.doE(d, d2);
        return this;
    }

    public Rectangle e(Point point) {
        this.doE(point.x, point.y);
        return this;
    }

    public Rectangle sw(double d, double d2) {
        this.doSw(d, d2);
        return this;
    }

    public Rectangle sw(Point point) {
        this.doSw(point.x, point.y);
        return this;
    }

    public Rectangle s(double d, double d2) {
        this.doS(d, d2);
        return this;
    }

    public Rectangle s(Point point) {
        this.doS(point.x, point.y);
        return this;
    }

    public Rectangle se(double d, double d2) {
        this.doSe(d, d2);
        return this;
    }

    public Rectangle se(Point point) {
        this.doSe(point.x, point.y);
        return this;
    }

    public double round() {
        return this.myRound;
    }

    public Rectangle round(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException();
        }
        this.myRound = d;
        return this;
    }

    public Rectangle add() {
        this.doAdd(Drawing.defaultDrawing());
        return this;
    }

    public Rectangle add(Drawing drawing) {
        this.doAdd(drawing);
        return this;
    }

    public Rectangle addFirst() {
        this.doAddFirst(Drawing.defaultDrawing());
        return this;
    }

    public Rectangle addFirst(Drawing drawing) {
        this.doAddFirst(drawing);
        return this;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeDouble(this.myRound);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.myRound = objectInput.readDouble();
    }

    Shape getShape() {
        Point point = this.nw();
        return this.myRound == 0.0 ? new Rectangle2D.Double(point.x, point.y, this.width, this.height) : new RoundRectangle2D.Double(point.x, point.y, this.width, this.height, 2.0 * this.myRound, 2.0 * this.myRound);
    }
}

