/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.compbio.phyl;

import edu.rit.compbio.phyl.DnaSequenceList;
import edu.rit.compbio.phyl.DnaSequenceTree;
import edu.rit.compbio.phyl.FitchParsimony;
import edu.rit.compbio.phyl.JukesCantorDistance;
import edu.rit.compbio.phyl.MaximumParsimonyBnbHyb;
import edu.rit.compbio.phyl.MaximumParsimonyResults;
import edu.rit.compbio.phyl.Results;
import edu.rit.compbio.phyl.Upgma;
import edu.rit.mp.IntegerBuf;
import edu.rit.mp.ObjectBuf;
import edu.rit.mp.buf.IntegerItemBuf;
import edu.rit.mp.buf.ObjectItemBuf;
import edu.rit.pj.Comm;
import edu.rit.pj.CommStatus;
import edu.rit.pj.IntegerSchedule;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelTeam;
import edu.rit.pj.reduction.IntegerOp;
import edu.rit.pj.replica.ReplicatedInteger;
import edu.rit.util.Range;
import java.io.File;
import java.io.IOException;

public class PhylogenyParsBnbHyb {
    private static final int MAX_START_LEVEL = 6;
    private static Comm world;
    private static int size;
    private static int rank;
    private static File infile;
    private static File outdir;
    private static int N;
    private static int T;
    private static DnaSequenceList seqList;
    private static DnaSequenceList sortedList;
    private static DnaSequenceList excisedList;
    private static ReplicatedInteger bound;
    private static MaximumParsimonyResults globalResults;
    private static int startLevel;
    private static int vertexCount;
    private static int Kt;
    private static int Klower;
    private static int K;

    private PhylogenyParsBnbHyb() {
    }

    public static void main(String[] stringArray) throws Exception {
        long l = System.currentTimeMillis();
        Comm.init(stringArray);
        world = Comm.world();
        size = world.size();
        rank = world.rank();
        if (stringArray.length < 2 || stringArray.length > 4) {
            PhylogenyParsBnbHyb.usage();
        }
        infile = new File(stringArray[0]);
        outdir = new File(stringArray[1]);
        T = 100;
        if (stringArray.length >= 4) {
            T = Integer.parseInt(stringArray[3]);
        }
        seqList = DnaSequenceList.read(infile);
        N = seqList.length();
        if (stringArray.length >= 3) {
            N = Integer.parseInt(stringArray[2]);
        }
        seqList.truncate(N);
        DnaSequenceTree dnaSequenceTree = Upgma.buildTree(seqList, new JukesCantorDistance());
        int n = FitchParsimony.computeScore(dnaSequenceTree);
        sortedList = dnaSequenceTree.toList();
        excisedList = new DnaSequenceList(sortedList);
        int n2 = excisedList.exciseUninformativeSites();
        bound = MaximumParsimonyBnbHyb.createBoundVariable(n - n2, world, Integer.MAX_VALUE);
        globalResults = new MaximumParsimonyResults(T);
        startLevel = Math.min(6, N - 1);
        vertexCount = 1;
        for (int i = 2 * startLevel - 1; i > 1; i -= 2) {
            vertexCount *= i;
        }
        Kt = ParallelTeam.getDefaultThreadCount();
        IntegerItemBuf integerItemBuf = IntegerBuf.buffer(Kt);
        world.exclusiveScan(integerItemBuf, IntegerOp.SUM, null);
        Klower = integerItemBuf.item;
        integerItemBuf.item = Kt;
        world.reduce(0, integerItemBuf, IntegerOp.SUM);
        K = integerItemBuf.item;
        long l2 = System.currentTimeMillis();
        new ParallelTeam(rank == 0 ? Kt + 1 : Kt).execute(new ParallelRegion(){

            public void run() throws Exception {
                int n = this.getThreadIndex();
                if (n == Kt) {
                    PhylogenyParsBnbHyb.master();
                } else {
                    PhylogenyParsBnbHyb.worker(Klower + n);
                }
            }
        });
        globalResults.score(globalResults.score() + n2);
        long l3 = System.currentTimeMillis();
        if (rank == 0) {
            Results.report(outdir, "edu.rit.compbio.phyl.PhylogenyParsBnbHyb", Comm.world().host(), K, infile, seqList, sortedList, n, T, globalResults, l, l2, l3);
        }
        long l4 = System.currentTimeMillis();
        System.out.println(l2 - l + " msec pre " + rank);
        System.out.println(l3 - l2 + " msec calc " + rank);
        System.out.println(l4 - l3 + " msec post " + rank);
        System.out.println(l4 - l + " msec total " + rank);
    }

    private static void master() throws IOException {
        IntegerSchedule integerSchedule = IntegerSchedule.runtime(IntegerSchedule.dynamic(1));
        integerSchedule.start(K, new Range(0, vertexCount - 1));
        ObjectItemBuf objectItemBuf = ObjectBuf.buffer();
        Range range = new Range(0, K - 1);
        int n = K;
        while (n > 0) {
            CommStatus commStatus = world.receive(null, range, objectItemBuf);
            int n2 = commStatus.fromRank;
            int n3 = commStatus.tag;
            Range range2 = integerSchedule.next(n3);
            world.send(n2, n3, ObjectBuf.buffer(range2));
            if (range2 == null) {
                --n;
            }
            globalResults.addAll((MaximumParsimonyResults)objectItemBuf.item);
        }
    }

    private static void worker(int n) throws IOException {
        MaximumParsimonyResults maximumParsimonyResults = new MaximumParsimonyResults(T);
        ObjectItemBuf objectItemBuf = ObjectBuf.buffer();
        MaximumParsimonyBnbHyb maximumParsimonyBnbHyb = new MaximumParsimonyBnbHyb(excisedList, bound, maximumParsimonyResults);
        while (true) {
            world.send(0, n, ObjectBuf.buffer(new MaximumParsimonyResults(maximumParsimonyResults)));
            world.receive((Integer)0, n, objectItemBuf);
            Range range = (Range)objectItemBuf.item;
            if (range == null) break;
            maximumParsimonyResults.clear();
            maximumParsimonyBnbHyb.findTrees(startLevel, range.lb(), range.ub());
        }
    }

    private static void usage() {
        System.err.println("Usage: java [-Dpj.np=<Kp>] [-Dpj.nt=<Kt>] [-Dpj.schedule=<schedule>] edu.rit.compbio.phyl.PhylogenyParsBnbHyb <infile> <outdir> [<N> [<T>]]");
        System.err.println("<Kp> = Number of parallel processes (default: 1)");
        System.err.println("<Kt> = Number of parallel threads per process (default: number of CPUs)");
        System.err.println("<schedule> = Load balancing schedule (default: dynamic(1))");
        System.err.println("<infile> = Input DNA sequence list file name");
        System.err.println("<outdir> = Output directory name");
        System.err.println("<N> = Number of DNA sequences to use (default: all)");
        System.err.println("<T> = Number of trees to report (default: 100)");
        System.exit(1);
    }
}

