/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.bio;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import org.bridgedb.DataSource;
import org.bridgedb.DataSourcePatterns;
import org.bridgedb.bio.DataSourceTxt;
import org.bridgedb.bio.Organism;
import org.bridgedb.impl.InternalUtils;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class BioDataSource {
    public static final DataSource TAIR = DataSource.register((String)"A", (String)"TAIR").asDataSource();
    public static final DataSource AGILENT = DataSource.register((String)"Ag", (String)"Agilent").asDataSource();
    public static final DataSource BIOGRID = DataSource.register((String)"Bg", (String)"BioGrid").asDataSource();
    public static final DataSource BIOCYC = DataSource.register((String)"Bc", (String)"BioCyc").asDataSource();
    public static final DataSource CCDS = DataSource.register((String)"Cc", (String)"CCDS").asDataSource();
    public static final DataSource CAS = DataSource.register((String)"Ca", (String)"CAS").asDataSource();
    public static final DataSource CHEBI = DataSource.register((String)"Ce", (String)"ChEBI").asDataSource();
    public static final DataSource HMDB = DataSource.register((String)"Ch", (String)"HMDB").asDataSource();
    public static final DataSource KEGG_COMPOUND = DataSource.register((String)"Ck", (String)"KEGG Compound").asDataSource();
    public static final DataSource PUBCHEM = DataSource.register((String)"Cp", (String)"PubChem").asDataSource();
    public static final DataSource PUBCHEM_SUBSTANCE = DataSource.register((String)"Cps", (String)"PubChem-substance").asDataSource();
    public static final DataSource PUBCHEM_COMPOUND = DataSource.register((String)"Cpc", (String)"PubChem-compound").asDataSource();
    public static final DataSource CHEMSPIDER = DataSource.register((String)"Cs", (String)"Chemspider").asDataSource();
    public static final DataSource SGD = DataSource.register((String)"D", (String)"SGD").asDataSource();
    public static final DataSource ENZYME_CODE = DataSource.register((String)"E", (String)"Enzyme Nomenclature").asDataSource();
    public static final DataSource ECOLI = DataSource.register((String)"Ec", (String)"EcoGene").asDataSource();
    public static final DataSource EMBL = DataSource.register((String)"Em", (String)"EMBL").asDataSource();
    public static final DataSource ENSEMBL = DataSource.register((String)"En", (String)"Ensembl").asDataSource();
    public static final DataSource ENSEMBL_MOSQUITO = DataSource.register((String)"EnAg", (String)"Ensembl Mosquito").asDataSource();
    public static final DataSource GRAMENE_ARABIDOPSIS = DataSource.register((String)"EnAt", (String)"Gramene Arabidopsis").asDataSource();
    public static final DataSource ENSEMBL_BSUBTILIS = DataSource.register((String)"EnBs", (String)"Ensembl B. subtilis").asDataSource();
    public static final DataSource ENSEMBL_COW = DataSource.register((String)"EnBt", (String)"Ensembl Cow").asDataSource();
    public static final DataSource ENSEMBL_CELEGANS = DataSource.register((String)"EnCe", (String)"Ensembl C. elegans").asDataSource();
    public static final DataSource ENSEMBL_DOG = DataSource.register((String)"EnCf", (String)"Ensembl Dog").asDataSource();
    public static final DataSource ENSEMBL_FRUITFLY = DataSource.register((String)"EnDm", (String)"Ensembl Fruitfly").asDataSource();
    public static final DataSource ENSEMBL_ZEBRAFISH = DataSource.register((String)"EnDr", (String)"Ensembl Zebrafish").asDataSource();
    public static final DataSource ENSEMBL_ECOLI = DataSource.register((String)"EnEc", (String)"Ensembl E. coli").asDataSource();
    public static final DataSource ENSEMBL_CHICKEN = DataSource.register((String)"EnGg", (String)"Ensembl Chicken").asDataSource();
    public static final DataSource ENSEMBL_HUMAN = DataSource.register((String)"EnHs", (String)"Ensembl Human").asDataSource();
    public static final DataSource ENSEMBL_MOUSE = DataSource.register((String)"EnMm", (String)"Ensembl Mouse").asDataSource();
    public static final DataSource ENSEMBL_MTUBERCULOSIS = DataSource.register((String)"EnMx", (String)"Ensembl M. tuberculosis").asDataSource();
    public static final DataSource GRAMENE_RICE = DataSource.register((String)"EnOj", (String)"Gramene Rice").asDataSource();
    public static final DataSource ENSEMBL_CHIMP = DataSource.register((String)"EnPt", (String)"Ensembl Chimp").asDataSource();
    public static final DataSource ENSEMBL_HORSE = DataSource.register((String)"EnQc", (String)"Ensembl Horse").asDataSource();
    public static final DataSource ENSEMBL_RAT = DataSource.register((String)"EnRn", (String)"Ensembl Rat").asDataSource();
    public static final DataSource ENSEMBL_SCEREVISIAE = DataSource.register((String)"EnSc", (String)"Ensembl Yeast").asDataSource();
    public static final DataSource ENSEMBL_XENOPUS = DataSource.register((String)"EnXt", (String)"Ensembl Xenopus").asDataSource();
    public static final DataSource FLYBASE = DataSource.register((String)"F", (String)"FlyBase").asDataSource();
    public static final DataSource GENBANK = DataSource.register((String)"G", (String)"GenBank").asDataSource();
    public static final DataSource CODELINK = DataSource.register((String)"Ge", (String)"CodeLink").asDataSource();
    public static final DataSource GRAMENE_GENES_DB = DataSource.register((String)"Gg", (String)"Gramene Genes DB").asDataSource();
    public static final DataSource GRAMENE_LITERATURE = DataSource.register((String)"Gl", (String)"Gramene Literature").asDataSource();
    public static final DataSource GRAMENE_PATHWAY = DataSource.register((String)"Gp", (String)"Gramene Pathway").asDataSource();
    public static final DataSource GENE_WIKI = DataSource.register((String)"Gw", (String)"Gene Wiki").asDataSource();
    public static final DataSource HUGO = DataSource.register((String)"H", (String)"HGNC").asDataSource();
    public static final DataSource HSGENE = DataSource.register((String)"Hs", (String)"HsGene").asDataSource();
    public static final DataSource INTERPRO = DataSource.register((String)"I", (String)"InterPro").asDataSource();
    public static final DataSource ILLUMINA = DataSource.register((String)"Il", (String)"Illumina").asDataSource();
    public static final DataSource IPI = DataSource.register((String)"Ip", (String)"IPI").asDataSource();
    public static final DataSource IRGSP_GENE = DataSource.register((String)"Ir", (String)"IRGSP Gene").asDataSource();
    public static final DataSource KEGG_GENES = DataSource.register((String)"Kg", (String)"KEGG Genes").asDataSource();
    public static final DataSource ENTREZ_GENE = DataSource.register((String)"L", (String)"Entrez Gene").asDataSource();
    public static final DataSource MGI = DataSource.register((String)"M", (String)"MGI").asDataSource();
    public static final DataSource MIRBASE = DataSource.register((String)"Mb", (String)"miRBase Sequence").asDataSource();
    public static final DataSource MIRBASE_MATURE = DataSource.register((String)"Mbm", (String)"miRBase mature sequence").asDataSource();
    public static final DataSource MAIZE_GDB = DataSource.register((String)"Mg", (String)"MaizeGDB").asDataSource();
    public static final DataSource NASC_GENE = DataSource.register((String)"N", (String)"NASC Gene").asDataSource();
    public static final DataSource NUGOWIKI = DataSource.register((String)"Nw", (String)"NuGO wiki").asDataSource();
    public static final DataSource OTHER = DataSource.register((String)"O", (String)"Other").asDataSource();
    public static final DataSource ORYZA_BASE = DataSource.register((String)"Ob", (String)"Oryzabase").asDataSource();
    public static final DataSource OMIM = DataSource.register((String)"Om", (String)"OMIM").asDataSource();
    public static final DataSource RICE_ENSEMBL_GENE = DataSource.register((String)"Os", (String)"Rice Ensembl Gene").asDataSource();
    public static final DataSource PDB = DataSource.register((String)"Pd", (String)"PDB").asDataSource();
    public static final DataSource PFAM = DataSource.register((String)"Pf", (String)"Pfam").asDataSource();
    public static final DataSource PLANTGDB = DataSource.register((String)"Pl", (String)"PlantGDB").asDataSource();
    public static final DataSource REFSEQ = DataSource.register((String)"Q", (String)"RefSeq").asDataSource();
    public static final DataSource RGD = DataSource.register((String)"R", (String)"RGD").asDataSource();
    public static final DataSource REACTOME = DataSource.register((String)"Re", (String)"Reactome").asDataSource();
    public static final DataSource KEGG_REACTION = DataSource.register((String)"Rk", (String)"KEGG Reaction").asDataSource();
    public static final DataSource RFAM = DataSource.register((String)"Rf", (String)"Rfam").asDataSource();
    public static final DataSource UNIPROT = DataSource.register((String)"S", (String)"Uniprot-TrEMBL").asDataSource();
    public static final DataSource UNIPROT_SWISSPROT = DataSource.register((String)"Sp", (String)"Uniprot-SwissProt").asDataSource();
    public static final DataSource SNP = DataSource.register((String)"Sn", (String)"dbSNP").asDataSource();
    public static final DataSource GENE_ONTOLOGY = DataSource.register((String)"T", (String)"GeneOntology").asDataSource();
    public static final DataSource TAXONOMY_NCBI = DataSource.register((String)"Tn", (String)"NCBI Taxonomy Database").asDataSource();
    public static final DataSource TIGR = DataSource.register((String)"Ti", (String)"TIGR").asDataSource();
    public static final DataSource TUBERCULIST = DataSource.register((String)"Tb", (String)"TubercuList").asDataSource();
    public static final DataSource UNIGENE = DataSource.register((String)"U", (String)"UniGene").asDataSource();
    public static final DataSource UCSC = DataSource.register((String)"Uc", (String)"UCSC Genome Browser").asDataSource();
    public static final DataSource WORMBASE = DataSource.register((String)"W", (String)"WormBase").asDataSource();
    public static final DataSource WIKIGENE = DataSource.register((String)"Wg", (String)"WikiGenes").asDataSource();
    public static final DataSource WIKIPEDIA = DataSource.register((String)"Wi", (String)"Wikipedia").asDataSource();
    public static final DataSource WIKIPATHWAYS = DataSource.register((String)"Wp", (String)"WikiPathways").asDataSource();
    public static final DataSource WHEAT_GENE_NAMES = DataSource.register((String)"Wn", (String)"Wheat gene names").asDataSource();
    public static final DataSource WHEAT_GENE_REFERENCES = DataSource.register((String)"Wr", (String)"Wheat gene refs").asDataSource();
    public static final DataSource AFFY = DataSource.register((String)"X", (String)"Affy").asDataSource();
    public static final DataSource ZFIN = DataSource.register((String)"Z", (String)"ZFIN").asDataSource();
    public static final DataSource RHEA = DataSource.register((String)"Rh", (String)"Rhea").asDataSource();
    public static final DataSource MACIE = DataSource.register((String)"Ma", (String)"MACiE").asDataSource();
    public static final DataSource UNIPATHWAY = DataSource.register((String)"Up", (String)"Unipathway").asDataSource();
    private static final Map<Organism, DataSource> ensemblBySpecies = new HashMap<Organism, DataSource>();

    public static DataSource getSpeciesSpecificEnsembl(Organism org) {
        return ensemblBySpecies.get((Object)org);
    }

    public static void init() {
        InputStream is = BioDataSource.class.getClassLoader().getResourceAsStream("org/bridgedb/bio/datasources.txt");
        try {
            DataSourceTxt.loadInputStream(is);
            InternalUtils.readXmlConfig((InputSource)new InputSource(BioDataSource.class.getClassLoader().getResourceAsStream("org/bridgedb/bio/datasources.xml")));
        }
        catch (IOException ex) {
            throw new Error(ex);
        }
        catch (ParserConfigurationException e) {
            throw new Error(e);
        }
        catch (SAXException e) {
            throw new Error(e);
        }
    }

    static {
        DataSourcePatterns.registerPattern((DataSource)TAXONOMY_NCBI, (Pattern)Pattern.compile("\\d+"));
        DataSourcePatterns.registerPattern((DataSource)SGD, (Pattern)Pattern.compile("S\\d{9}"));
        DataSourcePatterns.registerPattern((DataSource)FLYBASE, (Pattern)Pattern.compile("(C[RG]\\d{4,5}|FBgn\\d{7})"));
        DataSourcePatterns.registerPattern((DataSource)GENBANK, (Pattern)Pattern.compile("(\\w\\d{5})|(\\w{2}\\d{6})|(\\w{3}\\d{5})"));
        DataSourcePatterns.registerPattern((DataSource)INTERPRO, (Pattern)Pattern.compile("IPR\\d{6}"));
        DataSourcePatterns.registerPattern((DataSource)ENTREZ_GENE, (Pattern)Pattern.compile("\\d+"));
        DataSourcePatterns.registerPattern((DataSource)GENE_WIKI, (Pattern)Pattern.compile("\\d+"));
        DataSourcePatterns.registerPattern((DataSource)MGI, (Pattern)Pattern.compile("MGI:\\d+"));
        DataSourcePatterns.registerPattern((DataSource)RFAM, (Pattern)Pattern.compile("RF\\d+"));
        DataSourcePatterns.registerPattern((DataSource)IPI, (Pattern)Pattern.compile("IPI\\d+"));
        DataSourcePatterns.registerPattern((DataSource)UCSC, (Pattern)Pattern.compile("uc\\d{3}[a-z]{3}\\.\\d"));
        DataSourcePatterns.registerPattern((DataSource)ILLUMINA, (Pattern)Pattern.compile("ILMN_\\d+"));
        DataSourcePatterns.registerPattern((DataSource)MIRBASE, (Pattern)Pattern.compile("MI\\d+"));
        DataSourcePatterns.registerPattern((DataSource)REFSEQ, (Pattern)Pattern.compile("\\w{2}_\\d+"));
        DataSourcePatterns.registerPattern((DataSource)RGD, (Pattern)Pattern.compile("RGD:\\d+"));
        DataSourcePatterns.registerPattern((DataSource)UNIPROT, (Pattern)Pattern.compile("([A-N,R-][0-9][A-Z][A-Z,0-9][A-Z,0-9][0-9])|([O,P,Q][0-9][A-Z,0-9][A-Z,0-9][A-Z,0-9][0-9])"));
        DataSourcePatterns.registerPattern((DataSource)UNIPROT_SWISSPROT, (Pattern)Pattern.compile("[A-Z0-9]+_[A-Z]+"));
        DataSourcePatterns.registerPattern((DataSource)GENE_ONTOLOGY, (Pattern)Pattern.compile("GO:\\d+"));
        DataSourcePatterns.registerPattern((DataSource)UNIGENE, (Pattern)Pattern.compile("[A-Z][a-z][a-z]?\\.\\d+"));
        DataSourcePatterns.registerPattern((DataSource)WORMBASE, (Pattern)Pattern.compile("WBGene\\d{8}"));
        DataSourcePatterns.registerPattern((DataSource)AFFY, (Pattern)Pattern.compile(".+_at"));
        DataSourcePatterns.registerPattern((DataSource)ENSEMBL_HUMAN, (Pattern)Pattern.compile("ENSG\\d{11}"));
        DataSourcePatterns.registerPattern((DataSource)ENSEMBL_MOUSE, (Pattern)Pattern.compile("ENSMUSG\\d{11}"));
        DataSourcePatterns.registerPattern((DataSource)ENSEMBL_RAT, (Pattern)Pattern.compile("ENSRNOG\\d{11}"));
        DataSourcePatterns.registerPattern((DataSource)ENSEMBL_MOSQUITO, (Pattern)Pattern.compile("AGAP\\d{6}"));
        DataSourcePatterns.registerPattern((DataSource)ENSEMBL_BSUBTILIS, (Pattern)Pattern.compile("EBBACG\\d{11}"));
        DataSourcePatterns.registerPattern((DataSource)ENSEMBL_ECOLI, (Pattern)Pattern.compile("EBESCG\\d{11}"));
        DataSourcePatterns.registerPattern((DataSource)ENSEMBL_CHICKEN, (Pattern)Pattern.compile("ENSGALG\\d{11}"));
        DataSourcePatterns.registerPattern((DataSource)ENSEMBL_HORSE, (Pattern)Pattern.compile("ENSECAG\\d{11}"));
        DataSourcePatterns.registerPattern((DataSource)ENSEMBL_XENOPUS, (Pattern)Pattern.compile("ENSXETG\\d{11}"));
        DataSourcePatterns.registerPattern((DataSource)ENSEMBL_CHIMP, (Pattern)Pattern.compile("ENSPTRG\\d{11}"));
        DataSourcePatterns.registerPattern((DataSource)ENSEMBL_COW, (Pattern)Pattern.compile("ENSBTAG\\d{11}"));
        DataSourcePatterns.registerPattern((DataSource)ENSEMBL_DOG, (Pattern)Pattern.compile("ENSCAFG\\d{11}"));
        DataSourcePatterns.registerPattern((DataSource)ENSEMBL_ZEBRAFISH, (Pattern)Pattern.compile("ENSDARG\\d{11}"));
        DataSourcePatterns.registerPattern((DataSource)ENSEMBL_MTUBERCULOSIS, (Pattern)Pattern.compile("EBMYCG\\d{11}"));
        DataSourcePatterns.registerPattern((DataSource)ENSEMBL_FRUITFLY, (Pattern)Pattern.compile("FBgn\\d{7}"));
        DataSourcePatterns.registerPattern((DataSource)ENSEMBL_SCEREVISIAE, (Pattern)Pattern.compile("Y[A-Z][RL]\\d{3}[WC](?:\\-[A-Z])?"));
        DataSourcePatterns.registerPattern((DataSource)TAIR, (Pattern)Pattern.compile("AT[\\dCM]G\\d{5}"));
        DataSourcePatterns.registerPattern((DataSource)GRAMENE_ARABIDOPSIS, (Pattern)Pattern.compile("AT[\\dCM]G\\d{5}\\-TAIR\\-G"));
        DataSourcePatterns.registerPattern((DataSource)IRGSP_GENE, (Pattern)Pattern.compile("Os\\d{2}g\\d+"));
        DataSourcePatterns.registerPattern((DataSource)GRAMENE_GENES_DB, (Pattern)Pattern.compile("GR:\\d+"));
        DataSourcePatterns.registerPattern((DataSource)BIOGRID, (Pattern)Pattern.compile("\\d+"));
        DataSourcePatterns.registerPattern((DataSource)NASC_GENE, (Pattern)Pattern.compile("AT[\\dCM]G\\d{5}\\-TAIR\\-G"));
        DataSourcePatterns.registerPattern((DataSource)PLANTGDB, (Pattern)Pattern.compile("PUT-[\\w\\d-]+"));
        DataSourcePatterns.registerPattern((DataSource)EMBL, (Pattern)Pattern.compile("\\w{2}\\d{6}"));
        DataSourcePatterns.registerPattern((DataSource)HUGO, (Pattern)Pattern.compile("[A-Z][A-Z,0-9]+"));
        DataSourcePatterns.registerPattern((DataSource)OMIM, (Pattern)Pattern.compile("\\d{6}(\\.\\d{4})?"));
        DataSourcePatterns.registerPattern((DataSource)PDB, (Pattern)Pattern.compile("\\d[A-Z\\d]{3}"));
        DataSourcePatterns.registerPattern((DataSource)PFAM, (Pattern)Pattern.compile("(PF\\d{5})|(PB\\d{6})"));
        DataSourcePatterns.registerPattern((DataSource)ZFIN, (Pattern)Pattern.compile("ZDB.+"));
        DataSourcePatterns.registerPattern((DataSource)AGILENT, (Pattern)Pattern.compile("A_\\d+_.+"));
        DataSourcePatterns.registerPattern((DataSource)HMDB, (Pattern)Pattern.compile("HMDB\\d{5}"));
        DataSourcePatterns.registerPattern((DataSource)CAS, (Pattern)Pattern.compile("\\d+-\\d{2}-\\d{1}"));
        DataSourcePatterns.registerPattern((DataSource)ENZYME_CODE, (Pattern)Pattern.compile("(\\d+\\.){3}\\d+"));
        DataSourcePatterns.registerPattern((DataSource)CHEBI, (Pattern)Pattern.compile("CHEBI\\:\\d+"));
        DataSourcePatterns.registerPattern((DataSource)KEGG_COMPOUND, (Pattern)Pattern.compile("C\\d+"));
        DataSourcePatterns.registerPattern((DataSource)KEGG_GENES, (Pattern)Pattern.compile("[a-z]{3}:.+"));
        DataSourcePatterns.registerPattern((DataSource)BIOCYC, (Pattern)Pattern.compile("^\\w+\\:[A-Za-z0-9-]+$"));
        DataSourcePatterns.registerPattern((DataSource)TUBERCULIST, (Pattern)Pattern.compile("Rv\\d{4}(A|B|c|\\.\\d)?"));
        DataSourcePatterns.registerPattern((DataSource)RHEA, (Pattern)Pattern.compile("^\\d{5}$"));
        DataSourcePatterns.registerPattern((DataSource)MACIE, (Pattern)Pattern.compile("^M\\d{4}$"));
        DataSourcePatterns.registerPattern((DataSource)UNIPATHWAY, (Pattern)Pattern.compile("^UPA\\d{5}$"));
        ensemblBySpecies.put(Organism.BacillusSubtilis, ENSEMBL_BSUBTILIS);
        ensemblBySpecies.put(Organism.CaenorhabditisElegans, ENSEMBL_CELEGANS);
        ensemblBySpecies.put(Organism.GallusGallus, ENSEMBL_CHICKEN);
        ensemblBySpecies.put(Organism.PanTroglodytes, ENSEMBL_CHIMP);
        ensemblBySpecies.put(Organism.BosTaurus, ENSEMBL_COW);
        ensemblBySpecies.put(Organism.CanisFamiliaris, ENSEMBL_DOG);
        ensemblBySpecies.put(Organism.EscherichiaColi, ENSEMBL_ECOLI);
        ensemblBySpecies.put(Organism.DrosophilaMelanogaster, ENSEMBL_FRUITFLY);
        ensemblBySpecies.put(Organism.EquusCaballus, ENSEMBL_HORSE);
        ensemblBySpecies.put(Organism.HomoSapiens, ENSEMBL_HUMAN);
        ensemblBySpecies.put(Organism.AnophelesGambiae, ENSEMBL_MOSQUITO);
        ensemblBySpecies.put(Organism.MusMusculus, ENSEMBL_MOUSE);
        ensemblBySpecies.put(Organism.RattusNorvegicus, ENSEMBL_RAT);
        ensemblBySpecies.put(Organism.SaccharomycesCerevisiae, ENSEMBL_SCEREVISIAE);
        ensemblBySpecies.put(Organism.XenopusTropicalis, ENSEMBL_XENOPUS);
        ensemblBySpecies.put(Organism.DanioRerio, ENSEMBL_ZEBRAFISH);
        ensemblBySpecies.put(Organism.MycobacteriumTuberculosis, ENSEMBL_MTUBERCULOSIS);
        DataSourcePatterns.registerPattern((DataSource)KEGG_REACTION, (Pattern)Pattern.compile("^R\\d+$"));
        DataSourcePatterns.registerPattern((DataSource)REACTOME, (Pattern)Pattern.compile("^REACT_\\d+(\\.\\d+)?$"));
    }
}

