## ---- include = FALSE----------------------------------------------------
knitr::opts_chunk$set(
    eval = AnVIL::gcloud_exists(), collapse = TRUE, cache = TRUE
)
options(width=75)

## ---- eval = FALSE-------------------------------------------------------
#  if (!requireNamespace("BiocManager", quietly = TRUE))
#      install.packages("BiocManager", repos = "https://cran.r-project.org")
#  BiocManager::install("AnVIL")

## ---- message =FALSE, eval = TRUE----------------------------------------
library(AnVIL)

## ---- eval = FALSE-------------------------------------------------------
#  dir(file.path(Sys.getenv("GCLOUD_SDK_PATH"), "bin"), "^(gcloud|gsutil)$")
#  ## [1] "gcloud" "gsutil"

## ---- eval = TRUE--------------------------------------------------------
## the code chunks in this vignette are fully evaluated when
## gcloud_exists() returns TRUE
gcloud_exists()

## ---- eval = FALSE-------------------------------------------------------
#  AnVIL::install("GenomicFeatures")

## ---- eval = FALSE-------------------------------------------------------
#  add_libpaths("~/my/project")

## ------------------------------------------------------------------------
#  gcloud_account() # authentication account
#  gcloud_project() # billing project information

## ------------------------------------------------------------------------
#  gcloud_cmd("projects", "list") %>%
#      readr::read_table() %>%
#      filter(startsWith(PROJECT_ID, "anvil"))

## ------------------------------------------------------------------------
#  gcloud_help("projects")

## ------------------------------------------------------------------------
#  src <- "gs://genomics-public-data/1000-genomes/"

## ------------------------------------------------------------------------
#  gsutil_ls(src)
#  
#  other <- paste0(src, "other")
#  gsutil_ls(other, recursive = TRUE)
#  
#  sample_info <- paste0(src, "other/sample_info/sample_info.csv")
#  gsutil_stat(sample_info)

## ------------------------------------------------------------------------
#  fl <- tempfile()
#  gsutil_cp(sample_info, fl)
#  
#  csv <- readr::read_csv(fl, guess_max = 5000L)
#  csv

## ------------------------------------------------------------------------
#  pipe <- gsutil_pipe(fl)
#  readr::read_csv(pipe, guess_max = 5000L) %>%
#      dplyr::select("Sample", "Family_ID", "Population", "Gender")

## ------------------------------------------------------------------------
#  destination <- tempfile()
#  stopifnot(dir.create(destination))
#  source <- paste0(src, "other/sample_info")
#  
#  ## dry run
#  gsutil_rsync(source, destination)
#  
#  gsutil_rsync(source, destination, dry = FALSE)
#  dir(destination, recursive = TRUE)
#  
#  ## nothing to synchronize
#  gsutil_rsync(source, destination, dry = FALSE)
#  
#  ## one file requires synchronization
#  unlink(file.path(destination, "README"))
#  gsutil_rsync(source, destination, dry = FALSE)

## ----echo = FALSE--------------------------------------------------------
#  knitr::include_graphics('images/AnVIL-Workspace-Data.png')

## ---- include = FALSE----------------------------------------------------
#  ## N.B.: IT IS NOT NECESSARY TO SET THESE WHEN ON ANVIL
#  avworkspace_namespace("pathogen-genomic-surveillance")
#  avworkspace_name("COVID-19")

## ------------------------------------------------------------------------
#  avworkspace_namespace()
#  avworkspace_name()

## ------------------------------------------------------------------------
#  ## N.B.: IT IS NOT NECESSARY TO SET THESE WHEN ON ANVIL
#  avworkspace_namespace("pathogen-genomic-surveillance")
#  avworkspace_name("COVID-19")

## ------------------------------------------------------------------------
#  avtables()
#  sample <- avtable("sample")
#  sample

## ------------------------------------------------------------------------
#  sample %>%
#      select(name, contains("fasta")) %>%
#      filter(!is.na(final_assembly_fasta))

## ---- eval = FALSE-------------------------------------------------------
#  mtcars %>%
#      mutate(cyl = factor(cyl)) %>%
#      avtable_import()

## ------------------------------------------------------------------------
#  avdata()

## ------------------------------------------------------------------------
#  files <- avbucket()
#  files

## ------------------------------------------------------------------------
#  gsutil_ls(files)

## ---- eval = FALSE-------------------------------------------------------
#  ## requires workspace ownership
#  uri <- avbucket()                             # discover bucket
#  bucket <- file.path(uri, "mtcars.tab")
#  write.table(mtcars, gsutil_pipe(bucket, "w")) # write to bucket

## ------------------------------------------------------------------------
#  terra <- Terra()

## ------------------------------------------------------------------------
#  terra

## ------------------------------------------------------------------------
#  terra %>% tags("Status")

## ------------------------------------------------------------------------
#  terra$status
#  terra$status()

## ------------------------------------------------------------------------
#  status <- terra$status()
#  class(status)

## ------------------------------------------------------------------------
#  str(status)

## ------------------------------------------------------------------------
#  lst <- status %>% as.list()
#  lengths(lst)
#  lengths(lst$systems)
#  str(lst$systems)

## ------------------------------------------------------------------------
#  .MyService <- setClass("MyService", contains = "Service")
#  
#  MyService <-
#      function()
#  {
#      .MyService(Service(
#          "myservice",
#          host = "api.firecloud.org",
#          api_url = "https://api.firecloud.org/api-docs.yaml",
#          authenticate = FALSE
#      ))
#  }

## ----sessionInfo, echo=FALSE---------------------------------------------
#  sessionInfo()

