## ----style, echo = FALSE, results = 'asis'------------------------------------
BiocStyle::markdown()
options(width=80, max.print=1000)
knitr::opts_chunk$set(
    eval=as.logical(Sys.getenv("KNITR_EVAL", "TRUE")),
    cache=as.logical(Sys.getenv("KNITR_CACHE", "TRUE")), 
    tidy.opts=list(width.cutoff=80), tidy=TRUE)

## ----setup, echo=FALSE, messages=FALSE, warnings=FALSE------------------------
suppressPackageStartupMessages({
    library(systemPipeR)
    library(BiocParallel)
    library(Biostrings)
    library(Rsamtools)
    library(GenomicRanges)
    library(ggplot2)
    library(GenomicAlignments)
    library(ShortRead)
    library(ape)
    library(batchtools)
})

## ----genRna_workflow_single, eval=FALSE---------------------------------------
#  library(systemPipeRdata)
#  genWorkenvir(workflow="rnaseq")
#  setwd("rnaseq")

## ----genChip_workflow, eval=FALSE---------------------------------------------
#  library(systemPipeRdata)
#  genWorkenvir(workflow="chipseq")
#  setwd("chipseq")

## ----genVar_workflow_single, eval=FALSE---------------------------------------
#  library(systemPipeRdata)
#  genWorkenvir(workflow="varseq")
#  setwd("varseq")

## ----genRibo_workflow_single, eval=FALSE--------------------------------------
#  library(systemPipeRdata)
#  genWorkenvir(workflow="riboseq")
#  setwd("riboseq")

## ----sessionInfo--------------------------------------------------------------
sessionInfo()

