# <span style="font-weight:bold; color:#F87217; text-decoration:underline">The output generated by visCompReorder is only shown in the screen. The reason for that is to make sure the supra-hexagon is seamlessly formed and visually friendly.</span>

# Internally, the function visVp opens a new page each time.

# In order to save the output as a file, below is a universal solution of how to save an image shown in the screen into a file (eg a png file).

## First, install and load the package 'evaluate'
# install.packages("evaluate",repos="http://cran.r-project.org",type="source")
library(evaluate)

## Then, produce an image in the screen
data <- matrix( rnorm(100*10,mean=0,sd=1), nrow=100, ncol=10)
colnames(data) <- paste('S', seq(1:10), sep="")
sMap <- sPipeline(data=data)
sReorder <- sCompReorder(sMap=sMap)
visCompReorder(sMap=sMap, sReorder=sReorder)

## Third, treat the last R expression as an input to the function evaluate::evaluate
r_exp <- 'visCompReorder(sMap=sMap, sReorder=sReorder)'

## Last, save it into the file called 'test.png' (with width=1200 and resolution=72)
x <- evaluate::evaluate(r_exp)
wh <- dev.size(units="px")
wth <- 1200
hgt <- wth*wh[2]/wh[1]
res <- min(c(wth,hgt))*72/480
png("test.png", width=wth, height=hgt, res=res)
on.exit(dev.off())
print(x)
graphics.off()
