## ----message = FALSE-----------------------------------------------------
library(sesame)

## ------------------------------------------------------------------------
fset <- openSesameToFile('mybetas',
    system.file('extdata',package='sesameData'))

## ------------------------------------------------------------------------
fset

## ------------------------------------------------------------------------
head(fset$samples) # sample IDs
head(fset$probes) # probe IDs

## ------------------------------------------------------------------------
sliceFileSet(fset, '4207113116_B', c('cg00006414','cg00007981'))

## ------------------------------------------------------------------------
fset <- readFileSet('mybetas')
sliceFileSet(fset, '4207113116_A', 'cg00000292')

## ------------------------------------------------------------------------
fset2 <- initFileSet('mybetas2', 'HM450', c('sample1', 'sample2'))

## ------------------------------------------------------------------------
hypothetical_betas <- setNames(runif(fset2$n), fset2$probes)
mapFileSet(fset2, 'sample2', hypothetical_betas)

## ------------------------------------------------------------------------
abs(sliceFileSet(fset2,'sample2','cg00000108') -
        hypothetical_betas['cg00000108']) < 1e-7

