## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
    collapse = TRUE,
    comment = "#>"
)

## ----setup, eval=FALSE--------------------------------------------------------
#  library(shiny)
#  library(Seurat)
#  library(ggrepel)
#  library(shinydashboard)
#  library(schex)
#  library(iSEE)

## ---- eval=FALSE--------------------------------------------------------------
#  pbmc_small <- make_hexbin(pbmc_small, nbins = 10, dimension_reduction = "PCA")
#  df_label <- make_hexbin_label(pbmc_small, "RNA_snn_res.0.8")

## ---- eval=FALSE--------------------------------------------------------------
#  app <- shinyApp(
#      server= function(input, output){
#  
#          output$all_genes <- renderUI({
#              selectInput(inputId = "gene", label = "Gene",
#                  choices = rownames(pbmc_small))
#          })
#  
#          output$plot1 <- renderPlot({
#              plot_hexbin_meta(pbmc_small, "RNA_snn_res.0.8", action="majority",
#                  title="Clusters") + guides(fill=FALSE) +
#                  ggrepel::geom_label_repel(data=df_label,
#                  aes(x=x, y=y, label=label), colour="black",
#                  label.size=NA, fill=NA)
#  
#          })
#  
#          output$plot2 <- renderPlot({
#              plot_hexbin_gene(pbmc_small, input$type, input$gene,
#                  action=input$action, title=input$gene)
#          })
#  
#  
#      },
#      ui= dashboardPage(skin = "purple",
#          dashboardHeader(),
#          dashboardSidebar(
#              uiOutput("all_genes"),
#              radioButtons("type", "Type of expression:",
#                  c("Raw" = "counts",
#                       "Normalized" = "data")),
#              radioButtons("action", "Summarize using:",
#                  c("Proportion not 0" = "prop_0",
#                        "Mean" = "mean",
#                        "Median" = "median"))
#  
#          ),
#          dashboardBody(
#              fluidRow(
#                    box(plotOutput("plot1", width = 450, height=400), width=6),
#                    box(plotOutput("plot2", width = 500, height=400), width=6))
#              )
#          )
#  )

## ----convert, eval=FALSE------------------------------------------------------
#  pbmc_small <- as.SingleCellExperiment(pbmc_small)
#  pbmc_small <- make_hexbin(pbmc_small, nbins=10, dimension_reduction = "PCA")

## ---- eval=FALSE--------------------------------------------------------------
#  plot_hexbin_gene_new <- function(sce, rows=NULL, rownames=character(0),
#      columns=NULL, type="logcounts", action="prop_0"){
#  
#        plot_hexbin_gene(sce, type=type, gene=rownames, action=action)
#  }

## ---- eval=FALSE--------------------------------------------------------------
#  schex_plot_gene <- customDataPlotDefaults(pbmc_small, 1)
#  schex_plot_gene$Function <- "plot_hexbin_gene_new"
#  schex_plot_gene$Arguments <- "type counts\naction prop_0\nrownames ODC1"
#  schex_plot_gene$ColumnSource <- "NULL"
#  schex_plot_gene$RowSource <- "NULL"
#  schex_plot_gene$DataBoxOpen <- TRUE
#  
#  
#  app <- iSEE(
#      pbmc_small,
#      customDataArgs=schex_plot_gene,
#      initialPanels=DataFrame(
#          Name=c("Custom data plot 1"),
#          Width=c(12)),
#      customDataFun=list(plot_hexbin_gene_new=plot_hexbin_gene_new)
#      )

