## ---- include=FALSE-----------------------------------------------------------
library(BiocStyle)

## ---- eval=FALSE--------------------------------------------------------------
#  if (!requireNamespace("BiocManager", quietly = TRUE))
#      install.packages("BiocManager")
#  BiocManager::install("scDblFinder")

## ---- eval=FALSE--------------------------------------------------------------
#  BiocManager::install("plger/scDblFinder")

## ---- eval=FALSE--------------------------------------------------------------
#  library(scDblFinder)
#  sce <- scDblFinder(sce)

## ---- eval=FALSE--------------------------------------------------------------
#  library(BiocParallel)
#  sce <- scDblFinder(sce, samples="sample_id", BPPARAM=MulticoreParam(3))
#  table(sce$scDblFinder.class)

## ----echo=FALSE, fig.cap="Comparison with other tools; note that doubletFinder failed on the mixology10x3cl dataset."----
knitr::include_graphics(system.file('docs', 'scDblFinder_comparison.png', package='scDblFinder'))

