/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.pride;

import com.compomics.util.io.SerializationUtils;
import com.compomics.util.pride.PrideObject;
import com.compomics.util.pride.PtmToPrideMap;
import com.compomics.util.pride.prideobjects.ContactGroup;
import com.compomics.util.pride.prideobjects.Instrument;
import com.compomics.util.pride.prideobjects.Protocol;
import com.compomics.util.pride.prideobjects.ReferenceGroup;
import com.compomics.util.pride.prideobjects.Sample;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import javax.swing.JOptionPane;

public class PrideObjectsFactory {
    private static PrideObjectsFactory instance = null;
    private static String prideFolder = System.getProperty("user.home") + "/.compomics/pride/";
    public static final String extension = ".cus";
    private static HashMap<String, ContactGroup> contactGroups = new HashMap();
    private static HashMap<String, Instrument> instruments = new HashMap();
    private static HashMap<String, Protocol> protocols = new HashMap();
    private static HashMap<String, ReferenceGroup> references = new HashMap();
    private static HashMap<String, Sample> samples = new HashMap();
    private static PtmToPrideMap ptmToPrideMap;

    public static PrideObjectsFactory getInstance() throws FileNotFoundException, IOException, ClassNotFoundException {
        if (instance == null) {
            instance = new PrideObjectsFactory();
        }
        return instance;
    }

    private PrideObjectsFactory() throws FileNotFoundException, IOException, ClassNotFoundException {
        this.loadObjects();
    }

    private void loadObjects() throws FileNotFoundException, IOException, ClassNotFoundException {
        File prideFolderFile = new File(prideFolder);
        if (!prideFolderFile.exists() || prideFolderFile.listFiles().length == 0) {
            this.createDefaultObjects();
        } else {
            File subFolder = new File(prideFolder, "contactGroups");
            if (!subFolder.exists()) {
                subFolder.mkdir();
            }
            for (File file : subFolder.listFiles()) {
                if (file.isDirectory() || !file.getName().endsWith(extension)) continue;
                try {
                    ContactGroup contactGroup = (ContactGroup)this.loadObject(file);
                    contactGroups.put(contactGroup.getFileName(), contactGroup);
                }
                catch (InvalidClassException e) {
                    file.delete();
                }
            }
            subFolder = new File(prideFolder, "protocols");
            if (!subFolder.exists()) {
                subFolder.mkdir();
            }
            for (File file : subFolder.listFiles()) {
                if (file.isDirectory() || !file.getName().endsWith(extension)) continue;
                try {
                    Protocol protocol = (Protocol)this.loadObject(file);
                    protocols.put(protocol.getFileName(), protocol);
                }
                catch (InvalidClassException e) {
                    file.delete();
                }
            }
            subFolder = new File(prideFolder, "instruments");
            if (!subFolder.exists()) {
                subFolder.mkdir();
            }
            for (File file : subFolder.listFiles()) {
                if (file.isDirectory() || !file.getName().endsWith(extension)) continue;
                try {
                    Instrument instrument = (Instrument)this.loadObject(file);
                    instruments.put(instrument.getFileName(), instrument);
                }
                catch (InvalidClassException e) {
                    file.delete();
                }
            }
            subFolder = new File(prideFolder, "referenceGroups");
            if (!subFolder.exists()) {
                subFolder.mkdir();
            }
            for (File file : subFolder.listFiles()) {
                if (file.isDirectory() || !file.getName().endsWith(extension)) continue;
                try {
                    ReferenceGroup referenceGroup = (ReferenceGroup)this.loadObject(file);
                    references.put(referenceGroup.getFileName(), referenceGroup);
                }
                catch (InvalidClassException e) {
                    file.delete();
                }
            }
            subFolder = new File(prideFolder, "samples");
            if (!subFolder.exists()) {
                subFolder.mkdir();
            }
            for (File file : subFolder.listFiles()) {
                if (file.isDirectory() || !file.getName().endsWith(extension)) continue;
                try {
                    Sample sample = (Sample)this.loadObject(file);
                    samples.put(sample.getFileName(), sample);
                }
                catch (InvalidClassException e) {
                    file.delete();
                }
            }
            File ptmMapFile = new File(prideFolder, "modMapUniMod.cus");
            try {
                if (!ptmMapFile.exists()) {
                    ptmToPrideMap = new PtmToPrideMap();
                    this.setPtmToPrideMap(ptmToPrideMap);
                }
                if ((ptmToPrideMap = (PtmToPrideMap)this.loadObject(ptmMapFile)) == null) {
                    System.out.println("Error: Corrupt PRIDE PTM mapping file. Resetting the mappings.");
                    ptmMapFile.delete();
                    ptmToPrideMap = new PtmToPrideMap();
                    this.setPtmToPrideMap(ptmToPrideMap);
                }
            }
            catch (InvalidClassException e) {
                e.printStackTrace();
                ptmMapFile.delete();
                ptmToPrideMap = new PtmToPrideMap();
                this.setPtmToPrideMap(ptmToPrideMap);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                ptmToPrideMap = new PtmToPrideMap();
                this.setPtmToPrideMap(ptmToPrideMap);
            }
            catch (IOException e) {
                e.printStackTrace();
                ptmMapFile.delete();
                ptmToPrideMap = new PtmToPrideMap();
                this.setPtmToPrideMap(ptmToPrideMap);
            }
        }
    }

    private void createDefaultObjects() throws FileNotFoundException, IOException, ClassNotFoundException {
        File prideFolderFile = new File(prideFolder);
        prideFolderFile.mkdirs();
        File subFolder = new File(prideFolder, "contacts");
        subFolder.mkdir();
        subFolder = new File(prideFolder, "contactGroups");
        subFolder.mkdir();
        subFolder = new File(prideFolder, "protocols");
        subFolder.mkdir();
        for (Protocol protocol : Protocol.getDefaultProtocols()) {
            this.addProtocol(protocol);
        }
        subFolder = new File(prideFolder, "instruments");
        subFolder.mkdir();
        for (Instrument defaultInstrument : Instrument.getDefaultInstruments()) {
            this.addInstrument(defaultInstrument);
        }
        subFolder = new File(prideFolder, "references");
        subFolder.mkdir();
        subFolder = new File(prideFolder, "referenceGroups");
        subFolder.mkdir();
        for (ReferenceGroup reference : ReferenceGroup.getDefaultReferences()) {
            this.addReferenceGroup(reference);
        }
        subFolder = new File(prideFolder, "samples");
        subFolder.mkdir();
        for (Sample sample : Sample.getDefaultSamples()) {
            this.addSample(sample);
        }
        ptmToPrideMap = new PtmToPrideMap();
    }

    public void addContactGroup(ContactGroup contactGroup) throws IOException {
        contactGroups.put(contactGroup.getFileName(), contactGroup);
        File subFolder = new File(prideFolder, "contactGroups");
        this.saveObject(subFolder, contactGroup);
    }

    public void deleteContactGroup(ContactGroup contactGroup) {
        File subFolder = new File(prideFolder, "contactGroups");
        this.deleteObject(subFolder, contactGroup.getFileName());
        contactGroups.remove(contactGroup.getFileName());
    }

    public void addProtocol(Protocol protocol) throws IOException {
        protocols.put(protocol.getFileName(), protocol);
        File subFolder = new File(prideFolder, "protocols");
        this.saveObject(subFolder, protocol);
    }

    public void deleteProtocol(Protocol protocol) {
        File subFolder = new File(prideFolder, "protocols");
        this.deleteObject(subFolder, protocol.getFileName());
        protocols.remove(protocol.getFileName());
    }

    public void addInstrument(Instrument instrument) throws IOException {
        instruments.put(instrument.getFileName(), instrument);
        File subFolder = new File(prideFolder, "instruments");
        this.saveObject(subFolder, instrument);
    }

    public void deleteInstrument(Instrument instrument) {
        File subFolder = new File(prideFolder, "instruments");
        this.deleteObject(subFolder, instrument.getFileName());
        instruments.remove(instrument.getFileName());
    }

    public void addReferenceGroup(ReferenceGroup referenceGroup) throws IOException {
        references.put(referenceGroup.getFileName(), referenceGroup);
        File subFolder = new File(prideFolder, "referenceGroups");
        this.saveObject(subFolder, referenceGroup);
    }

    public void deleteReferenceGroup(ReferenceGroup referenceGroup) {
        File subFolder = new File(prideFolder, "referenceGroups");
        this.deleteObject(subFolder, referenceGroup.getFileName());
        references.remove(referenceGroup.getFileName());
    }

    public void addSample(Sample sample) throws IOException {
        samples.put(sample.getFileName(), sample);
        File subFolder = new File(prideFolder, "samples");
        this.saveObject(subFolder, sample);
    }

    public void deleteSample(Sample sample) {
        File subFolder = new File(prideFolder, "samples");
        this.deleteObject(subFolder, sample.getFileName());
        samples.remove(sample.getFileName());
    }

    public void setPtmToPrideMap(PtmToPrideMap ptmToPrideMap) throws FileNotFoundException, IOException {
        if (ptmToPrideMap == null) {
            throw new IllegalArgumentException("Attempting to overwrite the PTM to PRIDE mapping with a null object.");
        }
        PrideObjectsFactory.ptmToPrideMap = ptmToPrideMap;
        File aFile = new File(prideFolder, "modMapUniMod.cus");
        SerializationUtils.writeObject(ptmToPrideMap, aFile);
    }

    private Object loadObject(File aFile) throws FileNotFoundException, IOException, ClassNotFoundException {
        FileInputStream fis = new FileInputStream(aFile);
        BufferedInputStream bis = new BufferedInputStream(fis);
        ObjectInputStream in = new ObjectInputStream(bis);
        Object object = in.readObject();
        fis.close();
        bis.close();
        in.close();
        return object;
    }

    private void saveObject(File destinationFolder, PrideObject object) throws IOException {
        File aFile = new File(destinationFolder, object.getFileName() + extension);
        FileOutputStream fos = new FileOutputStream(aFile);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(object);
        oos.close();
        bos.close();
        fos.close();
    }

    private void deleteObject(File folder, String aFileName) {
        boolean deleted;
        String fileName = aFileName + extension;
        if (new File(folder, fileName).exists() && !(deleted = new File(folder, fileName).delete())) {
            JOptionPane.showMessageDialog(null, "Failed to delete the file '" + new File(folder, fileName).getAbsolutePath() + "'.\n" + "Please delete the file manually.", "File Error", 0);
        }
    }

    public HashMap<String, ContactGroup> getContactGroups() {
        return contactGroups;
    }

    public HashMap<String, Instrument> getInstruments() {
        return instruments;
    }

    public HashMap<String, Protocol> getProtocols() {
        return protocols;
    }

    public PtmToPrideMap getPtmToPrideMap() {
        return ptmToPrideMap;
    }

    public HashMap<String, ReferenceGroup> getReferenceGroups() {
        return references;
    }

    public HashMap<String, Sample> getSamples() {
        return samples;
    }

    public static String getPrideFolder() {
        return prideFolder;
    }

    public static void setPrideFolder(String prideFolder) {
        PrideObjectsFactory.prideFolder = prideFolder;
    }
}

