/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.preferences;

import com.compomics.util.experiment.biology.PTMFactory;
import com.compomics.util.experiment.identification.protein_inference.proteintree.ProteinTreeComponentsFactory;
import com.compomics.util.preferences.GenePreferences;
import com.compomics.util.preferences.UtilitiesUserPreferences;
import com.compomics.util.pride.PrideObjectsFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class UtilitiesPathPreferences {
    public static final String separator = "=";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadPathPreferencesFromFile(File inputFile) throws FileNotFoundException, IOException {
        BufferedReader br = new BufferedReader(new FileReader(inputFile));
        try {
            String line;
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).equals("") || line.startsWith("#")) continue;
            }
        }
        finally {
            br.close();
        }
    }

    public static void loadPathPreferenceFromLine(String line) throws FileNotFoundException {
        String id = UtilitiesPathPreferences.getPathID(line);
        if (id.equals("")) {
            throw new IllegalArgumentException("Impossible to parse path in " + line + ".");
        }
        UtilitiesPathKey utilitiesPathKey = UtilitiesPathKey.getKeyFromId(id);
        if (utilitiesPathKey == null) {
            throw new IllegalArgumentException("Path " + id + " not recognized");
        }
        String path = UtilitiesPathPreferences.getPath(line);
        File file = new File(path);
        if (!file.exists()) {
            throw new FileNotFoundException("File " + path + " not found.");
        }
        if (utilitiesPathKey.isDirectory && !file.isDirectory()) {
            throw new FileNotFoundException("Found a file when expecting a directory for " + utilitiesPathKey.id + ".");
        }
        UtilitiesPathPreferences.setPathPreference(utilitiesPathKey, path);
    }

    public static void setPathPreference(UtilitiesPathKey utilitiesPathKey, String path) {
        switch (utilitiesPathKey) {
            case fastaIndexesKey: {
                ProteinTreeComponentsFactory.setDefaultDbFolderPath(path);
                return;
            }
            case geneMappingKey: {
                GenePreferences.setGeneMappingFolder(path);
                return;
            }
            case prideAnnotationKey: {
                PrideObjectsFactory.setPrideFolder(path);
                return;
            }
            case ptmFactoryKey: {
                PTMFactory.setSerializationFolder(path);
                return;
            }
            case utilitiesPreferencesKey: {
                UtilitiesUserPreferences.setUserPreferencesFolder(path);
                return;
            }
        }
        throw new UnsupportedOperationException("Path " + utilitiesPathKey.id + " not implemented.");
    }

    public static String getPathID(String line) {
        int separatorIndex = line.indexOf(separator);
        if (separatorIndex > 0) {
            return line.substring(0, separatorIndex);
        }
        return "";
    }

    public static String getPath(String line) {
        int separatorIndex = line.indexOf(separator);
        if (separatorIndex > 0 && separatorIndex < line.length()) {
            return line.substring(separatorIndex + 1);
        }
        return "";
    }

    public static void setAllPathsIn(String path) throws FileNotFoundException {
        for (UtilitiesPathKey utilitiesPathKey : UtilitiesPathKey.values()) {
            String subDirectory = utilitiesPathKey.defaultSubDirectory;
            File newFile = new File(path, subDirectory);
            if (!newFile.exists()) {
                newFile.mkdirs();
            }
            if (!newFile.exists()) {
                throw new FileNotFoundException(newFile.getAbsolutePath() + " could not be created.");
            }
            UtilitiesPathPreferences.setPathPreference(utilitiesPathKey, newFile.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeConfigurationToFile(File file) throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(file));
        try {
            UtilitiesPathPreferences.writeConfigurationToFile(bw);
        }
        finally {
            bw.close();
        }
    }

    public static void writeConfigurationToFile(BufferedWriter bw) throws IOException {
        for (UtilitiesPathKey pathKey : UtilitiesPathKey.values()) {
            UtilitiesPathPreferences.writePathToFile(bw, pathKey);
        }
    }

    public static void writePathToFile(BufferedWriter bw, UtilitiesPathKey pathKey) throws IOException {
        bw.write(pathKey.id + separator);
        switch (pathKey) {
            case fastaIndexesKey: {
                bw.write(ProteinTreeComponentsFactory.getDefaultDbFolderPath());
                break;
            }
            case geneMappingKey: {
                bw.write(GenePreferences.getGeneMappingFolder().getAbsolutePath());
                break;
            }
            case prideAnnotationKey: {
                bw.write(PrideObjectsFactory.getPrideFolder());
                break;
            }
            case ptmFactoryKey: {
                bw.write(PTMFactory.getSerializationFolder());
                break;
            }
            case utilitiesPreferencesKey: {
                bw.write(UtilitiesUserPreferences.getUserPreferencesFolder());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Path " + pathKey.id + " not implemented.");
            }
        }
        bw.newLine();
    }

    public static enum UtilitiesPathKey {
        utilitiesPreferencesKey("utilities_user_preferences", "Folder containing the compomics utilities user preferences file.", "", true),
        ptmFactoryKey("ptm_configuration", "Folder containing the PTM user preferences file.", "", true),
        fastaIndexesKey("fasta_indexes", "Folder containing the indexes of the protein sequences databases.", "fasta_indexes", true),
        geneMappingKey("gene_mapping", "Folder containing the gene mapping files.", "gene_mapping", true),
        prideAnnotationKey("pride_annotation", "Folder containing the PRIDE annotation preferences.", "pride", true);

        private String id;
        private String description;
        private String defaultSubDirectory;
        private boolean isDirectory;

        private UtilitiesPathKey(String id, String description, String defaultSubDirectory, boolean isDirectory) {
            this.id = id;
            this.description = description;
            this.defaultSubDirectory = defaultSubDirectory;
            this.isDirectory = isDirectory;
        }

        public String getId() {
            return this.id;
        }

        public String getDescription() {
            return this.description;
        }

        public static UtilitiesPathKey getKeyFromId(String id) {
            for (UtilitiesPathKey pathKey : UtilitiesPathKey.values()) {
                if (!pathKey.id.equals(id)) continue;
                return pathKey;
            }
            return null;
        }
    }
}

