/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.spectrum;

import com.compomics.util.experiment.biology.Ion;
import com.compomics.util.experiment.biology.IonFactory;
import com.compomics.util.experiment.biology.NeutralLoss;
import com.compomics.util.gui.spectrum.SpectrumPanel;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.table.DefaultTableModel;

public class IonLabelColorTableModel
extends DefaultTableModel {
    private HashMap<String, Ion> ionMap = new HashMap();
    private ArrayList<String> keys = new ArrayList();

    public IonLabelColorTableModel(HashMap<Ion.IonType, ArrayList<Integer>> iontypes, ArrayList<NeutralLoss> neutralLosses) {
        for (Ion.IonType ionType : iontypes.keySet()) {
            if (ionType == Ion.IonType.IMMONIUM_ION) {
                this.ionMap.put("Immonium Ion", Ion.getGenericIon(ionType, 0));
                this.keys.add("Immonium Ion");
                continue;
            }
            for (Integer subtype : iontypes.get((Object)ionType)) {
                Ion currentIon;
                if (ionType == Ion.IonType.REPORTER_ION) {
                    currentIon = Ion.getGenericIon(ionType, subtype);
                    String key = currentIon.getName();
                    this.ionMap.put(key, currentIon);
                    this.keys.add(key);
                    continue;
                }
                for (ArrayList<NeutralLoss> possibleCombination : IonFactory.getAccountedNeutralLosses(neutralLosses)) {
                    currentIon = Ion.getGenericIon(ionType, subtype, possibleCombination);
                    String key = currentIon.getName();
                    this.ionMap.put(key, currentIon);
                    this.keys.add(key);
                }
            }
        }
    }

    public Ion getIonAtRow(int rowIndex) {
        return this.ionMap.get(this.keys.get(rowIndex));
    }

    public IonLabelColorTableModel() {
    }

    @Override
    public int getRowCount() {
        if (this.keys == null) {
            return 0;
        }
        return this.keys.size();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return " ";
            }
            case 1: {
                return "Ion";
            }
            case 2: {
                return "  ";
            }
        }
        return "";
    }

    @Override
    public Object getValueAt(int row, int column) {
        switch (column) {
            case 0: {
                return row + 1;
            }
            case 1: {
                return this.keys.get(row);
            }
            case 2: {
                return SpectrumPanel.determineFragmentIonColor(this.ionMap.get(this.keys.get(row)), true);
            }
        }
        return "";
    }

    public Class getColumnClass(int columnIndex) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (this.getValueAt(i, columnIndex) == null) continue;
            return this.getValueAt(i, columnIndex).getClass();
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 2;
    }
}

