/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.general;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class CommandLineParser {
    Logger logger = Logger.getLogger(CommandLineParser.class);
    private String[] iCommandLine = null;
    private boolean iHasArgs = false;
    private String[] iFlags = null;
    private String[] iOptions = null;
    private String[] iParams = null;
    private HashMap iOptionParams = null;

    public CommandLineParser(String[] aCommandLine) {
        this(aCommandLine, null);
    }

    public CommandLineParser(String[] aCommandLine, String[] aOptionArgs) {
        if (aCommandLine != null) {
            this.iCommandLine = (String[])aCommandLine.clone();
        }
        this.iOptionParams = new HashMap();
        if (aOptionArgs != null && aOptionArgs.length > 0) {
            for (int i = 0; i < aOptionArgs.length; ++i) {
                this.iOptionParams.put(aOptionArgs[i], null);
            }
        }
        this.parseCommandLine();
    }

    public boolean hasArguments() {
        return this.iHasArgs;
    }

    public String[] getFlags() {
        return this.iFlags;
    }

    public String[] getOptions() {
        return this.iOptions;
    }

    public String[] getParameters() {
        return this.iParams;
    }

    public String getOptionParameter(String aOption) {
        return (String)this.iOptionParams.get(aOption);
    }

    public boolean hasFlag(String aFlag) {
        boolean present = false;
        if (this.iFlags != null) {
            for (int i = 0; i < this.iFlags.length; ++i) {
                String lFlag = this.iFlags[i];
                if (!lFlag.equals(aFlag)) continue;
                present = true;
                break;
            }
        }
        return present;
    }

    private void parseCommandLine() {
        if (this.iCommandLine == null || this.iCommandLine.length == 0) {
            this.iHasArgs = false;
        } else {
            this.iHasArgs = true;
            this.parseFlags();
            this.parseOptions();
            this.parseParameters();
        }
    }

    private void parseFlags() {
        ArrayList<String> tempFlags = new ArrayList<String>();
        for (int i = 0; i < this.iCommandLine.length; ++i) {
            if (!this.iCommandLine[i].startsWith("-") || this.iCommandLine[i].startsWith("--")) continue;
            String temp = this.iCommandLine[i];
            if ((temp = temp.substring(1)).length() > 1) {
                for (int j = 0; j < temp.length(); ++j) {
                    tempFlags.add(temp.substring(j, j + 1));
                }
                continue;
            }
            tempFlags.add(temp);
        }
        this.iFlags = new String[tempFlags.size()];
        tempFlags.toArray(this.iFlags);
    }

    private void parseOptions() {
        int i;
        ArrayList<String> tempOptions = new ArrayList<String>();
        ArrayList<String> afterArray = new ArrayList<String>();
        for (i = 0; i < this.iCommandLine.length; ++i) {
            String s = this.iCommandLine[i];
            afterArray.add(s);
        }
        for (i = 0; i < this.iCommandLine.length; ++i) {
            if (!this.iCommandLine[i].startsWith("--")) continue;
            String temp = this.iCommandLine[i].substring(2);
            if (this.iOptionParams.containsKey(temp)) {
                afterArray.remove(this.iCommandLine[i]);
                StringBuffer param = new StringBuffer();
                afterArray.remove(this.iCommandLine[i + 1]);
                if (this.iCommandLine[i + 1].startsWith("\"") && !this.iCommandLine[i + 1].endsWith("\"")) {
                    param.append(this.iCommandLine[i + 1].substring(1));
                    int counter = 1;
                    do {
                        param.append(" " + this.iCommandLine[i + ++counter]);
                        afterArray.remove(this.iCommandLine[i + counter]);
                    } while (!this.iCommandLine[i + counter].endsWith("\""));
                    param.deleteCharAt(param.length() - 1);
                } else if (this.iCommandLine[i + 1].startsWith("\"") && this.iCommandLine[i + 1].endsWith("\"")) {
                    param.append(this.iCommandLine[i + 1].substring(1, this.iCommandLine[i + 1].length() - 1));
                } else {
                    param.append(this.iCommandLine[i + 1]);
                }
                this.iOptionParams.put(temp, param.toString());
            }
            tempOptions.add(temp);
        }
        this.iOptions = new String[tempOptions.size()];
        tempOptions.toArray(this.iOptions);
        this.iCommandLine = new String[afterArray.size()];
        afterArray.toArray(this.iCommandLine);
    }

    private void parseParameters() {
        ArrayList<String> tempParams = new ArrayList<String>();
        for (int i = 0; i < this.iCommandLine.length; ++i) {
            if (this.iCommandLine[i].startsWith("-")) continue;
            String temp = this.iCommandLine[i];
            if (i > 0 && this.iCommandLine[i - 1].startsWith("--") && this.iOptionParams.containsKey(this.iCommandLine[i - 1].substring(2))) continue;
            tempParams.add(temp);
        }
        this.iParams = new String[tempParams.size()];
        tempParams.toArray(this.iParams);
    }
}

