/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology.ions;

import com.compomics.util.experiment.biology.Ion;
import com.compomics.util.experiment.biology.NeutralLoss;
import com.compomics.util.experiment.biology.ions.PeptideFragmentIon;
import com.compomics.util.pride.CvTerm;
import java.util.ArrayList;

public class TagFragmentIon
extends Ion {
    public static final int A_ION = 0;
    public static final int B_ION = 1;
    public static final int C_ION = 2;
    public static final int X_ION = 3;
    public static final int Y_ION = 4;
    public static final int Z_ION = 5;
    private ArrayList<NeutralLoss> neutralLosses = new ArrayList();
    private int number = -1;
    private int subNumber = -1;
    private int subType;
    private double massGap = 0.0;

    public TagFragmentIon(int fragmentType, int number, int subNumber, double mass, ArrayList<NeutralLoss> neutralLosses, double massGap) {
        if (neutralLosses == null) {
            neutralLosses = new ArrayList();
        }
        this.subType = fragmentType;
        this.type = Ion.IonType.TAG_FRAGMENT_ION;
        this.theoreticMass = mass;
        this.neutralLosses.addAll(neutralLosses);
        this.number = number;
        this.subNumber = subNumber;
        this.massGap = massGap;
    }

    public TagFragmentIon(int fragmentType, ArrayList<NeutralLoss> neutralLosses) {
        if (neutralLosses == null) {
            neutralLosses = new ArrayList();
        }
        this.subType = fragmentType;
        this.type = Ion.IonType.PEPTIDE_FRAGMENT_ION;
        this.neutralLosses.addAll(neutralLosses);
    }

    public TagFragmentIon(int fragmentType) {
        this.subType = fragmentType;
        this.type = Ion.IonType.PEPTIDE_FRAGMENT_ION;
    }

    public int getNumber() {
        return this.number;
    }

    public int getSubNumber() {
        return this.subNumber;
    }

    @Override
    public ArrayList<NeutralLoss> getNeutralLosses() {
        return this.neutralLosses;
    }

    @Override
    public String getName() {
        return this.getSubTypeAsString() + this.getNeutralLossesAsString();
    }

    public String getNameWithNumber() {
        return this.getSubTypeAsString() + this.getNumber() + this.getNeutralLossesAsString();
    }

    public String getNameWithGapAndNumber() {
        if (this.massGap == 0.0 || this.subNumber > 1) {
            return this.getNameWithNumber();
        }
        return this.massGap + "-" + this.getSubTypeAsString() + this.getNumber() + this.getNeutralLossesAsString();
    }

    @Override
    public CvTerm getPrideCvTerm() {
        switch (this.subType) {
            case 0: {
                if (this.neutralLosses.isEmpty()) {
                    return new CvTerm("PRIDE", "PRIDE:0000233", "a ion", null);
                }
                if (this.neutralLosses.size() == 1 && this.neutralLosses.get(0).isSameAs(NeutralLoss.H2O)) {
                    return new CvTerm("PRIDE", "PRIDE:0000234", "a ion -H2O", null);
                }
                if (this.neutralLosses.size() == 1 && this.neutralLosses.get(0).isSameAs(NeutralLoss.NH3)) {
                    return new CvTerm("PRIDE", "PRIDE:0000235", "a ion -NH3", null);
                }
                return null;
            }
            case 1: {
                if (this.neutralLosses.isEmpty()) {
                    return new CvTerm("PRIDE", "PRIDE:0000194", "b ion", null);
                }
                if (this.neutralLosses.size() == 1 && this.neutralLosses.get(0).isSameAs(NeutralLoss.H2O)) {
                    return new CvTerm("PRIDE", "PRIDE:0000196", "b ion -H2O", null);
                }
                if (this.neutralLosses.size() == 1 && this.neutralLosses.get(0).isSameAs(NeutralLoss.NH3)) {
                    return new CvTerm("PRIDE", "PRIDE:0000195", "b ion -NH3", null);
                }
                return null;
            }
            case 2: {
                if (this.neutralLosses.isEmpty()) {
                    return new CvTerm("PRIDE", "PRIDE:0000236", "c ion", null);
                }
                if (this.neutralLosses.size() == 1 && this.neutralLosses.get(0).isSameAs(NeutralLoss.H2O)) {
                    return new CvTerm("PRIDE", "PRIDE:0000237", "c ion -H2O", null);
                }
                if (this.neutralLosses.size() == 1 && this.neutralLosses.get(0).isSameAs(NeutralLoss.NH3)) {
                    return new CvTerm("PRIDE", "PRIDE:0000238", "c ion -NH3", null);
                }
                return null;
            }
            case 3: {
                if (this.neutralLosses.isEmpty()) {
                    return new CvTerm("PRIDE", "PRIDE:0000227", "x ion", null);
                }
                if (this.neutralLosses.size() == 1 && this.neutralLosses.get(0).isSameAs(NeutralLoss.H2O)) {
                    return new CvTerm("PRIDE", "PRIDE:0000228", "x ion -H2O", null);
                }
                if (this.neutralLosses.size() == 1 && this.neutralLosses.get(0).isSameAs(NeutralLoss.NH3)) {
                    return new CvTerm("PRIDE", "PRIDE:0000229", "x ion -NH3", null);
                }
                return null;
            }
            case 4: {
                if (this.neutralLosses.isEmpty()) {
                    return new CvTerm("PRIDE", "PRIDE:0000193", "y ion", null);
                }
                if (this.neutralLosses.size() == 1 && this.neutralLosses.get(0).isSameAs(NeutralLoss.H2O)) {
                    return new CvTerm("PRIDE", "PRIDE:0000197", "y ion -H2O", null);
                }
                if (this.neutralLosses.size() == 1 && this.neutralLosses.get(0).isSameAs(NeutralLoss.NH3)) {
                    return new CvTerm("PRIDE", "PRIDE:0000198", "y ion -NH3", null);
                }
                return null;
            }
            case 5: {
                if (this.neutralLosses.isEmpty()) {
                    return new CvTerm("PRIDE", "PRIDE:0000230", "z ion", null);
                }
                if (this.neutralLosses.size() == 1 && this.neutralLosses.get(0).isSameAs(NeutralLoss.H2O)) {
                    return new CvTerm("PRIDE", "PRIDE:0000231", "z ion -H2O", null);
                }
                if (this.neutralLosses.size() == 1 && this.neutralLosses.get(0).isSameAs(NeutralLoss.NH3)) {
                    return new CvTerm("PRIDE", "PRIDE:0000232", "z ion -NH3", null);
                }
                return null;
            }
        }
        return null;
    }

    @Override
    public int getSubType() {
        return this.subType;
    }

    @Override
    public String getSubTypeAsString() {
        try {
            return TagFragmentIon.getSubTypeAsString(this.subType);
        }
        catch (UnsupportedOperationException e) {
            throw new UnsupportedOperationException("No name for subtype: " + this.subType + " of " + this.getTypeAsString() + ".");
        }
    }

    public static String getSubTypeAsString(int subType) {
        switch (subType) {
            case 0: {
                return "a";
            }
            case 1: {
                return "b";
            }
            case 2: {
                return "c";
            }
            case 3: {
                return "x";
            }
            case 4: {
                return "y";
            }
            case 5: {
                return "z";
            }
        }
        throw new UnsupportedOperationException("No name for subtype: " + subType + ".");
    }

    public static ArrayList<Integer> getPossibleSubtypes() {
        ArrayList<Integer> possibleTypes = new ArrayList<Integer>();
        possibleTypes.add(0);
        possibleTypes.add(1);
        possibleTypes.add(2);
        possibleTypes.add(3);
        possibleTypes.add(4);
        possibleTypes.add(5);
        return possibleTypes;
    }

    @Override
    public boolean isSameAs(Ion anotherIon) {
        return anotherIon.getType() == Ion.IonType.TAG_FRAGMENT_ION && anotherIon.getSubType() == this.subType && ((PeptideFragmentIon)anotherIon).getNumber() == this.number && anotherIon.getNeutralLossesAsString().equals(this.getNeutralLossesAsString());
    }

    public double getMassGap() {
        return this.massGap;
    }
}

