/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.mascotdatfile.research.tool.spectrumviewer.spectrumviewer_gui;

import com.compomics.mascotdatfile.research.tool.spectrumviewer.spectrumviewer_gui.DataBridge;
import com.compomics.mascotdatfile.research.util.DatfileLocation;
import com.compomics.mascotdatfile.util.interfaces.MascotDatfileInf;
import com.compomics.util.gui.JLabelAndComponentPanel;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class Spectrumviewer_URL_JDialog
extends JDialog {
    private static Logger logger = Logger.getLogger(Spectrumviewer_URL_JDialog.class);
    private DataBridge iTarget = null;
    private String iPropsFile = null;
    private JTextField txtServer = null;
    private JTextField txtDate = null;
    private JTextField txtDatfile = null;
    private JButton btnShow = null;
    private JButton btnCancel = null;

    public Spectrumviewer_URL_JDialog(JFrame aParent, DataBridge aTarget, String aTitle, String aPropsFile) throws HeadlessException {
        super(aParent, aTitle, true);
        this.iTarget = aTarget;
        this.iPropsFile = aPropsFile;
        this.showSpectrumviewer_URL_JDialog();
    }

    private void showSpectrumviewer_URL_JDialog() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                Spectrumviewer_URL_JDialog.this.btnCancelTriggered();
            }
        });
        this.constructScreen();
        this.tryToLoadParams();
        this.setLocation(100, 100);
        this.pack();
        this.setResizable(false);
        this.setVisible(true);
    }

    private void constructScreen() {
        this.txtServer = new JTextField(25);
        this.txtServer.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    Spectrumviewer_URL_JDialog.this.txtDate.requestFocus();
                } else {
                    super.keyTyped(e);
                }
            }
        });
        this.txtDate = new JTextField(25);
        this.txtDate.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    Spectrumviewer_URL_JDialog.this.txtDatfile.requestFocus();
                } else {
                    super.keyTyped(e);
                }
            }
        });
        this.txtDatfile = new JTextField(25);
        this.txtDatfile.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    Spectrumviewer_URL_JDialog.this.txtDatfile.requestFocus();
                } else {
                    super.keyTyped(e);
                }
            }
        });
        JLabelAndComponentPanel jpanTop = new JLabelAndComponentPanel(new JLabel[]{new JLabel("Mascot Server"), new JLabel("Date"), new JLabel("Datfile")}, new JTextField[]{this.txtServer, this.txtDate, this.txtDatfile});
        jpanTop.setBorder(BorderFactory.createTitledBorder("Datfile source"));
        this.btnShow = new JButton("Show");
        this.btnShow.setMnemonic(83);
        this.btnShow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Spectrumviewer_URL_JDialog.this.btnShowTriggered();
            }
        });
        this.btnShow.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    Spectrumviewer_URL_JDialog.this.btnShowTriggered();
                }
            }
        });
        this.btnCancel = new JButton("Cancel");
        this.btnCancel.setMnemonic(67);
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Spectrumviewer_URL_JDialog.this.btnCancelTriggered();
            }
        });
        this.btnCancel.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    Spectrumviewer_URL_JDialog.this.btnCancelTriggered();
                }
            }
        });
        JPanel jpanButtons = new JPanel();
        jpanButtons.setLayout(new BoxLayout(jpanButtons, 0));
        jpanButtons.add(Box.createHorizontalGlue());
        jpanButtons.add(this.btnShow);
        jpanButtons.add(Box.createRigidArea(new Dimension(15, this.btnShow.getHeight())));
        jpanButtons.add(this.btnCancel);
        jpanButtons.add(Box.createRigidArea(new Dimension(10, this.btnShow.getHeight())));
        JPanel jpanTotal = new JPanel();
        jpanTotal.setLayout(new BoxLayout(jpanTotal, 1));
        jpanTotal.add(jpanTop);
        jpanTotal.add(Box.createRigidArea(new Dimension(jpanTop.getWidth(), 10)));
        jpanTotal.add(jpanButtons);
        this.getContentPane().add((Component)jpanTotal, "Center");
    }

    private void btnShowTriggered() {
        String lServer = this.txtServer.getText().trim();
        if (lServer.charAt(lServer.length() - 1) != '/') {
            lServer = lServer + '/';
        }
        String lDate = this.txtDate.getText().trim();
        String lDatfile = this.txtDatfile.getText().trim();
        if (lServer.equals("")) {
            JOptionPane.showMessageDialog(this, "Datfile source server needs to be specified!!", "No server specified!", 0);
            this.txtServer.requestFocus();
            return;
        }
        if (lDate.equals("")) {
            JOptionPane.showMessageDialog(this, "Creation date of datfile needs to be specified!", "No date specified!", 0);
            this.txtDate.requestFocus();
            return;
        }
        String errorString = null;
        MascotDatfileInf lMdf = null;
        try {
            this.setCursor(new Cursor(3));
            DatfileLocation dfl = new DatfileLocation(1, new String[]{lServer, lDate, lDatfile});
            lMdf = dfl.getDatfile();
        }
        catch (ClassNotFoundException cnfe) {
            errorString = "URL class was not found! (" + cnfe.getMessage() + ")";
        }
        catch (IllegalAccessException iae) {
            errorString = "(" + iae.getMessage() + ")";
        }
        catch (InstantiationException ie) {
            errorString = "Could not create instance of the MascotDatfile class! (" + ie.getMessage() + ")";
        }
        catch (SQLException sqle) {
            errorString = "(" + sqle.getMessage() + ")";
        }
        this.setCursor(new Cursor(0));
        if (errorString != null) {
            JOptionPane.showMessageDialog(this, new String[]{"Unable to load " + lDatfile + "from '" + lServer + ". " + errorString, "\n"}, "Unable to get the datfile!", 0);
        } else {
            this.iTarget.passMascotDatfile(lMdf, lDatfile);
            super.pack();
            this.setVisible(false);
            this.dispose();
        }
    }

    private void btnCancelTriggered() {
        this.setVisible(false);
        this.dispose();
    }

    private void tryToLoadParams() {
        if (this.iPropsFile != null) {
            try {
                String lDatfile;
                String lDate;
                Properties p = new Properties();
                InputStream is = ClassLoader.getSystemResourceAsStream(this.iPropsFile);
                if (is == null) {
                    is = this.getClass().getClassLoader().getResourceAsStream(this.iPropsFile);
                    if (is == null) {
                        return;
                    }
                    System.out.println("local classloader.");
                }
                p.load(is);
                String lServer = p.getProperty("URL_SERVER");
                if (lServer != null) {
                    this.txtServer.setText(lServer.trim());
                }
                if ((lDate = p.getProperty("URL_DATE")) != null) {
                    this.txtDate.setText(lDate.trim());
                }
                if ((lDatfile = p.getProperty("DATFILE")) != null) {
                    this.txtDatfile.setText(lDatfile.trim());
                }
                is.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

