/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.paxtools.controller.EditorMap;
import org.biopax.paxtools.controller.Fetcher;
import org.biopax.paxtools.controller.ObjectPropertyEditor;
import org.biopax.paxtools.controller.PropertyEditor;
import org.biopax.paxtools.controller.ReusedPEPHelper;
import org.biopax.paxtools.controller.SimpleEditorMap;
import org.biopax.paxtools.controller.StringPropertyEditor;
import org.biopax.paxtools.io.BioPAXIOHandler;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXFactory;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level2.deltaGprimeO;
import org.biopax.paxtools.model.level2.kPrime;
import org.biopax.paxtools.model.level2.physicalEntityParticipant;
import org.biopax.paxtools.model.level2.utilityClass;
import org.biopax.paxtools.util.BioPaxIOException;
import org.biopax.paxtools.util.IllegalBioPAXArgumentException;

public abstract class BioPAXIOHandlerAdapter
implements BioPAXIOHandler {
    private boolean treatNilAsNull;
    private boolean convertingFromLevel1ToLevel2 = false;
    private boolean fixReusedPEPs = false;
    private static final Log log = LogFactory.getLog(BioPAXIOHandlerAdapter.class);
    protected BioPAXLevel level;
    protected BioPAXFactory factory;
    protected EditorMap editorMap;
    protected Map<String, String> namespaces;
    protected static final String rdf = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    protected static final String rdfs = "http://www.w3.org/2000/01/rdf-schema#";
    protected String bp;
    protected static final String xsd = "http://www.w3.org/2001/XMLSchema#";
    protected static final String owl = "owl=http://www.w3.org/2002/07/owl#";
    protected String base;
    private ReusedPEPHelper reusedPEPHelper;

    public BioPAXIOHandlerAdapter() {
        this(null, null);
    }

    public BioPAXIOHandlerAdapter(BioPAXLevel level) {
        this(null, level);
    }

    public BioPAXIOHandlerAdapter(BioPAXFactory factory, BioPAXLevel level) {
        this.resetLevel(level, factory);
    }

    protected final void resetLevel(BioPAXLevel level, BioPAXFactory factory) {
        this.level = level != null ? level : BioPAXLevel.L3;
        BioPAXFactory bioPAXFactory = this.factory = factory != null ? factory : this.level.getDefaultFactory();
        if (this.level == BioPAXLevel.L1) {
            this.convertingFromLevel1ToLevel2 = true;
            this.fixReusedPEPs = true;
        } else if (this.level == BioPAXLevel.L2) {
            this.fixReusedPEPs = true;
        }
        this.bp = this.level.getNameSpace();
        this.resetEditorMap();
    }

    protected abstract void resetEditorMap();

    @Override
    public void fixReusedPEPs(boolean fixReusedPEPs) {
        this.fixReusedPEPs = fixReusedPEPs;
    }

    @Override
    public void treatNilAsNull(boolean treatNILasNull) {
        this.treatNilAsNull = treatNILasNull;
    }

    @Override
    public void setConvertingFromLevel1ToLevel2(boolean convertingFromLevel1ToLevel2) {
        this.convertingFromLevel1ToLevel2 = convertingFromLevel1ToLevel2;
    }

    @Override
    public boolean isTreatNilAsNull() {
        return this.treatNilAsNull;
    }

    @Override
    public boolean isConvertingFromLevel1ToLevel2() {
        return this.convertingFromLevel1ToLevel2;
    }

    @Override
    public boolean isFixReusedPEPs() {
        return this.fixReusedPEPs;
    }

    protected ReusedPEPHelper getReusedPEPHelper() {
        return this.reusedPEPHelper;
    }

    @Override
    public BioPAXFactory getFactory() {
        return this.factory;
    }

    @Override
    public void setFactory(BioPAXFactory factory) {
        this.factory = factory;
    }

    @Override
    public EditorMap getEditorMap() {
        return this.editorMap;
    }

    @Override
    public void setEditorMap(EditorMap editorMap) {
        this.editorMap = editorMap;
    }

    @Override
    public BioPAXLevel getLevel() {
        return this.level;
    }

    @Override
    @Deprecated
    public Model convertFromMultipleOwlFiles(String ... files) throws FileNotFoundException {
        Model model = this.factory.createModel();
        for (String file : files) {
            FileInputStream in = new FileInputStream(new File(file));
            if (log.isDebugEnabled()) {
                log.debug("start reading file:" + file);
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("read file: " + file);
        }
        return model;
    }

    @Override
    public Model convertFromOWL(InputStream in) {
        boolean fixingPEPS;
        this.init(in);
        this.namespaces = this.readNameSpaces();
        this.autodetectBiopaxLevel();
        Model model = this.factory.createModel();
        model.getNameSpacePrefixMap().putAll(this.namespaces);
        model.setXmlBase(this.base);
        boolean bl = fixingPEPS = model.getLevel() == BioPAXLevel.L2 && this.isFixReusedPEPs();
        if (fixingPEPS) {
            this.reusedPEPHelper = new ReusedPEPHelper(model);
        }
        this.createAndBind(model);
        if (fixingPEPS) {
            this.getReusedPEPHelper().copyPEPFields();
        }
        this.reset(in);
        return model;
    }

    protected void reset(InputStream in) {
        try {
            in.close();
        }
        catch (IOException e2) {
            throw new RuntimeException("Failed to close the file");
        }
    }

    private void autodetectBiopaxLevel() {
        BioPAXLevel filelevel = null;
        for (String namespaceValue : this.namespaces.values()) {
            filelevel = BioPAXLevel.getLevelFromNameSpace(namespaceValue);
            if (filelevel == null) continue;
            if (!log.isDebugEnabled()) break;
            log.debug("Auto-detected biopax " + (Object)((Object)filelevel) + " (current settings are for Level " + (Object)((Object)this.level) + ")");
            break;
        }
        if (filelevel == null) {
            log.error("Cannot detect biopax level.");
            throw new BioPaxIOException("Cannot detect biopax level.");
        }
        if (this.level != filelevel) {
            if (log.isDebugEnabled()) {
                log.debug("Reset to the default factory for the detected BioPAX level.");
            }
            this.resetLevel(filelevel, filelevel.getDefaultFactory());
        }
    }

    protected void createAndAdd(Model model, String id, String localName) {
        BioPAXElement bpe = this.getFactory().create(localName, id);
        if (log.isTraceEnabled()) {
            log.trace("id:" + id + " " + localName + " : " + bpe);
        }
        if (bpe != null) {
            model.add(bpe);
        } else {
            log.warn("null object created during reading. It might not be an official BioPAX class.ID: " + id + " Class " + "name " + localName);
        }
    }

    protected abstract void init(InputStream var1);

    protected abstract Map<String, String> readNameSpaces();

    protected abstract void createAndBind(Model var1);

    protected BioPAXElement L1ToL2Fixes(PropertyEditor editor, BioPAXElement bpe, Model model, String value) {
        utilityClass created = null;
        if (this.isConvertingFromLevel1ToLevel2()) {
            if (editor.getProperty().equals("DELTA-G")) {
                deltaGprimeO aDeltaGprime0 = model.addNew(deltaGprimeO.class, bpe.getRDFId() + "-DELTA-G");
                aDeltaGprime0.setDELTA_G_PRIME_O(Float.valueOf(value).floatValue());
                created = aDeltaGprime0;
            }
            if (editor.getProperty().equals("KEQ")) {
                kPrime aKPrime = model.addNew(kPrime.class, bpe.getRDFId() + "-KEQ");
                aKPrime.setK_PRIME(Float.valueOf(value).floatValue());
                created = aKPrime;
            }
        }
        return created;
    }

    protected Object resourceFixes(BioPAXElement bpe, Object value) {
        if (this.isFixReusedPEPs() && value instanceof physicalEntityParticipant) {
            value = this.getReusedPEPHelper().fixReusedPEP((physicalEntityParticipant)value, bpe);
        }
        return value;
    }

    protected void bindValue(String valueString, PropertyEditor editor, BioPAXElement bpe, Model model) {
        if (log.isDebugEnabled()) {
            log.debug("Binding: " + bpe + '(' + bpe.getModelInterface() + " has  " + editor + ' ' + valueString);
        }
        Object value = valueString;
        if (editor instanceof ObjectPropertyEditor) {
            value = model.getByID(valueString);
            if ((value = this.resourceFixes(bpe, value)) == null) {
                value = this.L1ToL2Fixes(editor, bpe, model, valueString);
                if (value == null) {
                    throw new IllegalBioPAXArgumentException("Illegal or Dangling Value/Reference: " + valueString + " (element: " + bpe.getRDFId() + " property: " + editor.getProperty() + ")");
                }
            } else if (this.isTreatNilAsNull() && valueString.trim().equalsIgnoreCase("NIL")) {
                value = null;
            }
        }
        if (editor == null) {
            log.error("Editor is null. This probably means an invalid BioPAX property. Failed to set " + valueString);
        } else {
            editor.setValueToBean(value, bpe);
        }
    }

    protected StringPropertyEditor getRDFCommentEditor(BioPAXElement bpe) {
        Class<? extends BioPAXElement> inter = bpe.getModelInterface();
        StringPropertyEditor editor = this.getLevel().equals((Object)BioPAXLevel.L3) ? (StringPropertyEditor)this.getEditorMap().getEditorForProperty("comment", inter) : (StringPropertyEditor)this.getEditorMap().getEditorForProperty("COMMENT", inter);
        return editor;
    }

    @Override
    public void convertToOWL(Model model, OutputStream outputStream, String ... ids) {
        if (ids.length == 0) {
            this.convertToOWL(model, outputStream);
        } else {
            Model m = model.getLevel().getDefaultFactory().createModel();
            m.setXmlBase(model.getXmlBase());
            Fetcher fetcher = new Fetcher(SimpleEditorMap.get(model.getLevel()), Fetcher.nextStepFilter);
            for (String uri : ids) {
                BioPAXElement bpe = model.getByID(uri);
                if (bpe == null) continue;
                fetcher.fetch(bpe, m);
            }
            this.convertToOWL(m, outputStream);
        }
    }
}

