/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.impl.level3;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.paxtools.impl.level3.ConversionImpl;
import org.biopax.paxtools.impl.level3.PathwayStepImpl;
import org.biopax.paxtools.model.level3.BiochemicalPathwayStep;
import org.biopax.paxtools.model.level3.Conversion;
import org.biopax.paxtools.model.level3.Process;
import org.biopax.paxtools.model.level3.StepDirection;
import org.biopax.paxtools.util.IllegalBioPAXArgumentException;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Proxy;
import org.hibernate.search.annotations.Indexed;

@Entity
@Proxy(proxyClass=BiochemicalPathwayStep.class)
@Indexed
@DynamicUpdate
@DynamicInsert
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class BiochemicalPathwayStepImpl
extends PathwayStepImpl
implements BiochemicalPathwayStep {
    private Conversion stepConversion;
    private StepDirection stepDirection;
    private Set<Process> stepProcess = new StepProcessSet();
    private Log log = LogFactory.getLog(BiochemicalPathwayStepImpl.class);

    @Transient
    public Class<? extends BiochemicalPathwayStep> getModelInterface() {
        return BiochemicalPathwayStep.class;
    }

    @ManyToOne(targetEntity=ConversionImpl.class)
    Conversion getStepConversionX() {
        return this.stepConversion;
    }

    void setStepConversionX(Conversion conversion2) {
        this.stepConversion = conversion2;
    }

    @Override
    @Transient
    public Conversion getStepConversion() {
        return this.stepConversion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStepConversion(Conversion highLander) {
        Conversion conversion2;
        if (this.stepConversion != null) {
            if (this.stepConversion == highLander) {
                return;
            }
            conversion2 = this.stepConversion;
            synchronized (conversion2) {
                this.stepConversion.getStepProcessOf().remove(this);
            }
        }
        this.stepConversion = highLander;
        if (this.stepConversion != null) {
            conversion2 = this.stepConversion;
            synchronized (conversion2) {
                this.stepConversion.getStepProcessOf().add(this);
            }
        }
    }

    @Override
    public void addStepProcess(Process process2) {
        if (process2 instanceof Conversion) {
            if (this.stepConversion == null || this.stepConversion == process2) {
                this.log.debug("Ignoring request to add a Conversion as stepProcess");
            } else {
                throw new IllegalBioPAXArgumentException("Biochemical Pathway Step can have only one conversion. Did you want to usethe setStepConversion method? ");
            }
        }
        super.addStepProcess(process2);
    }

    @Override
    @Enumerated(value=EnumType.STRING)
    public StepDirection getStepDirection() {
        return this.stepDirection;
    }

    @Override
    public void setStepDirection(StepDirection newSTEP_DIRECTION) {
        this.stepDirection = newSTEP_DIRECTION;
    }

    @Override
    @Transient
    public Set<Process> getStepProcess() {
        return this.stepProcess;
    }

    private class StepProcessSet
    extends AbstractSet<Process> {
        private StepProcessSet() {
        }

        @Override
        public Iterator<Process> iterator() {
            final Iterator proci = BiochemicalPathwayStepImpl.super.getStepProcess().iterator();
            return new Iterator<Process>(){
                boolean procEnd = false;

                @Override
                public boolean hasNext() {
                    return proci.hasNext() || !this.procEnd && BiochemicalPathwayStepImpl.this.stepConversion != null;
                }

                @Override
                public Process next() {
                    if (this.procEnd) {
                        throw new NoSuchElementException();
                    }
                    if (proci.hasNext()) {
                        return (Process)proci.next();
                    }
                    this.procEnd = true;
                    if (BiochemicalPathwayStepImpl.this.stepConversion == null) {
                        throw new NoSuchElementException();
                    }
                    return BiochemicalPathwayStepImpl.this.stepConversion;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int size() {
            return BiochemicalPathwayStepImpl.super.getStepProcess().size() + (BiochemicalPathwayStepImpl.this.stepConversion == null ? 0 : 1);
        }

        @Override
        public boolean contains(Object o) {
            return o != null && (BiochemicalPathwayStepImpl.this.stepConversion != null && BiochemicalPathwayStepImpl.this.stepConversion.equals(o) || BiochemicalPathwayStepImpl.super.getStepProcess().contains(o));
        }
    }
}

