/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra.op;

import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVisitor;
import com.hp.hpl.jena.sparql.algebra.Transform;
import com.hp.hpl.jena.sparql.algebra.op.OpModifier;
import com.hp.hpl.jena.sparql.core.VarExprList;
import com.hp.hpl.jena.sparql.util.NodeIsomorphismMap;
import com.hp.hpl.jena.sparql.util.Utils;
import java.util.List;

public class OpGroupAgg
extends OpModifier {
    private VarExprList groupVars;
    private List aggregators;

    public OpGroupAgg(Op subOp, VarExprList groupVars, List aggregators) {
        super(subOp);
        this.groupVars = groupVars;
        this.aggregators = aggregators;
    }

    public String getName() {
        return "group";
    }

    public VarExprList getGroupVars() {
        return this.groupVars;
    }

    public List getAggregators() {
        return this.aggregators;
    }

    public void visit(OpVisitor opVisitor) {
        opVisitor.visit(this);
    }

    public Op copy(Op subOp) {
        return new OpGroupAgg(subOp, this.groupVars, this.aggregators);
    }

    public Op apply(Transform transform, Op subOp) {
        return transform.transform(this, subOp);
    }

    public int hashCode() {
        int x = this.getSubOp().hashCode();
        if (this.groupVars != null) {
            x ^= this.groupVars.hashCode();
        }
        if (this.aggregators != null) {
            x ^= ((Object)this.aggregators).hashCode();
        }
        return x;
    }

    public boolean equalTo(Op other, NodeIsomorphismMap labelMap) {
        if (!(other instanceof OpGroupAgg)) {
            return false;
        }
        OpGroupAgg opGroup = (OpGroupAgg)other;
        if (!Utils.equals(this.groupVars, opGroup.groupVars)) {
            return false;
        }
        if (!Utils.equals(this.aggregators, opGroup.aggregators)) {
            return false;
        }
        return this.getSubOp().equalTo(opGroup.getSubOp(), labelMap);
    }
}

