## ----include=FALSE, messages=FALSE, warnings=FALSE-------------------------
knitr::opts_chunk$set(message=FALSE, fig.width=6.75)
devtools::load_all(".")
library(dplyr)
library(magrittr)

## ----get_package, eval=FALSE-----------------------------------------------
#  if (!requireNamespace("BiocManager", quietly = TRUE))
#  install.packages("BiocManager")
#  BiocManager::install("hypeR")

## ---- eval=FALSE-----------------------------------------------------------
#  devtools::install_github("montilab/hypeR")

## ---- eval=FALSE-----------------------------------------------------------
#  BiocManager::install("montilab/hypeR", version='devel')

## ---- eval=FALSE-----------------------------------------------------------
#  library(hypeR)

## --------------------------------------------------------------------------

# Simply a character vector of symbols (hypergeometric)
signature <- c("GENE1", "GENE2", "GENE3")

# A pre-ranked character vector of symbols (kstest)
ranked.signature <-  c("GENE1", "GENE2", "GENE3")

# A pre-ranked named numerical vector of symbols with ranking weights (gsea)
weighted.signature <-  c("GENE1"=1.22, "GENE2"=0.94, "GENE3"=0.77)


## --------------------------------------------------------------------------

genesets <- list("GSET1" = c("GENE1", "GENE2", "GENE3"),
                 "GSET2" = c("GENE4", "GENE5", "GENE6"),
                 "GSET3" = c("GENE7", "GENE8", "GENE9"))


## --------------------------------------------------------------------------

hypdat <- readRDS(file.path(system.file("extdata", package="hypeR"), "hypdat.rds"))


## --------------------------------------------------------------------------

limma <- hypdat$limma
signature <- limma %>% filter(t > 0 & fdr < 0.001) %>% use_series(symbol)
ranked.signature <- limma %>% arrange(desc(t)) %>% use_series(symbol)

gsets <- hyperdb_fetch(type="gsets", "KEGG_2019_Human")


## --------------------------------------------------------------------------

hyp_obj <- hypeR(signature, gsets, test="hypergeometric", bg=50000, fdr_cutoff=0.01, do_plots=TRUE)


## --------------------------------------------------------------------------

print(hyp_obj)
hyp_df <- hyp_obj$as.data.frame()
print(head(hyp_df[,1:3]), row.names=FALSE)
hyp_obj$plots[[1]]


## --------------------------------------------------------------------------

hyp_obj <- hypeR(ranked.signature, gsets, test="kstest", fdr_cutoff=0.01, do_plots=TRUE)


## --------------------------------------------------------------------------

print(hyp_obj)
hyp_df <- hyp_obj$as.data.frame()
print(head(hyp_df[,1:3]), row.names=FALSE)
hyp_obj$plots[[1]]


## ---- eval=FALSE-----------------------------------------------------------
#  
#  hyp_to_excel(hyp_obj, file_path="hyper.xlsx")
#  

## ---- eval=FALSE-----------------------------------------------------------
#  
#  hyp_to_table(hyp_obj, file_path="hyper.txt")
#  

## --------------------------------------------------------------------------

msigdb_info()


## --------------------------------------------------------------------------

HALLMARK <- msigdb_download_one(species="Homo sapiens", category="H")


## --------------------------------------------------------------------------

head(names(HALLMARK))
head(HALLMARK[[1]])


## --------------------------------------------------------------------------

msigdb_path <- msigdb_download_all(species="Homo sapiens")

BIOCARTA <- msigdb_fetch(msigdb_path, "C2.CP.BIOCARTA")
KEGG     <- msigdb_fetch(msigdb_path, "C2.CP.KEGG")
REACTOME <- msigdb_fetch(msigdb_path, "C2.CP.REACTOME")


## --------------------------------------------------------------------------

gsets <- c(BIOCARTA, KEGG, REACTOME)


## ---- eval=FALSE-----------------------------------------------------------
#  
#  url = "http://amp.pharm.mssm.edu/Enrichr/geneSetLibrary?mode=text&libraryName=Cancer_Cell_Line_Encyclopedia"
#  r <- httr::GET(url)
#  text <- httr::content(r, "text", encoding="ISO-8859-1")
#  text.split <- strsplit(text, "\n")[[1]]
#  gsets <- sapply(text.split, function(x) {
#      genes <- strsplit(x, "\t")[[1]]
#      return(genes[3:length(genes)])
#  })
#  names(gsets) <- unlist(lapply(text.split, function(x) strsplit(x, "\t")[[1]][1]))
#  

## ---- eval=FALSE-----------------------------------------------------------
#  
#  gsets <- hyperdb_fetch(type="gsets", "Cancer_Cell_Line_Encyclopedia")
#  

## --------------------------------------------------------------------------

hyperdb_info(type="gsets", quiet=TRUE)[1:15]


## --------------------------------------------------------------------------

hyperdb_info(type="rgsets", quiet=TRUE)


## --------------------------------------------------------------------------

limma <- hypdat$limma
ranked.signature <- limma %>% arrange(desc(t)) %>% use_series(symbol)

rgsets <- hyperdb_fetch(type="rgsets", "REACTOME")
gsets <- rgsets$gsets


## --------------------------------------------------------------------------

hyp_obj <- hypeR(ranked.signature, gsets, test="kstest", fdr_cutoff=0.01)


## ---- fig.height=5---------------------------------------------------------

hyp_dots(hyp_obj, show_plots=FALSE, return_plots=TRUE)


## ---- fig.height=7---------------------------------------------------------

hyp_emap(hyp_obj, similarity_cutoff=0.8, show_plots=FALSE, return_plots=TRUE)


## --------------------------------------------------------------------------

rgsets <- hyperdb_fetch(type="rgsets", "REACTOME")


## --------------------------------------------------------------------------

gsets <- rgsets$gsets
names(gsets)[800:805]


## --------------------------------------------------------------------------

nodes <- rgsets$nodes
nodes[1123:1128,]


## --------------------------------------------------------------------------

edges <- rgsets$edges
edges[1994:1999,]


## --------------------------------------------------------------------------

hyp_obj <- hypeR(ranked.signature, rgsets, test="kstest", fdr_cutoff=0.01)


## ---- fig.height=7---------------------------------------------------------

hyp_hmap(hyp_obj, top=30, show_plots=FALSE, return_plots=TRUE)


