## ----message=FALSE-------------------------------------------------------
library(fgsea)
library(ggplot2)
library(BiocParallel)
register(SerialParam())

## ------------------------------------------------------------------------
data(examplePathways)
data(exampleRanks)

## ------------------------------------------------------------------------
fgseaMultilevelRes <- fgseaMultilevel(pathways = examplePathways, 
                                      stats = exampleRanks,
                                      minSize=15,
                                      maxSize=500)

## ------------------------------------------------------------------------
head(fgseaMultilevelRes[order(pval), ])

## ------------------------------------------------------------------------
set.seed(42)

fgseaRes <- fgsea(pathways=examplePathways, stats=exampleRanks,
                  minSize=15, maxSize=500, nperm=10000)

fgseaMultilevelRes <- fgseaMultilevel(pathways=examplePathways, 
                                      stats=exampleRanks,
                                      minSize=15, maxSize=500, 
                                      sampleSize=100)

logPvalsDf <- data.frame(fgseaData=-log10(fgseaRes$pval),
                         fgseaMultilevelData=-log10(fgseaMultilevelRes$pval))

## ----fig.width=7, fig.height=5-------------------------------------------
ggplot(logPvalsDf, aes(x=fgseaData, y=fgseaMultilevelData)) +
  geom_point(color='royalblue4', size=3) +
  xlab("Fgsea: -log10(P-value)") +
  ylab("FgseaMultilevel: -log10(P-value)") +
  geom_abline(size=1, color='orangered2') +
  labs(title="Fgsea Vs FgseaMultilevel")

