## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(echo=TRUE)

## ---- eval=FALSE, include=TRUE, message=FALSE, warning=FALSE------------------
#  library(bigPint)
#  library(dplyr)
#  data("soybean_ir_sub")
#  data("soybean_ir_sub_metrics")
#  tenSigGenes <- soybean_ir_sub_metrics[["N_P"]] %>% select(ID) %>%
#    filter(row_number() <= 10)
#  tenSigGenes <- tenSigGenes[,1]
#  soybean_ir_sub[,-1] <- log(soybean_ir_sub[,-1] + 1)
#  plotLitre(data=soybean_ir_sub, geneList = tenSigGenes)

## ---- eval=TRUE, include=FALSE, message=FALSE, warning=FALSE------------------
library(bigPint)
library(dplyr)
data("soybean_ir_sub")
data("soybean_ir_sub_metrics")
tenSigGenes <- soybean_ir_sub_metrics[["N_P"]] %>% select(ID) %>%
  filter(row_number() <= 10)
tenSigGenes <- tenSigGenes[,1]
soybean_ir_sub[,-1] <- log(soybean_ir_sub[,-1] + 1)
plotLitre(data=soybean_ir_sub, geneList = tenSigGenes, saveFile = FALSE)

## ---- eval=FALSE, include=TRUE, message=FALSE, warning=FALSE------------------
#  plotLitre(data=soybean_ir_sub, geneList = tenSigGenes, outDir = "LitrePlots")

## ---- eval=FALSE, include=TRUE, message=FALSE, warning=FALSE------------------
#  plotLitre(data=soybean_ir_sub, geneList = tenSigGenes, saveFile = FALSE)

## ---- eval=TRUE, include=TRUE, message=FALSE, warning=FALSE, fig.width = 7.2916667, fig.asp= 1/1.618----
ret <- plotLitre(data=soybean_ir_sub, geneList = tenSigGenes, saveFile = FALSE)
names(ret)

## ---- eval=TRUE, include=TRUE, message=FALSE, warning=FALSE, fig.width = 7.2916667, fig.asp= 1/1.618----
ret[["N_P_Glyma.19G168700.Wm82.a2.v1"]]

## ---- eval=TRUE, include=TRUE, message=FALSE, warning=FALSE, fig.width = 7.2916667, fig.asp= 1/1.618----
library(ggplot2)
ret[[1]] + labs(title = "Most significant gene")

## ---- eval=TRUE, include=TRUE, message=FALSE, warning=FALSE-------------------
library(matrixStats)
data(soybean_cn_sub)
data(soybean_cn_sub_metrics)

soybean_cn_sub_st <- as.data.frame(t(apply(as.matrix(soybean_cn_sub[,-1]), 1, scale)))
soybean_cn_sub_st$ID <- as.character(soybean_cn_sub$ID)
colLength = length(soybean_cn_sub_st)
soybean_cn_sub_st <- soybean_cn_sub_st[,c(colLength, 1:(colLength-1))]
colnames(soybean_cn_sub_st) <- colnames(soybean_cn_sub)
nID <- which(is.nan(soybean_cn_sub_st[,2]))
soybean_cn_sub_st[nID,2:length(soybean_cn_sub_st)] <- 0

## ---- eval=FALSE, include=TRUE, message=FALSE, warning=FALSE------------------
#  plotSM(soybean_cn_sub, dataMetrics = soybean_cn_sub_metrics)

## ---- eval=TRUE, include=TRUE, message=FALSE, warning=FALSE-------------------
ret <- plotSM(soybean_cn_sub, soybean_cn_sub_metrics, pointColor = "pink",
  saveFile = FALSE)
names(ret)
ret[["S1_S2"]] + ggtitle("S1 versus S2")
ret[["S1_S3"]] + ggtitle("S1 versus S3")
ret[["S2_S3"]] + ggtitle("S2 versus S3")

## ---- eval=TRUE, include=TRUE, message=FALSE, warning=FALSE-------------------
ret <- plotSM(soybean_cn_sub_st, soybean_cn_sub_metrics, pointColor = "#00C379",
  saveFile = FALSE)
ret[[1]] + xlab("Standardized read counts") + ylab("Standardized read counts")

## ---- eval=TRUE, include=TRUE, message=FALSE, warning=FALSE-------------------
ret <- plotSM(soybean_cn_sub, soybean_cn_sub_metrics, option = "hexagon", xbins = 5, 
  pointSize = 0.1, saveFile = FALSE)
ret[[2]]

## ---- eval=TRUE, include=TRUE, message=FALSE, warning=FALSE-------------------
ret <- plotSM(soybean_ir_sub, option = "orthogonal", threshOrth = 2.5,
  pointSize = 0.2, saveFile = FALSE)
ret[[1]]

## ---- eval=TRUE, include=TRUE, message=FALSE, warning=FALSE-------------------
ret <- plotSM(soybean_ir_sub, soybean_ir_sub_metrics, option = "orthogonal", 
  threshOrth = 2.5, pointSize = 0.2, saveFile = FALSE)
ret[[1]]

## ---- eval=TRUE, include=TRUE, message=FALSE, warning=FALSE-------------------
ret <- plotSM(soybean_cn_sub, option = "foldChange", threshFC = 0.5, pointSize = 0.2, 
  saveFile = FALSE)
ret[[1]]

## ---- eval=TRUE, include=TRUE, message=FALSE, warning=FALSE-------------------
ret <- plotSM(soybean_cn_sub, soybean_cn_sub_metrics, option = "foldChange",
  threshFC = 0.5, pointSize = 0.2, saveFile = FALSE)
ret[[1]]

## ---- eval=TRUE, include=TRUE, message=FALSE, warning=FALSE, fig.width = 7.2916667, fig.asp= 1/1.618----
geneList = soybean_cn_sub_metrics[["S1_S2"]][1:5,]$ID
ret <- plotLitre(data = soybean_cn_sub_st[,c(1:7)], geneList = geneList,
  pointColor = "gold", saveFile = FALSE)
names(ret)
ret[["S1_S2_Glyma18g00690.1"]]

## ---- eval=TRUE, include=TRUE, message=FALSE, warning=FALSE, fig.width = 7.2916667, fig.asp= 1/1.618----
geneList = soybean_cn_sub_metrics[["S1_S2"]][1:5,]$ID
ret <- plotLitre(data = soybean_cn_sub_st[,c(1:7)], geneList = geneList,
  pointColor = "gold", saveFile = FALSE, option = "allPoints")
ret[["S1_S2_Glyma18g00690.1"]]

## ---- eval=TRUE, include=TRUE, message=FALSE, warning=FALSE, fig.width = 7.2916667, fig.asp= 1/1.618----
soybean_ir_sub_log = soybean_ir_sub
soybean_ir_sub_log[,-1] = log(soybean_ir_sub[,-1] + 1)
geneList = soybean_ir_sub_metrics[["N_P"]][1:10,]$ID
ret <- plotPCP(data = soybean_ir_sub_log, geneList = geneList, lineSize = 0.7, 
  lineColor = "purple", saveFile = FALSE)
ret[[1]]

## ---- eval=TRUE, include=TRUE, message=FALSE, warning=FALSE, fig.width = 7.2916667, fig.asp= 1/1.618----
ret <- plotPCP(data = soybean_ir_sub_log, geneList = geneList, lineSize = 0.4, 
  lineColor = "purple", saveFile = FALSE, hover = TRUE)
ret[[1]]

## ---- eval=TRUE, include=TRUE, message=FALSE, warning=FALSE, fig.width = 7.2916667, fig.asp= 1/1.618----
ret <- plotPCP(data = soybean_ir_sub_log, saveFile = FALSE)
ret[[1]]

## ---- eval=TRUE, include=TRUE, message=FALSE, warning=FALSE, fig.width = 7.2916667, fig.asp= 1/1.618----
library(EDASeq)
library(edgeR)
dataID <- soybean_ir_sub$ID
data2 = as.matrix(soybean_ir_sub[,-1])
d = DGEList(counts=data2, lib.size=rep(1,6))
cpm.data.new <- cpm(d, TRUE, TRUE)
soybean_ir_sub_n <- betweenLaneNormalization(cpm.data.new, which="full", round=FALSE)
soybean_ir_sub_n = as.data.frame(soybean_ir_sub_n)
soybean_ir_sub_n$ID <- dataID
soybean_ir_sub_n = soybean_ir_sub_n[,c(7,1:6)]
soybean_ir_sub_ns = as.data.frame(t(apply(as.matrix(soybean_ir_sub_n[,-1]), 1, scale)))
soybean_ir_sub_ns$ID = as.character(soybean_ir_sub_n$ID)
soybean_ir_sub_ns = soybean_ir_sub_ns[,c(7,1:6)]
colnames(soybean_ir_sub_ns) = colnames(soybean_ir_sub_n)
nID = which(is.nan(soybean_ir_sub_ns[,2]))
soybean_ir_sub_ns[nID,2:length(soybean_ir_sub_ns)] = 0

ret <- plotPCP(data = soybean_ir_sub_ns, dataMetrics = soybean_ir_sub_metrics, 
  threshVal = 1e-4, saveFile = FALSE)
ret[["N_P"]]

## ---- eval=TRUE, include=TRUE, message=FALSE, warning=FALSE, fig.width = 7.2916667, fig.asp= 1/1.618----
ret <- plotVolcano(soybean_ir_sub, soybean_ir_sub_metrics, threshVal = 1e-8,
  pointSize = 3, saveFile = FALSE)
ret[["N_P"]]

## ---- eval=TRUE, include=TRUE, message=FALSE, warning=FALSE, fig.width = 7.2916667, fig.asp= 1/1.618----
ret <- plotVolcano(soybean_ir_sub, soybean_ir_sub_metrics, geneList = geneList,
  option = "allPoints", pointColor = "deeppink", pointSize = 3, saveFile = FALSE)
ret[["N_P"]]

## ---- eval=TRUE, include=TRUE, message=FALSE, warning=FALSE, fig.width = 7.2916667, fig.asp= 1/1.618----
ret <- plotVolcano(soybean_ir_sub, soybean_ir_sub_metrics, geneList = geneList,
  option = "allPoints", pointColor = "deeppink", pointSize = 2, saveFile = FALSE,
  hover = TRUE)
ret[["N_P"]]

