## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(echo=TRUE)
knitr::opts_chunk$set(collapse = TRUE, comment = "#>")
rmarkdown::find_external_resources

## ---- eval=TRUE, echo = TRUE, include=TRUE, message=FALSE, warning=FALSE, fig.width = 7.2916667, fig.asp= 1/1.618----
library(bigPint)
library(dplyr)
library(ggplot2)
library(plotly)
data("soybean_cn_sub")
data = soybean_cn_sub %>% select(ID, starts_with("S1"), starts_with("S3"))

## ---- eval=TRUE, echo = TRUE, include=TRUE, message=FALSE, warning=FALSE, fig.width = 7.2916667, fig.asp= 1/1.618----
str(data, strict.width = "wrap")

## ---- eval=TRUE, echo = TRUE, include=TRUE, message=FALSE, warning=FALSE, fig.width = 7.2916667, fig.asp= 1/1.618----
data_st <- as.data.frame(t(apply(as.matrix(data[,-1]), 1, scale)))
data_st$ID <- as.character(data$ID)
data_st <- data_st[,c(length(data_st), 1:length(data_st)-1)]
colnames(data_st) <- colnames(data)
nID <- which(is.nan(data_st[,2]))
data_st[nID,2:length(data_st)] <- 0

## ---- eval=TRUE, echo = TRUE, include=TRUE, message=FALSE, warning=FALSE, fig.width = 7.2916667, fig.asp= 1/1.618----
str(data_st, strict.width = "wrap")

## ---- eval=TRUE, echo = TRUE, include=TRUE, message=FALSE, warning=FALSE, fig.width = 7.2916667, fig.asp= 1/1.618----
ret <- plotPCP(data=data, saveFile = FALSE)
ret[["S1_S3"]]

## ---- eval=TRUE, echo = TRUE, include=TRUE, message=FALSE, warning=FALSE------
ret <- plotSM(data=data, saveFile = FALSE)
ret[["S1_S3"]]

## ---- eval=TRUE, echo = TRUE, include=TRUE, message=FALSE, warning=FALSE------
dataSwitch <- data[,c(1:3, 5, 4, 6:7)]
colnames(dataSwitch) <- colnames(data)
ret <- plotSM(data=dataSwitch, saveFile = FALSE)
ret[["S1_S3"]]

## ---- eval=TRUE, include=TRUE, message=FALSE, warning=FALSE-------------------
library(edgeR)
library(data.table)

rownames(data) = data[,1]

y = DGEList(counts=data[,-1])
group = c(1,1,1,2,2,2)
y = DGEList(counts=y, group=group)
Group = factor(c(rep("S1",3), rep("S3",3)))
design <- model.matrix(~0+Group, data=y$samples)
colnames(design) <- levels(Group)
y <- estimateDisp(y, design)
fit <- glmFit(y, design)

dataMetrics <- list()

contrast=rep(0,ncol(fit))
contrast[1]=1
contrast[2]=-1
lrt <- glmLRT(fit, contrast=contrast)
lrt <- topTags(lrt, n = nrow(y[[1]]))[[1]]

lrt <- setDT(lrt, keep.rownames = TRUE)[]
colnames(lrt)[1] = "ID"
lrt <- as.data.frame(lrt)

dataMetrics[[paste0(colnames(fit)[1], "_", colnames(fit)[2])]] <- lrt

## ---- eval=TRUE, echo = TRUE, include=TRUE, message=FALSE, warning=FALSE, fig.width = 7.2916667, fig.asp= 1/1.618----
str(dataMetrics, strict.width = "wrap")

## ---- eval=TRUE, echo = TRUE, include=TRUE, message=FALSE, warning=FALSE, fig.width = 7.2916667, fig.asp= 1/1.618----
ret <- plotPCP(data_st, dataMetrics, threshVal = 0.1, lineSize = 0.3,
  lineColor = "magenta", saveFile = FALSE)
ret[["S1_S3"]] + ggtitle("DEGs (FDR < 0.1)")

## ---- eval=TRUE, echo = TRUE, include=TRUE, message=FALSE, warning=FALSE, fig.width = 7.2916667, fig.asp= 1/1.618----
ret <- plotPCP(data_st, dataMetrics, threshVal = 0.1, lineSize = 0.3,
  lineColor = "magenta", saveFile = FALSE, hover = TRUE)
ret[["S1_S3"]] %>% layout(title="DEGs (FDR < 0.1)")

## ---- eval=FALSE, include=TRUE, message=FALSE, warning=FALSE, fig.width = 7.2916667, fig.asp= 1/1.618----
#  ret <- plotClusters(data_st, dataMetrics, threshVal = 0.1, nC = 2,
#    colList = c("#00A600FF", "#CC00FFFF"), lineSize = 0.5, verbose = TRUE)
#  plot(ret[["S1_S3_2"]])

## ---- eval=TRUE, include=TRUE, message=FALSE, warning=FALSE, fig.width = 7.2916667, fig.asp= 1/1.618----
ret <- plotClusters(data_st, dataMetrics, threshVal = 0.1, nC = 2,
  colList = c("#00A600FF", "#CC00FFFF"), lineSize = 0.5, saveFile = FALSE)
plot(ret[["S1_S3_2"]])

## ---- eval=TRUE, include=FALSE, message=FALSE, warning=FALSE------------------
S1S3Cluster1 <- c("Glyma08g22380.1", "Glyma08g19290.1", "Glyma20g30460.1", "Glyma18g00690.1", "Glyma14g14220.1", "Glyma07g09700.1", "Glyma16g08810.1", "Glyma01g26570.1", "Glyma08g19245.1", "Glyma03g29150.1", "Glyma12g10960.1", "Glyma02g40610.1", "Glyma08g11570.1", "Glyma18g42630.2", "Glyma17g17970.1", "Glyma07g01730.2", "Glyma18g25845.1", "Glyma08g44110.1", "Glyma19g26710.1", "Glyma10g34630.1", "Glyma19g26250.1", "Glyma14g40140.2", "Glyma12g31920.1", "Glyma15g14720.2", "Glyma10g31780.1", "Glyma13g26600.1", "Glyma02g01990.1", "Glyma08g03330.1", "Glyma14g05270.1", "Glyma13g22940.1", "Glyma05g31500.1", "Glyma12g04745.1", "Glyma05g31580.1", "Glyma11g21190.2", "Glyma01g42820.2", "Glyma12g28890.1", "Glyma05g28470.1", "Glyma10g30650.1", "Glyma04g03120.1", "Glyma02g03050.2", "Glyma08g45531.1")

S1S3Cluster2 <- c("Glyma01g24710.1", "Glyma17g09850.1", "Glyma04g37510.1", "Glyma12g32460.1", "Glyma04g39880.1", "Glyma18g52920.1", "Glyma05g27450.2", "Glyma06g12670.1", "Glyma03g19880.1", "Glyma05g32040.1", "Glyma03g41190.1", "Glyma19g40670.2", "Glyma01g01770.1", "Glyma12g01160.1", "Glyma06g06530.1", "Glyma12g02040.1", "Glyma06g41220.1", "Glyma14g11530.1", "Glyma15g11910.1", "Glyma09g02000.1", "Glyma18g44930.2", "Glyma12g03450.1", "Glyma08g10435.1")

## ---- eval=FALSE, include=TRUE, message=FALSE, warning=FALSE------------------
#  S1S3Cluster1 <- readRDS(paste0(tempdir(), "/S1_S3_2_1.rds"))

## ---- eval=FALSE, include=TRUE, message=FALSE, warning=FALSE------------------
#  S1S3Cluster2 <- readRDS(paste0(tempdir(), "/S1_S3_2_2.rds"))

## ---- eval=TRUE, include=TRUE, message=FALSE, warning=FALSE-------------------
S1S3Cluster1

## ---- eval=TRUE, include=TRUE, message=FALSE, warning=FALSE-------------------
S1S3Cluster2

## ---- eval=TRUE, echo = TRUE, include=TRUE, message=FALSE, warning=FALSE------
ret <- plotSM(data, geneList = S1S3Cluster1, pointColor = "#00A600FF",
  pointSize = 1, saveFile = FALSE)
ret[["S1_S3"]] + ggtitle(paste0("Cluster 1 (n = ", length(S1S3Cluster1), ")"))

## ---- eval=TRUE, echo = TRUE, include=TRUE, message=FALSE, warning=FALSE------
ret <- plotSM(data, geneList = S1S3Cluster2, pointColor = "#CC00FFFF",
  pointSize = 1, saveFile = FALSE)
ret[["S1_S3"]] + ggtitle(paste0("Cluster 2 (n = ", length(S1S3Cluster2), ")"))

## ---- eval=TRUE, echo = TRUE, include=TRUE, message=FALSE, warning=FALSE------
ret <- plotSM(data_st, geneList = S1S3Cluster1, pointColor = "#00A600FF",
  pointSize = 1, saveFile = FALSE)
ret[["S1_S3"]] + ggtitle(paste0("Cluster 1 (n = ", length(S1S3Cluster1), ")"))

## ---- eval=TRUE, echo = TRUE, include=TRUE, message=FALSE, warning=FALSE------
ret <- plotSM(data_st, geneList = S1S3Cluster2, pointColor = "#CC00FFFF",
  pointSize = 1, saveFile = FALSE)
ret[["S1_S3"]] + ggtitle(paste0("Cluster 2 (n = ", length(S1S3Cluster2), ")"))

## ---- eval=TRUE, echo = TRUE, include=TRUE, message=FALSE, warning=FALSE, fig.width = 7.2916667, fig.asp= 1/1.618----
ret <- plotLitre(data, geneList = S1S3Cluster1[1], pointColor = "#00A600FF", 
  pointSize = 2, saveFile = FALSE)
ret[[1]] + ggtitle(paste0("Cluster 1 (n = ", length(S1S3Cluster1), "): ", 
  S1S3Cluster1[1]))

## ---- eval=TRUE, echo = TRUE, include=TRUE, message=FALSE, warning=FALSE, fig.width = 7.2916667, fig.asp= 1/1.618----
ret <- plotLitre(data, geneList = S1S3Cluster2[1], pointColor = "#CC00FFFF", 
  pointSize = 2, saveFile = FALSE)
ret[[1]] + ggtitle(paste0("Cluster 2 (n = ", length(S1S3Cluster2), "): ", 
  S1S3Cluster2[1]))

## ---- eval=TRUE, echo = TRUE, include=TRUE, message=FALSE, warning=FALSE, fig.width = 7.2916667, fig.asp= 1/1.618----
ret <- plotLitre(data_st, geneList = S1S3Cluster1[1], pointColor = "#00A600FF", 
  pointSize = 2, saveFile = FALSE, option = "allPoints")
ret[[1]] + ggtitle(paste0("Cluster 1 (n = ", length(S1S3Cluster1), "): ", 
  S1S3Cluster1[1]))

## ---- eval=TRUE, echo = TRUE, include=TRUE, message=FALSE, warning=FALSE, fig.width = 7.2916667, fig.asp= 1/1.618----
ret <- plotLitre(data_st, geneList = S1S3Cluster2[1], pointColor = "#CC00FFFF", 
  pointSize = 2, saveFile = FALSE, option = "allPoints")
ret[[1]] + ggtitle(paste0("Cluster 2 (n = ", length(S1S3Cluster2), "): ", 
  S1S3Cluster2[1]))

## ---- eval=FALSE, include=TRUE, message=FALSE, warning=FALSE------------------
#  app <- plotLitreApp(data = data_st, dataMetrics = dataMetrics,
#      geneList = S1S3Cluster1, pointColor = "#00A600FF")
#  if (interactive()) {
#      shiny::runApp(app)
#  }

## ---- eval=FALSE, include=TRUE, message=FALSE, warning=FALSE------------------
#  app <- plotLitreApp(data = data_st, dataMetrics = dataMetrics,
#      geneList = S1S3Cluster2, pointColor = "#CC00FFFF")
#  if (interactive()) {
#      shiny::runApp(app)
#  }

## ---- eval=TRUE, echo = TRUE, include=TRUE, message=FALSE, warning=FALSE, fig.width = 7.2916667, fig.asp= 1/1.618----
ret <- plotVolcano(data = data, dataMetrics = dataMetrics, geneList = S1S3Cluster1,
  saveFile = FALSE, pointSize = 4, pointColor = "#00A600FF")
ret[["S1_S3"]] + ggtitle(paste0("Cluster 1 (n = ", length(S1S3Cluster1), ")"))

## ---- eval=TRUE, echo = TRUE, include=TRUE, message=FALSE, warning=FALSE, fig.width = 7.2916667, fig.asp= 1/1.618----
ret <- plotVolcano(data = data, dataMetrics = dataMetrics, geneList = S1S3Cluster1,
  saveFile = FALSE, pointSize = 2, pointColor = "#00A600FF", option = "allPoints", 
  hover = TRUE)
ret[["S1_S3"]] %>% layout(title=paste0("Cluster 1 (n = ", length(S1S3Cluster1), ")"))

## ---- eval=TRUE, echo = TRUE, include=TRUE, message=FALSE, warning=FALSE, fig.width = 7.2916667, fig.asp= 1/1.618----
ret <- plotVolcano(data = data, dataMetrics = dataMetrics, geneList = S1S3Cluster2,
  saveFile = FALSE, pointSize = 2, pointColor = "#CC00FFFF", option = "allPoints", 
  hover = TRUE)
ret[["S1_S3"]] %>% layout(title=paste0("Cluster 2 (n = ", length(S1S3Cluster2), ")"))

