## ---- eval=FALSE, include=TRUE, message=FALSE, warning=FALSE------------------
#  library(bigPint)
#  data("soybean_cn_sub")
#  soybean_cn_sub <- soybean_cn_sub[,1:7]
#  app <- plotSMApp(data=soybean_cn_sub)
#  if (interactive()) {
#      shiny::runApp(app)
#  }

## ---- eval=FALSE, include=TRUE, message=FALSE, warning=FALSE------------------
#  data("soybean_ir_sub")
#  data("soybean_ir_sub_metrics")
#  soybean_ir_sub_log <- soybean_ir_sub
#  soybean_ir_sub_log[,-1] <- log(soybean_ir_sub[,-1]+1)
#  app <- plotLitreApp(data=soybean_ir_sub_log,
#      dataMetrics = soybean_ir_sub_metrics)
#  if (interactive()) {
#      shiny::runApp(app, port = 1234, launch.browser = TRUE)
#  }

## ---- eval=FALSE, include=TRUE, message=FALSE, warning=FALSE------------------
#  soybean_ir_sub_st = as.data.frame(t(apply(as.matrix(soybean_ir_sub[,-1]), 1,
#    scale)))
#  soybean_ir_sub_st$ID = as.character(soybean_ir_sub$ID)
#  soybean_ir_sub_st = soybean_ir_sub_st[,c(length(soybean_ir_sub_st),
#    1:length(soybean_ir_sub_st)-1)]
#  colnames(soybean_ir_sub_st) = colnames(soybean_ir_sub)
#  nID = which(is.nan(soybean_ir_sub_st[,2]))
#  soybean_ir_sub_st[nID,2:length(soybean_ir_sub_st)] = 0
#  
#  plotGenes = filter(soybean_ir_sub_metrics[["N_P"]], FDR < 0.01, logFC < -4) %>%
#    select(ID)
#  pcpDat = filter(soybean_ir_sub_st, ID %in% plotGenes[,1])
#  app <- plotPCPApp(data = pcpDat)
#  if (interactive()) {
#      shiny::runApp(app, display.mode = "normal")
#  }

## ---- eval=FALSE, include=TRUE, message=FALSE, warning=FALSE------------------
#  app <- plotVolcanoApp(data = soybean_ir_sub_log,
#      dataMetrics = soybean_ir_sub_metrics)
#  if (interactive()) {
#      shiny::runApp(app)
#  }

