## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(echo=TRUE)

## ---- eval=TRUE, include=TRUE, message=FALSE----------------------------------
library(bigPint)
data("soybean_ir_sub")
head(soybean_ir_sub)

## ---- eval=TRUE, include=TRUE-------------------------------------------------
str(soybean_ir_sub, strict.width = "wrap")

## ---- eval=TRUE, include=TRUE-------------------------------------------------
data(soybean_cn_sub)

## ---- eval=TRUE, include=FALSE------------------------------------------------
data(soybean_cn_sub)
str(soybean_cn_sub, strict.width = "wrap")

## ---- eval=TRUE, include=TRUE, message=FALSE, warning=FALSE-------------------
library(dplyr)
soybean_cn_sub_S1S2 <- soybean_cn_sub %>% select("ID", contains("S1"), contains("S2"))
soybean_cn_sub_S1S3 <- soybean_cn_sub %>% select("ID", contains("S1"), contains("S3"))
soybean_cn_sub_S2S3 <- soybean_cn_sub %>% select("ID", contains("S2"), contains("S3"))

## ---- eval=TRUE, include=TRUE-------------------------------------------------
head(soybean_cn_sub_S1S2, 3)

## ---- eval=TRUE, include=TRUE-------------------------------------------------
head(soybean_cn_sub_S1S3, 3)

## ---- eval=TRUE, include=TRUE-------------------------------------------------
head(soybean_cn_sub_S2S3, 3)

