## ----setup,include=FALSE---------------------------------------------------
###################
# load ViSEAGO and mouse db package
library(ViSEAGO)

###################
# knitr document options
knitr::opts_chunk$set(
    eval=FALSE,echo=TRUE,fig.pos = 'H',
    fig.width=6,message=FALSE,comment=NA,warning=FALSE
)

## ----vignette_data_used,eval=TRUE------------------------------------------
###################
# load vignette data
data(
    myGOs,
    package="ViSEAGO"
)

## ----geneList_input--------------------------------------------------------
#  ###################
#  # load genes identifiants (GeneID,ENS...) background (expressed genes)
#  background<-scan(
#      system.file(
#          "extdata/data/input",
#          "background_L.txt",
#          package = "ViSEAGO"
#      ),
#      quiet=TRUE,
#      what=""
#  )
#  
#  ###################
#  # load Differentialy Expressed (DE) gene identifiants from lists
#  PregnantvsLactateDE<-scan(
#      system.file(
#          "extdata/data/input",
#          "pregnantvslactateDE.txt",
#          package = "ViSEAGO"
#      ),
#      quiet=TRUE,
#      what=""
#  )
#  
#  VirginvsLactateDE<-scan(
#      system.file(
#          "extdata/data/input",
#          "virginvslactateDE.txt",
#          package = "ViSEAGO"
#      ),
#      quiet=TRUE,
#      what=""
#  )
#  
#  VirginvsPregnantDE<-scan(
#      system.file(
#          "extdata/data/input",
#          "virginvspregnantDE.txt",
#          package = "ViSEAGO"
#      ),
#      quiet=TRUE,
#      what=""
#  )

## ----geneList_input-head,echo=FALSE----------------------------------------
#  ###################
#  # show the ten first lines of genes_DE (same as genes_ref)
#  head(PregnantvsLactateDE)

## ----Genomic-ressources----------------------------------------------------
#  ###################
#  # connect to Bioconductor
#  Bioconductor<-ViSEAGO::Bioconductor2GO()
#  
#  ###################
#  # load GO annotations from Bioconductor
#  myGENE2GO<-ViSEAGO::annotate(
#      "org.Mm.eg.db",
#      Bioconductor
#  )

## ----Genomic-ressources_show-----------------------------------------------
#  ###################
#  # display summary
#  myGENE2GO

## ----Genomic-ressources_display,echo=FALSE,eval=TRUE-----------------------
cat(
"- object class: gene2GO
- database: Bioconductor
- stamp/version: 2018-Oct11
- organism id: org.Mm.eg.db

GO annotations:
- Molecular Function (MF): 22744 annotated genes with 90922 terms (4133 unique terms)
- Biological Process (BP): 23239 annotated genes with 160094 terms (12087 unique terms)
- Cellular Component (CC): 23416 annotated genes with 105430 terms (1727 unique terms)"  
)

## ----Enrichment_data-------------------------------------------------------
#  ###################
#  # create topGOdata for BP for each list of DE genes
#  BP_PregnantvsLactate<-ViSEAGO::create_topGOdata(
#      geneSel=PregnantvsLactateDE,
#      allGenes=background,
#      gene2GO=myGENE2GO,
#      ont="BP",
#      nodeSize=5
#  )
#  
#  BP_VirginvsLactate<-ViSEAGO::create_topGOdata(
#      geneSel=VirginvsLactateDE,
#      allGenes=background,
#      gene2GO=myGENE2GO,
#      ont="BP",
#      nodeSize=5
#  )
#  
#  BP_VirginvsPregnant<-ViSEAGO::create_topGOdata(
#      geneSel=VirginvsPregnantDE,
#      allGenes=background,
#      gene2GO=myGENE2GO,
#      ont="BP",
#      nodeSize=5
#  )

## ----Enrichment_data_tests-------------------------------------------------
#  ###################
#  # perform TopGO tests
#  elim_BP_PregnantvsLactate<-topGO::runTest(
#      BP_PregnantvsLactate,
#      algorithm ="elim",
#      statistic = "fisher"
#  )
#  
#  elim_BP_VirginvsLactate<-topGO::runTest(
#      BP_VirginvsLactate,
#      algorithm ="elim",
#      statistic = "fisher"
#  )
#  
#  elim_BP_VirginvsPregnant<-topGO::runTest(
#      BP_VirginvsPregnant,
#      algorithm ="elim",
#      statistic = "fisher"
#  )

## ----Enrichment_merge------------------------------------------------------
#  ###################
#  # merge topGO results
#  BP_sResults<-ViSEAGO::merge_enrich_terms(
#      Input=list(
#          PregnantvsLactate=c(
#              "BP_PregnantvsLactate",
#              "elim_BP_PregnantvsLactate"
#          ),
#          VirginvsLactate=c(
#              "BP_VirginvsLactate",
#              "elim_BP_VirginvsLactate"
#          ),
#          VirginvsPregnant=c(
#              "BP_VirginvsPregnant",
#              "elim_BP_VirginvsPregnant"
#          )
#      )
#  )

## ----Enrichment_merge_show-------------------------------------------------
#  ###################
#  # display a summary
#  BP_sResults

## ----Enrichment_merge_display,echo=FALSE,eval=TRUE-------------------------
cat(
"- object class: gene2GO
- database: Bioconductor
- stamp/version: 2018-Apr4
- organism id: org.Mm.eg.db

GO annotations:
- Molecular Function (MF): 23049 annotated genes with 92018 terms (4118 unique terms)
- Biological Process (BP): 23843 annotated genes with 162583 terms (11881 unique terms)
- Cellular Component (CC): 23583 annotated genes with 102801 terms (1662 unique terms)
> BP_sResults
- object class: enrich_GO_terms
- ontology: BP
- input:
        PregnantvsLactate: elim
        VirginvsLactate: elim
        VirginvsPregnant: elim
- topGO summary:
 PregnantvsLactate
      BP_PregnantvsLactate 
        description: Bioconductor org.Mm.eg.db 2018-Apr4
        available_genes: 15804
        available_genes_significant: 7699
        feasible_genes: 14402
        feasible_genes_significant: 7185
        genes_nodeSize: 5
        nodes_number: 8189
        edges_number: 18887
      elim_BP_PregnantvsLactate 
        description: Bioconductor org.Mm.eg.db 2018-Apr4 
        test_name: fisher p<0.01
        algorithm_name: elim
        GO_scored: 8189
        GO_significant: 198
        feasible_genes: 14402
        feasible_genes_significant: 7185
        genes_nodeSize: 5
        Nontrivial_nodes: 8155 
 VirginvsLactate
      BP_VirginvsLactate 
        description: Bioconductor org.Mm.eg.db 2018-Apr4
        available_genes: 15804
        available_genes_significant: 9583
        feasible_genes: 14402
        feasible_genes_significant: 8898
        genes_nodeSize: 5
        nodes_number: 8189
        edges_number: 18887
      elim_BP_VirginvsLactate 
        description: Bioconductor org.Mm.eg.db 2018-Apr4 
        test_name: fisher p<0.01
        algorithm_name: elim
        GO_scored: 8189
        GO_significant: 151
        feasible_genes: 14402
        feasible_genes_significant: 8898
        genes_nodeSize: 5
        Nontrivial_nodes: 8180 
 VirginvsPregnant
      BP_VirginvsPregnant 
        description: Bioconductor org.Mm.eg.db 2018-Apr4
        available_genes: 15804
        available_genes_significant: 7302
        feasible_genes: 14402
        feasible_genes_significant: 6875
        genes_nodeSize: 5
        nodes_number: 8189
        edges_number: 18887
      elim_BP_VirginvsPregnant 
        description: Bioconductor org.Mm.eg.db 2018-Apr4 
        test_name: fisher p<0.01
        algorithm_name: elim
        GO_scored: 8189
        GO_significant: 232
        feasible_genes: 14402
        feasible_genes_significant: 6875
        genes_nodeSize: 5
        Nontrivial_nodes: 8143 
 
- enrich GOs data.table (p<0.01 in at least one list): 509 GO terms of 3 conditions.
        PregnantvsLactate : 198 terms
        VirginvsLactate : 151 terms
        VirginvsPregnant : 232 terms"
)

## ----Enrichment_merge_table------------------------------------------------
#  ###################
#  # show table in interactive mode
#  ViSEAGO::show_table(BP_sResults)

## ----Enrichment_merge_count------------------------------------------------
#  ###################
#  # barchart of significant (or not) GO terms by comparison
#  ViSEAGO::GOcount(BP_sResults)

## ----Enrichment_merge_interactions-----------------------------------------
#  ###################
#  # display intersections
#  ViSEAGO::Upset(
#      BP_sResults,
#      file="upset.xls"
#  )

## ----SS_build--------------------------------------------------------------
#  ###################
#  # create GO_SS-class object
#  myGOs<-ViSEAGO::build_GO_SS(
#      gene2GO=myGENE2GO,
#      enrich_GO_terms=BP_sResults
#  )

## ----SS_compute------------------------------------------------------------
#  ###################
#  # compute Semantic Similarity (SS)
#  myGOs<-ViSEAGO::compute_SS_distances(
#      myGOs,
#      distance="Wang"
#  )

## ----SS_build_compute_show-------------------------------------------------
#  ###################
#  # display a summary
#  myGOs

## ----SS_build_compute_display,echo=FALSE,eval=TRUE-------------------------
cat(
"- object class: GO_SS
- database: Bioconductor
- stamp/version: 2018-Apr4
- organism id: org.Mm.eg.db
- ontology: BP
- input:
        PregnantvsLactate: elim
        VirginvsLactate: elim
        VirginvsPregnant: elim
- topGO summary:
 PregnantvsLactate
      BP_PregnantvsLactate 
        description: Bioconductor org.Mm.eg.db 2018-Apr4
        available_genes: 15804
        available_genes_significant: 7699
        feasible_genes: 14402
        feasible_genes_significant: 7185
        genes_nodeSize: 5
        nodes_number: 8189
        edges_number: 18887
      elim_BP_PregnantvsLactate 
        description: Bioconductor org.Mm.eg.db 2018-Apr4 
        test_name: fisher p<0.01
        algorithm_name: elim
        GO_scored: 8189
        GO_significant: 198
        feasible_genes: 14402
        feasible_genes_significant: 7185
        genes_nodeSize: 5
        Nontrivial_nodes: 8155 
 VirginvsLactate
      BP_VirginvsLactate 
        description: Bioconductor org.Mm.eg.db 2018-Apr4
        available_genes: 15804
        available_genes_significant: 9583
        feasible_genes: 14402
        feasible_genes_significant: 8898
        genes_nodeSize: 5
        nodes_number: 8189
        edges_number: 18887
      elim_BP_VirginvsLactate 
        description: Bioconductor org.Mm.eg.db 2018-Apr4 
        test_name: fisher p<0.01
        algorithm_name: elim
        GO_scored: 8189
        GO_significant: 151
        feasible_genes: 14402
        feasible_genes_significant: 8898
        genes_nodeSize: 5
        Nontrivial_nodes: 8180 
 VirginvsPregnant
      BP_VirginvsPregnant 
        description: Bioconductor org.Mm.eg.db 2018-Apr4
        available_genes: 15804
        available_genes_significant: 7302
        feasible_genes: 14402
        feasible_genes_significant: 6875
        genes_nodeSize: 5
        nodes_number: 8189
        edges_number: 18887
      elim_BP_VirginvsPregnant 
        description: Bioconductor org.Mm.eg.db 2018-Apr4 
        test_name: fisher p<0.01
        algorithm_name: elim
        GO_scored: 8189
        GO_significant: 232
        feasible_genes: 14402
        feasible_genes_significant: 6875
        genes_nodeSize: 5
        Nontrivial_nodes: 8143 
 
- enrich GOs data.table: 509 GO terms of 3 conditions.
        PregnantvsLactate : 198 terms
        VirginvsLactate : 151 terms
        VirginvsPregnant : 232 terms
- terms distances:  Wang"
)

## ----SS_terms_mdsplot------------------------------------------------------
#  ###################
#  # MDSplot
#  ViSEAGO::MDSplot(myGOs)

## ----SS_Wang-wardD2--------------------------------------------------------
#  ##################
#  # Create GOterms heatmap
#  Wang_clusters_wardD2<-ViSEAGO::GOterms_heatmap(
#      myGOs,
#      showIC=TRUE,
#      showGOlabels =FALSE,
#      GO.tree=list(
#          tree=list(
#              distance="Wang",
#              aggreg.method="ward.D2"
#          ),
#          cut=list(
#              dynamic=list(
#                  pamStage=TRUE,
#                  pamRespectsDendro=TRUE,
#                  deepSplit=2,
#                  minClusterSize =2
#              )
#          )
#      ),
#      samples.tree=NULL
#  )

## ----SS_Wang-wardD2_heatmap_display----------------------------------------
#  ###################
#  # display the heatmap
#  ViSEAGO::show_heatmap(
#      Wang_clusters_wardD2,
#      "GOterms"
#  )

## ----SS_Wang-ward.D2_table-------------------------------------------------
#  ###################
#  # display table
#  ViSEAGO::show_table(Wang_clusters_wardD2)

## ----SS_Wang-ward.D2_mdsplot-----------------------------------------------
#  ###################
#  # colored MDSplot
#  ViSEAGO::MDSplot(Wang_clusters_wardD2)

## ----SS_Wang-wardD2_groups-------------------------------------------------
#  ###################
#  # calculate semantic similarites between clusters of GO terms
#  Wang_clusters_wardD2<-ViSEAGO::compute_SS_distances(
#      Wang_clusters_wardD2,
#      distance="BMA"
#  )

## ----SS_Wang-ward.D2_groups_mdsplot----------------------------------------
#  ###################
#  # MDSplot
#  ViSEAGO::MDSplot(
#      Wang_clusters_wardD2,
#      "GOclusters"
#  )

## ----SS_Wang-wardD2_groups_heatmap-----------------------------------------
#  ###################
#  # GOclusters heatmap
#  Wang_clusters_wardD2<-ViSEAGO::GOclusters_heatmap(
#      Wang_clusters_wardD2,
#      tree=list(
#          distance="BMA",
#          aggreg.method="ward.D2"
#      )
#  )

## ----SS_Wang-ward.D2_groups_heatmap_display--------------------------------
#  ###################
#  # display the heatmap
#  ViSEAGO::show_heatmap(
#      Wang_clusters_wardD2,
#      "GOclusters"
#  )

## ----SS_Wang-wardD2_groups_show--------------------------------------------
#  ###################
#  # display a summary
#  Wang_clusters_wardD2

## ----SS_Wang-wardD2_groups_display,echo=FALSE,eval=TRUE--------------------
cat(
"- object class: GO_clusters
- database: Bioconductor
- stamp/version: 2018-Apr4
- organism id: org.Mm.eg.db
- ontology: BP
- input:
        PregnantvsLactate: elim
        VirginvsLactate: elim
        VirginvsPregnant: elim
- topGO summary:
 PregnantvsLactate
      BP_PregnantvsLactate 
        description: Bioconductor org.Mm.eg.db 2018-Apr4
        available_genes: 15804
        available_genes_significant: 7699
        feasible_genes: 14402
        feasible_genes_significant: 7185
        genes_nodeSize: 5
        nodes_number: 8189
        edges_number: 18887
      elim_BP_PregnantvsLactate 
        description: Bioconductor org.Mm.eg.db 2018-Apr4 
        test_name: fisher p<0.01
        algorithm_name: elim
        GO_scored: 8189
        GO_significant: 198
        feasible_genes: 14402
        feasible_genes_significant: 7185
        genes_nodeSize: 5
        Nontrivial_nodes: 8155 
 VirginvsLactate
      BP_VirginvsLactate 
        description: Bioconductor org.Mm.eg.db 2018-Apr4
        available_genes: 15804
        available_genes_significant: 9583
        feasible_genes: 14402
        feasible_genes_significant: 8898
        genes_nodeSize: 5
        nodes_number: 8189
        edges_number: 18887
      elim_BP_VirginvsLactate 
        description: Bioconductor org.Mm.eg.db 2018-Apr4 
        test_name: fisher p<0.01
        algorithm_name: elim
        GO_scored: 8189
        GO_significant: 151
        feasible_genes: 14402
        feasible_genes_significant: 8898
        genes_nodeSize: 5
        Nontrivial_nodes: 8180 
 VirginvsPregnant
      BP_VirginvsPregnant 
        description: Bioconductor org.Mm.eg.db 2018-Apr4
        available_genes: 15804
        available_genes_significant: 7302
        feasible_genes: 14402
        feasible_genes_significant: 6875
        genes_nodeSize: 5
        nodes_number: 8189
        edges_number: 18887
      elim_BP_VirginvsPregnant 
        description: Bioconductor org.Mm.eg.db 2018-Apr4 
        test_name: fisher p<0.01
        algorithm_name: elim
        GO_scored: 8189
        GO_significant: 232
        feasible_genes: 14402
        feasible_genes_significant: 6875
        genes_nodeSize: 5
        Nontrivial_nodes: 8143 
 
- enrich GOs data.table: 509 GO terms of 3 conditions.
        PregnantvsLactate : 198 terms
        VirginvsLactate : 151 terms
        VirginvsPregnant : 232 terms
- clusters distances: BMA
- Heatmap:
          * GOterms: TRUE
                    - GO.tree:
                              tree.distance: Wang
                              tree.aggreg.method: ward.D2
                              cut.dynamic.pamStage: TRUE
                              cut.dynamic.pamRespectsDendro: TRUE
                              cut.dynamic.deepSplit: 2
                              cut.dynamic.minClusterSize: 2
                              number of clusters: 56
                              clusters min size: 1
                              clusters mean size: 30
                              clusters max size: 56
                   - sample.tree: FALSE
          * GOclusters: TRUE
                       - tree:
                              distance: BMA
                              aggreg.method: ward.D2"
)

## ----session,eval=TRUE,echo=FALSE------------------------------------------
sessionInfo()

