## ----echo=FALSE, include=FALSE---------------------------------------------
knitr::opts_chunk$set(tidy = FALSE, cache = TRUE, dev = "png",
                      message = FALSE, error = FALSE, warning = TRUE)

## ----load-packages---------------------------------------------------------
library("SummarizedBenchmark")
library("magrittr")

## ----run-case-study--------------------------------------------------------
data(tdat)

b <- BenchDesign(data = tdat) %>%
    addMethod(label = "bonf", func = p.adjust,
              params = rlang::quos(p = pval, method = "bonferroni")) %>%
    addMethod(label = "BH",
              func = p.adjust,
              params = rlang::quos(p = pval, method = "BH")) %>%
    addMethod(label = "qv",
              func = qvalue::qvalue,
              params = rlang::quos(p = pval),
              post = function(x) { x$qvalues })

sb <- buildBench(b, truthCols = "H")

## --------------------------------------------------------------------------
BDMethodList(b)
BDData(b)

## --------------------------------------------------------------------------
BDMethodList(b)[["bonf"]]

## --------------------------------------------------------------------------
BDMethodList(b)[["bonf2"]] <- BDMethodList(b)[["bonf"]]
b

## --------------------------------------------------------------------------
BDMethodList(b)[["bonf"]] <- NULL
b

## --------------------------------------------------------------------------
bdm_bonf <- BDMethod(x = p.adjust, 
                     params = rlang::quos(p = pval, 
                                          method = "bonferroni"))
bdm_bonf

## --------------------------------------------------------------------------
BDMethodList(b)[["bonf"]] <- bdm_bonf
b

## --------------------------------------------------------------------------
BDData(b) <- NULL
b

## --------------------------------------------------------------------------
bdd <- BDData(data = tdat)
BDData(b) <- bdd
b

## --------------------------------------------------------------------------
b <- hashBDData(b)
b

## --------------------------------------------------------------------------
BDMethodList(b)[["bonf2"]] <- NULL

## --------------------------------------------------------------------------
sbSub <- sb[, 1:2]
colData(sbSub)

## --------------------------------------------------------------------------
BenchDesign(sb)

## --------------------------------------------------------------------------
compareBDData(BDData(tdat), BenchDesign(sb))

## --------------------------------------------------------------------------
metadata(sb)$sessions[[1]]

## --------------------------------------------------------------------------
mymethod <- function(x) {
    mysubmethod(x)
}
mybd <- BenchDesign(data = list(vals = 1:5))
mybd <- addMethod(mybd, "method1", mymethod,
                  params = rlang::quos(x = vals))

## --------------------------------------------------------------------------
BDMethod(mybd, "method1")@f

## ---- message = TRUE-------------------------------------------------------
tryCatch({ buildBench(mybd) }, error = function(e) print(e))

## --------------------------------------------------------------------------
m <- 5
mymult <- function(x) {
    m * x
}
m <- 2

mybd <- BenchDesign(data = list(vals = 1:5, m = 10))
mybd <- addMethod(mybd, "methodr", mymult,
                  params = rlang::quos(x = vals))

## --------------------------------------------------------------------------
assay(buildBench(mybd))

## --------------------------------------------------------------------------
b_withmeta <- BenchDesign(data = tdat) %>%
    addMethod(label = "bonf", func = p.adjust,
              meta = list(type = "FWER control"),
              params = rlang::quos(p = pval, method = "bonferroni")) %>%
    addMethod(label = "BH",
              func = p.adjust,
              meta = list(type = "FDR control"),
              params = rlang::quos(p = pval, method = "BH"))

sb_withmeta <- buildBench(b_withmeta)
colData(sb_withmeta)

## --------------------------------------------------------------------------
printMethod(b, "qv")

## --------------------------------------------------------------------------
qv_wrapper <- function(...) {
    qvalue::qvalue(...)$qvalues
}

b_qv <- BenchDesign(data = tdat) %>%
    addMethod(label = "qv",
              func = qvalue::qvalue,
              params = rlang::quos(p = pval),
              post = function(x) { x$qvalues }) %>%
    addMethod(label = "qv_wrapper",
              func = qv_wrapper,
              params = rlang::quos(p = pval))

## --------------------------------------------------------------------------
sb_qv <- buildBench(b_qv)
head(assay(sb_qv))
colData(sb_qv)

## --------------------------------------------------------------------------
b_qv <- b_qv %>%
    addMethod(label = "qv_pkgfunc",
              func = qv_wrapper,
              meta = list(pkg_func = qvalue::qvalue),
              params = rlang::quos(p = pval)) %>%
    addMethod(label = "qv_pkgname",
              func = qv_wrapper,
              meta = list(pkg_name = "qvalue", pkg_vers = as.character(packageVersion("qvalue"))),
              params = rlang::quos(p = pval))

sb_qv <- buildBench(b_qv)
colData(sb_qv)

## --------------------------------------------------------------------------
printMethod(b, "qv")

## --------------------------------------------------------------------------
new_params <- rlang::quos(pi0 = 0.9, bd.meta = list(type = "FDR control"))
b_modqv <- modifyMethod(b, label = "qv", params = new_params)

printMethod(b_modqv, "qv")

## --------------------------------------------------------------------------
b_modqv <- modifyMethod(b, label = "qv", params = new_params, .overwrite = TRUE)

printMethod(b_modqv, "qv")

## --------------------------------------------------------------------------
b_expand <- expandMethod(b, label = "qv", 
                         params = list(qv_p90 = rlang::quos(pi0 = 0.90),
                                       qv_p10 = rlang::quos(pi0 = 0.10)),
                         .replace = FALSE)

b_expand
printMethod(b_expand, "qv_p90")
printMethod(b_expand, "qv_p10")

## --------------------------------------------------------------------------
b_expand <- expandMethod(b, label = "qv", onlyone = "pi0",
                         params = rlang::quos(qv_p90 = 0.90,
                                              qv_p10 = 0.10),
                         .replace = FALSE)

b_expand

## ----cobraData, message=FALSE, warning=FALSE-------------------------------
library(iCOBRA)
data(cobradata_example)

## ----arrangeLists----------------------------------------------------------
assays <- list(qvalue = cobradata_example@padj,
               logFC = cobradata_example@score)
assays[["qvalue"]]$DESeq2 <- p.adjust(cobradata_example@pval$DESeq2, method = "BH")

head(assays[["qvalue"]], 3)
head(assays[["logFC"]], 3)

## ----groundTruths----------------------------------------------------------
library(S4Vectors)

groundTruth <- DataFrame(cobradata_example@truth[, c("status", "logFC")])
colnames(groundTruth) <- names(assays)
groundTruth <- groundTruth[rownames(assays[[1]]), ]

head(groundTruth)

## ----buildColData----------------------------------------------------------
colData <- DataFrame(method = colnames(assays[[1]]))
colData

## ----buildSB---------------------------------------------------------------
sb <- SummarizedBenchmark(assays = assays, colData = colData, groundTruth = groundTruth)

