df <- data.frame(
    Title = sprintf("DICE RNA-seq %s", c("logcounts", "colData")),
    Description = sprintf("%s 1561 RNA-seq samples of immune cells generated by DICE", 
        c("Matrix of log-normalized expression values from", "Per-sample metadata containing cell type labels of")),
    RDataPath = file.path("SingleR", "dice","1.0.0", c("logcounts.rds", "coldata.rds")),
    BiocVersion="3.10", 
    Genome=NA, 
    SourceType="TXT", 
    SourceUrl="https://dice-database.org/downloads",
    SourceVersion="DICE-DB 1",
    Species="Homo sapiens", 
    TaxonomyId="9606",
    Coordinate_1_based=NA, 
    DataProvider="DICE",
    Maintainer="Jared Andrews <jared.andrews07@gmail.com>",
    RDataClass=c("matrix", "DataFrame"), 
    DispatchClass="Rds", 
    stringsAsFactors = FALSE
)

write.csv(file="../extdata/metadata-dice.csv", df, row.names=FALSE)
