## ----load_files, message=FALSE---------------------------------------------
library(SIAMCAT)

data("feat_crc_zeller", package="SIAMCAT")
data("meta_crc_zeller", package="SIAMCAT")

## ----show_features---------------------------------------------------------
feat.crc.zeller[1:3, 1:3]
dim(feat.crc.zeller)

## ----show_meta-------------------------------------------------------------
head(meta.crc.zeller)

## ----create_label----------------------------------------------------------
label.crc.zeller <- create.label(meta=meta.crc.zeller,
    label='Group', case='CRC')

## ----start-----------------------------------------------------------------
siamcat <- siamcat(feat=feat.crc.zeller,
    label=label.crc.zeller,
    meta=meta.crc.zeller)

## ----show_siamcat----------------------------------------------------------
show(siamcat)

## ----filter_feat-----------------------------------------------------------
siamcat <- filter.features(siamcat,
    filter.method = 'abundance',
    cutoff = 0.001)

## ----check_associations, eval=FALSE----------------------------------------
#  siamcat <- check.associations(
#      siamcat,
#      sort.by = 'fc',
#      alpha = 0.05,
#      mult.corr = "fdr",
#      detect.lim = 10 ^-6,
#      plot.type = "quantile.box",
#      panels = c("fc", "prevalence", "auroc"))

## ----normalize_feat--------------------------------------------------------
siamcat <- normalize.features(
    siamcat,
    norm.method = "log.unit",
    norm.param = list(
        log.n0 = 1e-06,
        n.p = 2,
        norm.margin = 1
    )
)

## ----data_split------------------------------------------------------------
siamcat <-  create.data.split(
    siamcat,
    num.folds = 5,
    num.resample = 2
)

## ----train_model, message=FALSE, results='hide'----------------------------
siamcat <- train.model(
    siamcat,
    method = "lasso"
)

## ----show_models-----------------------------------------------------------
# get information about the model type
model_type(siamcat)

# access the models
models <- models(siamcat)
models[[1]]

## ----make_predictions, message=FALSE, results='hide'-----------------------
siamcat <- make.predictions(siamcat)
pred_matrix <- pred_matrix(siamcat)

## ----pred_matrix_head------------------------------------------------------
head(pred_matrix)

## ----eval_predictions------------------------------------------------------
siamcat <-  evaluate.predictions(siamcat)

## ----eval_plot, fig.height=6, fig.width=6, fig.align='left', message=FALSE----
model.evaluation.plot(siamcat)

## ----eval=FALSE------------------------------------------------------------
#  model.interpretation.plot(
#      siamcat,
#      fn.plot = 'interpretation.pdf',
#      consens.thres = 0.5,
#      norm.models = TRUE,
#      limits = c(-3, 3),
#      heatmap.type = 'zscore',
#  )

## --------------------------------------------------------------------------
sessionInfo()

