## ---- include=FALSE--------------------------------------------------------
library(BiocStyle)

## ---- eval=FALSE-----------------------------------------------------------
#  if (!requireNamespace("BiocManager", quietly = TRUE))
#      install.packages("BiocManager")
#  BiocManager::install("SEtools")

## ---- eval=FALSE-----------------------------------------------------------
#  devtools::install_github("plger/SEtools")

## --------------------------------------------------------------------------
suppressPackageStartupMessages({
  library(SummarizedExperiment)
  library(SEtools)
})
data("SE", package="SEtools")
SE

## --------------------------------------------------------------------------
g <- c("Egr1", "Nr4a1", "Fos", "Egr2", "Sgk1", "Arc", "Dusp1", "Fosb", "Sik1")
sehm(SE, genes=g)
sehm(SE, genes=g, scale="row")

## --------------------------------------------------------------------------
sehm(SE, genes=g, scale="row", anno_rows="meanTPM")

## --------------------------------------------------------------------------
sehm(SE, genes=g, scale="row", anno_rows="meanTPM", gaps_at="Condition")

## --------------------------------------------------------------------------
lfcs <- assays(SE)$logcpm-rowMeans(assays(SE)$logcpm[,which(SE$Condition=="Homecage")])
rowData(SE)$cluster <- as.character(kmeans(lfcs,4)$cluster)
sehm(SE, scale="row", anno_rows="cluster", toporder="cluster", gaps_at="Condition")

## --------------------------------------------------------------------------
crossHm( list(se1=SE, se2=SE), g, 
         anno_colors = list( Condition=c( Homecage="green",
                                          Handling="orange",
                                          Restraint="red",
                                          Swim="blue")
                            )
        )

## --------------------------------------------------------------------------
options("SEtools_def_hmcols"=c("white","grey","black"))
ancols <- list( Condition=c( Homecage="green",
                             Handling="orange",
                             Restraint="red",
                             Swim="blue" ) )
options("SEtools_def_anno_colors"=ancols)
sehm(SE, g, do.scale = TRUE)

## --------------------------------------------------------------------------
se1 <- SE[,1:10]
se2 <- SE[,11:20]
se3 <- mergeSEs( list(se1=se1, se2=se2) )
se3

## --------------------------------------------------------------------------
se3 <- mergeSEs( list(se1=se1, se2=se2), do.scale=FALSE)

## --------------------------------------------------------------------------
se3 <- mergeSEs( list(se1=se1, se2=se2), use.assays=c("counts", "logcpm"), do.scale=c(FALSE, TRUE))

## ---- fig.cap="An example ggplot created from a melted SE.", fig.height=5----
d <- meltSE(SE, genes=g[1:4])
head(d)
suppressPackageStartupMessages(library(ggplot2))
ggplot(d, aes(Condition, counts)) + geom_violin() + facet_wrap(~feature, scale="free")

## ----sessionInfo, echo=FALSE-----------------------------------------------
sessionInfo()

