/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph.util;

import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.Forest;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Tree;
import edu.uci.ics.jung.graph.UndirectedGraph;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.graph.util.Pair;
import java.io.Serializable;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Graphs {
    public static <V, E> Graph<V, E> synchronizedGraph(Graph<V, E> graph) {
        return new SynchronizedGraph(graph);
    }

    public static <V, E> DirectedGraph<V, E> synchronizedDirectedGraph(DirectedGraph<V, E> graph) {
        return new SynchronizedDirectedGraph(graph);
    }

    public static <V, E> UndirectedGraph<V, E> synchronizedUndirectedGraph(UndirectedGraph<V, E> graph) {
        return new SynchronizedUndirectedGraph(graph);
    }

    public static <V, E> SynchronizedForest<V, E> synchronizedForest(Forest<V, E> forest) {
        return new SynchronizedForest<V, E>(forest);
    }

    public static <V, E> SynchronizedTree<V, E> synchronizedTree(Tree<V, E> tree) {
        return new SynchronizedTree<V, E>(tree);
    }

    public static <V, E> Graph<V, E> unmodifiableGraph(Graph<V, E> graph) {
        return new UnmodifiableGraph(graph);
    }

    public static <V, E> DirectedGraph<V, E> unmodifiableDirectedGraph(DirectedGraph<V, E> graph) {
        return new UnmodifiableDirectedGraph(graph);
    }

    public static <V, E> UndirectedGraph<V, E> unmodifiableUndirectedGraph(UndirectedGraph<V, E> graph) {
        return new UnmodifiableUndirectedGraph(graph);
    }

    public static <V, E> UnmodifiableTree<V, E> unmodifiableTree(Tree<V, E> tree) {
        return new UnmodifiableTree(tree);
    }

    public static <V, E> UnmodifiableForest<V, E> unmodifiableForest(Forest<V, E> forest) {
        return new UnmodifiableForest(forest);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class UnmodifiableTree<V, E>
    extends UnmodifiableForest<V, E>
    implements Tree<V, E>,
    Serializable {
        private UnmodifiableTree(Tree<V, E> delegate) {
            super(delegate);
        }

        @Override
        public int getDepth(V vertex) {
            return ((Tree)this.delegate).getDepth(vertex);
        }

        @Override
        public int getHeight() {
            return ((Tree)this.delegate).getHeight();
        }

        @Override
        public V getRoot() {
            return ((Tree)this.delegate).getRoot();
        }

        @Override
        public Collection<Tree<V, E>> getTrees() {
            return ((Tree)this.delegate).getTrees();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class UnmodifiableForest<V, E>
    extends UnmodifiableGraph<V, E>
    implements Forest<V, E>,
    Serializable {
        private UnmodifiableForest(Forest<V, E> delegate) {
            super(delegate);
        }

        @Override
        public Collection<Tree<V, E>> getTrees() {
            return ((Forest)this.delegate).getTrees();
        }

        @Override
        public int getChildCount(V vertex) {
            return ((Forest)this.delegate).getChildCount(vertex);
        }

        @Override
        public Collection<E> getChildEdges(V vertex) {
            return ((Forest)this.delegate).getChildEdges(vertex);
        }

        @Override
        public Collection<V> getChildren(V vertex) {
            return ((Forest)this.delegate).getChildren(vertex);
        }

        @Override
        public V getParent(V vertex) {
            return ((Forest)this.delegate).getParent(vertex);
        }

        @Override
        public E getParentEdge(V vertex) {
            return ((Forest)this.delegate).getParentEdge(vertex);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class UnmodifiableUndirectedGraph<V, E>
    extends UnmodifiableAbstractGraph<V, E>
    implements UndirectedGraph<V, E>,
    Serializable {
        private UnmodifiableUndirectedGraph(UndirectedGraph<V, E> delegate) {
            super(delegate);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class UnmodifiableDirectedGraph<V, E>
    extends UnmodifiableAbstractGraph<V, E>
    implements DirectedGraph<V, E>,
    Serializable {
        private UnmodifiableDirectedGraph(DirectedGraph<V, E> delegate) {
            super(delegate);
        }

        @Override
        public V getDest(E directed_edge) {
            return ((DirectedGraph)this.delegate).getDest(directed_edge);
        }

        @Override
        public V getSource(E directed_edge) {
            return ((DirectedGraph)this.delegate).getSource(directed_edge);
        }

        @Override
        public boolean isDest(V vertex, E edge) {
            return ((DirectedGraph)this.delegate).isDest(vertex, edge);
        }

        @Override
        public boolean isSource(V vertex, E edge) {
            return ((DirectedGraph)this.delegate).isSource(vertex, edge);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class UnmodifiableGraph<V, E>
    extends UnmodifiableAbstractGraph<V, E>
    implements Serializable {
        private UnmodifiableGraph(Graph<V, E> delegate) {
            super(delegate);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class UnmodifiableAbstractGraph<V, E>
    implements Graph<V, E>,
    Serializable {
        protected Graph<V, E> delegate;

        private UnmodifiableAbstractGraph(Graph<V, E> delegate) {
            if (delegate == null) {
                throw new NullPointerException();
            }
            this.delegate = delegate;
        }

        @Override
        public EdgeType getDefaultEdgeType() {
            return this.delegate.getDefaultEdgeType();
        }

        @Override
        public boolean addEdge(E e, V v1, V v2, EdgeType edgeType) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addEdge(E e, Collection<? extends V> vertices, EdgeType edgeType) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addEdge(E e, V v1, V v2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addVertex(V vertex) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isIncident(V vertex, E edge) {
            return this.delegate.isIncident(vertex, edge);
        }

        @Override
        public boolean isNeighbor(V v1, V v2) {
            return this.delegate.isNeighbor(v1, v2);
        }

        @Override
        public int degree(V vertex) {
            return this.delegate.degree(vertex);
        }

        @Override
        public E findEdge(V v1, V v2) {
            return this.delegate.findEdge(v1, v2);
        }

        @Override
        public Collection<E> findEdgeSet(V v1, V v2) {
            return this.delegate.findEdgeSet(v1, v2);
        }

        @Override
        public Collection<E> getEdges() {
            return this.delegate.getEdges();
        }

        @Override
        public int getEdgeCount() {
            return this.delegate.getEdgeCount();
        }

        @Override
        public int getEdgeCount(EdgeType edge_type) {
            return this.delegate.getEdgeCount(edge_type);
        }

        @Override
        public int getVertexCount() {
            return this.delegate.getVertexCount();
        }

        @Override
        public Collection<E> getEdges(EdgeType edgeType) {
            return this.delegate.getEdges(edgeType);
        }

        @Override
        public Pair<V> getEndpoints(E edge) {
            return this.delegate.getEndpoints(edge);
        }

        @Override
        public Collection<E> getIncidentEdges(V vertex) {
            return this.delegate.getIncidentEdges(vertex);
        }

        @Override
        public Collection<V> getIncidentVertices(E edge) {
            return this.delegate.getIncidentVertices(edge);
        }

        @Override
        public Collection<E> getInEdges(V vertex) {
            return this.delegate.getInEdges(vertex);
        }

        @Override
        public Collection<V> getNeighbors(V vertex) {
            return this.delegate.getNeighbors(vertex);
        }

        @Override
        public V getOpposite(V vertex, E edge) {
            return this.delegate.getOpposite(vertex, edge);
        }

        @Override
        public Collection<E> getOutEdges(V vertex) {
            return this.delegate.getOutEdges(vertex);
        }

        @Override
        public Collection<V> getPredecessors(V vertex) {
            return this.delegate.getPredecessors(vertex);
        }

        @Override
        public Collection<V> getSuccessors(V vertex) {
            return this.delegate.getSuccessors(vertex);
        }

        @Override
        public Collection<V> getVertices() {
            return this.delegate.getVertices();
        }

        @Override
        public int inDegree(V vertex) {
            return this.delegate.inDegree(vertex);
        }

        @Override
        public EdgeType getEdgeType(E edge) {
            return this.delegate.getEdgeType(edge);
        }

        @Override
        public boolean isPredecessor(V v1, V v2) {
            return this.delegate.isPredecessor(v1, v2);
        }

        @Override
        public boolean isSuccessor(V v1, V v2) {
            return this.delegate.isSuccessor(v1, v2);
        }

        @Override
        public int getNeighborCount(V vertex) {
            return this.delegate.getNeighborCount(vertex);
        }

        @Override
        public int getPredecessorCount(V vertex) {
            return this.delegate.getPredecessorCount(vertex);
        }

        @Override
        public int getSuccessorCount(V vertex) {
            return this.delegate.getSuccessorCount(vertex);
        }

        @Override
        public int outDegree(V vertex) {
            return this.delegate.outDegree(vertex);
        }

        @Override
        public boolean removeEdge(E edge) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeVertex(V vertex) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V getDest(E directed_edge) {
            return this.delegate.getDest(directed_edge);
        }

        @Override
        public V getSource(E directed_edge) {
            return this.delegate.getSource(directed_edge);
        }

        @Override
        public boolean isDest(V vertex, E edge) {
            return this.delegate.isDest(vertex, edge);
        }

        @Override
        public boolean isSource(V vertex, E edge) {
            return this.delegate.isSource(vertex, edge);
        }

        @Override
        public int getIncidentCount(E edge) {
            return this.delegate.getIncidentCount(edge);
        }

        @Override
        public boolean addEdge(E hyperedge, Collection<? extends V> vertices) {
            return this.delegate.addEdge(hyperedge, vertices);
        }

        @Override
        public boolean containsEdge(E edge) {
            return this.delegate.containsEdge(edge);
        }

        @Override
        public boolean containsVertex(V vertex) {
            return this.delegate.containsVertex(vertex);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SynchronizedForest<V, E>
    extends SynchronizedDirectedGraph<V, E>
    implements Forest<V, E> {
        public SynchronizedForest(Forest<V, E> delegate) {
            super(delegate);
        }

        @Override
        public synchronized Collection<Tree<V, E>> getTrees() {
            return ((Forest)this.delegate).getTrees();
        }

        @Override
        public int getChildCount(V vertex) {
            return ((Forest)this.delegate).getChildCount(vertex);
        }

        @Override
        public Collection<E> getChildEdges(V vertex) {
            return ((Forest)this.delegate).getChildEdges(vertex);
        }

        @Override
        public Collection<V> getChildren(V vertex) {
            return ((Forest)this.delegate).getChildren(vertex);
        }

        @Override
        public V getParent(V vertex) {
            return ((Forest)this.delegate).getParent(vertex);
        }

        @Override
        public E getParentEdge(V vertex) {
            return ((Forest)this.delegate).getParentEdge(vertex);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SynchronizedTree<V, E>
    extends SynchronizedForest<V, E>
    implements Tree<V, E> {
        public SynchronizedTree(Tree<V, E> delegate) {
            super(delegate);
        }

        @Override
        public synchronized int getDepth(V vertex) {
            return ((Tree)this.delegate).getDepth(vertex);
        }

        @Override
        public synchronized int getHeight() {
            return ((Tree)this.delegate).getHeight();
        }

        @Override
        public synchronized V getRoot() {
            return ((Tree)this.delegate).getRoot();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SynchronizedDirectedGraph<V, E>
    extends SynchronizedAbstractGraph<V, E>
    implements DirectedGraph<V, E>,
    Serializable {
        private SynchronizedDirectedGraph(DirectedGraph<V, E> delegate) {
            super(delegate);
        }

        @Override
        public synchronized V getDest(E directed_edge) {
            return ((DirectedGraph)this.delegate).getDest(directed_edge);
        }

        @Override
        public synchronized V getSource(E directed_edge) {
            return ((DirectedGraph)this.delegate).getSource(directed_edge);
        }

        @Override
        public synchronized boolean isDest(V vertex, E edge) {
            return ((DirectedGraph)this.delegate).isDest(vertex, edge);
        }

        @Override
        public synchronized boolean isSource(V vertex, E edge) {
            return ((DirectedGraph)this.delegate).isSource(vertex, edge);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SynchronizedUndirectedGraph<V, E>
    extends SynchronizedAbstractGraph<V, E>
    implements UndirectedGraph<V, E>,
    Serializable {
        private SynchronizedUndirectedGraph(UndirectedGraph<V, E> delegate) {
            super(delegate);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SynchronizedGraph<V, E>
    extends SynchronizedAbstractGraph<V, E>
    implements Serializable {
        private SynchronizedGraph(Graph<V, E> delegate) {
            super(delegate);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class SynchronizedAbstractGraph<V, E>
    implements Graph<V, E>,
    Serializable {
        protected Graph<V, E> delegate;

        private SynchronizedAbstractGraph(Graph<V, E> delegate) {
            if (delegate == null) {
                throw new NullPointerException();
            }
            this.delegate = delegate;
        }

        @Override
        public EdgeType getDefaultEdgeType() {
            return this.delegate.getDefaultEdgeType();
        }

        @Override
        public synchronized boolean addEdge(E e, V v1, V v2, EdgeType edgeType) {
            return this.delegate.addEdge(e, v1, v2, edgeType);
        }

        @Override
        public synchronized boolean addEdge(E e, Collection<? extends V> vertices, EdgeType edgeType) {
            return this.delegate.addEdge(e, (EdgeType)((Object)vertices), edgeType);
        }

        @Override
        public synchronized boolean addEdge(E e, V v1, V v2) {
            return this.delegate.addEdge(e, v1, v2);
        }

        @Override
        public synchronized boolean addVertex(V vertex) {
            return this.delegate.addVertex(vertex);
        }

        @Override
        public synchronized boolean isIncident(V vertex, E edge) {
            return this.delegate.isIncident(vertex, edge);
        }

        @Override
        public synchronized boolean isNeighbor(V v1, V v2) {
            return this.delegate.isNeighbor(v1, v2);
        }

        @Override
        public synchronized int degree(V vertex) {
            return this.delegate.degree(vertex);
        }

        @Override
        public synchronized E findEdge(V v1, V v2) {
            return this.delegate.findEdge(v1, v2);
        }

        @Override
        public synchronized Collection<E> findEdgeSet(V v1, V v2) {
            return this.delegate.findEdgeSet(v1, v2);
        }

        @Override
        public synchronized Collection<E> getEdges() {
            return this.delegate.getEdges();
        }

        @Override
        public synchronized Collection<E> getEdges(EdgeType edgeType) {
            return this.delegate.getEdges(edgeType);
        }

        @Override
        public synchronized Pair<V> getEndpoints(E edge) {
            return this.delegate.getEndpoints(edge);
        }

        @Override
        public synchronized Collection<E> getIncidentEdges(V vertex) {
            return this.delegate.getIncidentEdges(vertex);
        }

        @Override
        public synchronized Collection<V> getIncidentVertices(E edge) {
            return this.delegate.getIncidentVertices(edge);
        }

        @Override
        public synchronized Collection<E> getInEdges(V vertex) {
            return this.delegate.getInEdges(vertex);
        }

        @Override
        public synchronized Collection<V> getNeighbors(V vertex) {
            return this.delegate.getNeighbors(vertex);
        }

        @Override
        public synchronized V getOpposite(V vertex, E edge) {
            return this.delegate.getOpposite(vertex, edge);
        }

        @Override
        public synchronized Collection<E> getOutEdges(V vertex) {
            return this.delegate.getOutEdges(vertex);
        }

        @Override
        public synchronized Collection<V> getPredecessors(V vertex) {
            return this.delegate.getPredecessors(vertex);
        }

        @Override
        public synchronized Collection<V> getSuccessors(V vertex) {
            return this.delegate.getSuccessors(vertex);
        }

        @Override
        public synchronized Collection<V> getVertices() {
            return this.delegate.getVertices();
        }

        @Override
        public synchronized int getEdgeCount() {
            return this.delegate.getEdgeCount();
        }

        @Override
        public synchronized int getEdgeCount(EdgeType edge_type) {
            return this.delegate.getEdgeCount(edge_type);
        }

        @Override
        public synchronized int getVertexCount() {
            return this.delegate.getVertexCount();
        }

        @Override
        public synchronized int inDegree(V vertex) {
            return this.delegate.inDegree(vertex);
        }

        @Override
        public synchronized EdgeType getEdgeType(E edge) {
            return this.delegate.getEdgeType(edge);
        }

        @Override
        public synchronized boolean isPredecessor(V v1, V v2) {
            return this.delegate.isPredecessor(v1, v2);
        }

        @Override
        public synchronized boolean isSuccessor(V v1, V v2) {
            return this.delegate.isSuccessor(v1, v2);
        }

        @Override
        public synchronized int getNeighborCount(V vertex) {
            return this.delegate.getNeighborCount(vertex);
        }

        @Override
        public synchronized int getPredecessorCount(V vertex) {
            return this.delegate.getPredecessorCount(vertex);
        }

        @Override
        public synchronized int getSuccessorCount(V vertex) {
            return this.delegate.getSuccessorCount(vertex);
        }

        @Override
        public synchronized int outDegree(V vertex) {
            return this.delegate.outDegree(vertex);
        }

        @Override
        public synchronized boolean removeEdge(E edge) {
            return this.delegate.removeEdge(edge);
        }

        @Override
        public synchronized boolean removeVertex(V vertex) {
            return this.delegate.removeVertex(vertex);
        }

        @Override
        public synchronized V getDest(E directed_edge) {
            return this.delegate.getDest(directed_edge);
        }

        @Override
        public synchronized V getSource(E directed_edge) {
            return this.delegate.getSource(directed_edge);
        }

        @Override
        public synchronized boolean isDest(V vertex, E edge) {
            return this.delegate.isDest(vertex, edge);
        }

        @Override
        public synchronized boolean isSource(V vertex, E edge) {
            return this.delegate.isSource(vertex, edge);
        }

        @Override
        public synchronized int getIncidentCount(E edge) {
            return this.delegate.getIncidentCount(edge);
        }

        @Override
        public synchronized boolean addEdge(E hyperedge, Collection<? extends V> vertices) {
            return this.delegate.addEdge(hyperedge, vertices);
        }

        @Override
        public synchronized boolean containsEdge(E edge) {
            return this.delegate.containsEdge(edge);
        }

        @Override
        public synchronized boolean containsVertex(V vertex) {
            return this.delegate.containsVertex(vertex);
        }
    }
}

