/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.massspectrometry;

import com.compomics.util.experiment.biology.ions.ElementaryIon;
import com.compomics.util.experiment.massspectrometry.Charge;
import com.compomics.util.experiment.personalization.ExperimentObject;
import java.util.ArrayList;

public class Precursor
extends ExperimentObject {
    static final long serialVersionUID = -2711244157697138296L;
    private double rt;
    private Double rtMin;
    private Double rtMax;
    private double mz;
    private double intensity = 0.0;
    private ArrayList<Charge> possibleCharges = new ArrayList();

    public Precursor(double rt, double mz, ArrayList<Charge> possibleCharges) {
        this.rt = rt;
        this.rtMin = rt;
        this.rtMax = rt;
        this.mz = mz;
        this.possibleCharges.addAll(possibleCharges);
    }

    public Precursor(double rt, double mz, double intensity, ArrayList<Charge> possibleCharges, double rtMin, double rtMax) {
        this.rt = rt;
        this.rtMin = rtMin;
        this.rtMax = rtMax;
        this.mz = mz;
        this.intensity = intensity;
        this.possibleCharges.addAll(possibleCharges);
    }

    public Precursor(double mz, double intensity, ArrayList<Charge> possibleCharges, double rtMin, double rtMax) {
        this.rt = (rtMin + rtMax) / 2.0;
        this.rtMin = rtMin;
        this.rtMax = rtMax;
        this.mz = mz;
        this.intensity = intensity;
        this.possibleCharges.addAll(possibleCharges);
    }

    public Precursor(double rt, double mz, double intensity, ArrayList<Charge> possibleCharges) {
        this.rt = rt;
        this.rtMin = rt;
        this.rtMax = rt;
        this.mz = mz;
        this.intensity = intensity;
        this.possibleCharges.addAll(possibleCharges);
    }

    public double getRt() {
        return this.rt;
    }

    public boolean hasRTWindow() {
        return this.rtMin != null && this.rtMax != null && this.rtMin != -1.0 && this.rtMax != -1.0 && !this.rtMin.equals(this.rtMax);
    }

    public double[] getRtWindow() {
        if (this.rtMin == null) {
            this.rtMin = this.rt;
        }
        if (this.rtMax == null) {
            this.rtMax = this.rt;
        }
        return new double[]{this.rtMin, this.rtMax};
    }

    public double getMz() {
        return this.mz;
    }

    public double getIntensity() {
        return this.intensity;
    }

    public ArrayList<Charge> getPossibleCharges() {
        return this.possibleCharges;
    }

    public String getPossibleChargesAsString() {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (Charge charge : this.possibleCharges) {
            if (first) {
                first = false;
            } else {
                result.append(", ");
            }
            result.append(charge.toString());
        }
        return result.toString();
    }

    public Precursor getRecalibratedPrecursor(double mzCorrection, double rtCorrection) {
        return new Precursor(this.rt - rtCorrection, this.mz - mzCorrection, this.intensity, this.possibleCharges);
    }

    public double getMass(int chargeValue) {
        return this.mz * (double)chargeValue - (double)chargeValue * ElementaryIon.proton.getTheoreticMass();
    }
}

