/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment;

import com.compomics.util.experiment.biology.Enzyme;
import com.compomics.util.experiment.identification.SearchParameters;
import com.compomics.util.experiment.massspectrometry.FragmentationMethod;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;

public class ShotgunProtocol
implements Serializable {
    private Enzyme enzyme;
    private ArrayList<String> enrichedPtms;
    private HashMap<String, Boolean> labellingPtms;
    private Double ms1Resolution;
    private boolean ms1ResolutionPpm;
    private FragmentationMethod fragmentationMethod;
    private Double ms2Resolution;
    private boolean ms2ResolutionPpm;

    public Enzyme getEnzyme() {
        return this.enzyme;
    }

    public void setEnzyme(Enzyme enzyme) {
        this.enzyme = enzyme;
    }

    public ArrayList<String> getEnrichedPtms() {
        return this.enrichedPtms;
    }

    public void setEnrichedPtms(ArrayList<String> enrichedPtms) {
        this.enrichedPtms = enrichedPtms;
    }

    public Double getMs1Resolution() {
        return this.ms1Resolution;
    }

    public void setMs1Resolution(Double ms1Resolution) {
        this.ms1Resolution = ms1Resolution;
    }

    public boolean isMs1ResolutionPpm() {
        return this.ms1ResolutionPpm;
    }

    public void setMs1ResolutionPpm(boolean ms1ResolutionPpm) {
        this.ms1ResolutionPpm = ms1ResolutionPpm;
    }

    public FragmentationMethod getFragmentationMethod() {
        return this.fragmentationMethod;
    }

    public void setFragmentationMethod(FragmentationMethod fragmentationMethod) {
        this.fragmentationMethod = fragmentationMethod;
    }

    public Double getMs2Resolution() {
        return this.ms2Resolution;
    }

    public void setMs2Resolution(Double ms2Resolution) {
        this.ms2Resolution = ms2Resolution;
    }

    public boolean isMs2ResolutionPpm() {
        return this.ms2ResolutionPpm;
    }

    public void setMs2ResolutionPpm(boolean ms2ResolutionPpm) {
        this.ms2ResolutionPpm = ms2ResolutionPpm;
    }

    public void addLabel(String ptmName, boolean complete) {
        if (this.labellingPtms == null) {
            this.labellingPtms = new HashMap(1);
        }
        this.labellingPtms.put(ptmName, complete);
    }

    public HashMap<String, Boolean> getLabellingPtms() {
        return this.labellingPtms;
    }

    public static ShotgunProtocol inferProtocolFromSearchSettings(SearchParameters searchParameters) {
        ShotgunProtocol shotgunProtocol = new ShotgunProtocol();
        shotgunProtocol.setEnzyme(searchParameters.getEnzyme());
        shotgunProtocol.setMs1Resolution(searchParameters.getPrecursorAccuracy());
        shotgunProtocol.setMs1ResolutionPpm(searchParameters.isPrecursorAccuracyTypePpm());
        shotgunProtocol.setMs2Resolution(searchParameters.getFragmentIonAccuracy());
        shotgunProtocol.setMs2ResolutionPpm(false);
        return shotgunProtocol;
    }
}

