/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util.export;

import cytoscape.Cytoscape;
import cytoscape.ding.DingNetworkView;
import cytoscape.util.export.Exporter;
import cytoscape.view.CyNetworkView;
import cytoscape.view.InternalFrameComponent;
import java.awt.Component;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import org.freehep.graphicsio.ps.PSGraphics2D;

public class PSExporter
implements Exporter {
    private boolean exportTextAsFont = true;

    public void export(CyNetworkView view, FileOutputStream stream) throws IOException {
        DingNetworkView theView = (DingNetworkView)view;
        theView.setPrintingTextAsShape(!this.exportTextAsFont);
        InternalFrameComponent ifc = Cytoscape.getDesktop().getNetworkViewManager().getInternalFrameComponent(view);
        Properties p = new Properties();
        p.setProperty(PSGraphics2D.PAGE_SIZE, "Letter");
        p.setProperty("org.freehep.graphicsio.AbstractVectorGraphicsIO.TEXT_AS_SHAPES", Boolean.toString(!this.exportTextAsFont));
        PSGraphics2D g = new PSGraphics2D((OutputStream)stream, (Component)ifc);
        g.setMultiPage(false);
        g.setProperties(p);
        g.startExport();
        ifc.printWithoutForeground(g);
        g.endExport();
    }

    public void setExportTextAsFont(boolean pExportTextAsFont) {
        this.exportTextAsFont = pExportTextAsFont;
    }
}

