/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util;

import cytoscape.bookmarks.Attribute;
import cytoscape.bookmarks.Bookmarks;
import cytoscape.bookmarks.Category;
import cytoscape.bookmarks.DataSource;
import cytoscape.data.readers.BookmarkReader;
import cytoscape.logger.CyLogger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BookmarksUtil {
    protected static CyLogger logger = CyLogger.getLogger(BookmarksUtil.class);
    private static String bookmarkPackageName = "cytoscape.bookmarks";

    public static List<DataSource> getDataSourceList(String categoryName, List<Category> categoryList) {
        Category targetCat = BookmarksUtil.getCategory(categoryName, categoryList);
        if (targetCat != null) {
            return BookmarksUtil.extractDataSources(targetCat);
        }
        return null;
    }

    public static Category getCategory(String categoryName, List<Category> categoryList) {
        Category result = null;
        for (Category cat : categoryList) {
            if (cat.getName().equals(categoryName)) {
                result = cat;
                break;
            }
            List<Category> subCategories = BookmarksUtil.extractCategory(cat);
            if (subCategories.size() != 0 && result == null) {
                result = BookmarksUtil.getCategory(categoryName, subCategories);
            }
            if (result == null) continue;
            break;
        }
        return result;
    }

    public static String getAttribute(DataSource source, String attrName) {
        List<Attribute> attrs = source.getAttribute();
        for (Attribute attr : attrs) {
            if (!attrName.equals(attr.getName())) continue;
            return attr.getContent();
        }
        return null;
    }

    private static List<DataSource> extractDataSources(Category cat) {
        List<Object> entries = cat.getCategoryOrDataSource();
        ArrayList<DataSource> datasourceList = new ArrayList<DataSource>();
        for (Object obj : entries) {
            if (obj.getClass() != DataSource.class) continue;
            datasourceList.add((DataSource)obj);
        }
        return datasourceList;
    }

    private static List<Category> extractCategory(Category cat) {
        List<Object> entries = cat.getCategoryOrDataSource();
        ArrayList<Category> categoryList = new ArrayList<Category>();
        for (Object obj : entries) {
            if (obj.getClass() != Category.class) continue;
            categoryList.add((Category)obj);
        }
        return categoryList;
    }

    public static Bookmarks getBookmarks(URL bookmarkUrl) throws JAXBException, IOException {
        BookmarkReader reader = new BookmarkReader();
        reader.readBookmarks(bookmarkUrl);
        return reader.getBookmarks();
    }

    public static Bookmarks getBookmarks(File pBookmarkFile) {
        Bookmarks theBookmarks = null;
        try {
            theBookmarks = BookmarksUtil.getBookmarks(pBookmarkFile.toURL());
        }
        catch (IOException e) {
            CyLogger.getLogger().warn("Can not read the bookmark file, the bookmark file may not exist!");
        }
        catch (JAXBException e) {
            CyLogger.getLogger().warn("JAXBException -- bookmarkSource");
        }
        return theBookmarks;
    }

    public static void saveBookmark(Bookmarks pBookmarks, String pCategoryName, DataSource pDataSource, FileOutputStream pFos) throws JAXBException, IOException {
        Category theCategory;
        List<Category> theCategoryList = pBookmarks.getCategory();
        if (theCategoryList.size() == 0) {
            theCategory = new Category();
            theCategory.setName(pCategoryName);
            theCategoryList.add(theCategory);
        }
        theCategory = BookmarksUtil.getCategory(pCategoryName, theCategoryList);
        List<Object> theObjList = theCategory.getCategoryOrDataSource();
        theObjList.add(pDataSource);
        JAXBContext jc = JAXBContext.newInstance(bookmarkPackageName);
        Marshaller m = jc.createMarshaller();
        m.setProperty("jaxb.formatted.output", Boolean.TRUE);
        m.marshal((Object)pBookmarks, pFos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean saveBookmark(URL pBookmarkURL, String pCategoryName, DataSource pDataSource) {
        Bookmarks theBookmarks = null;
        try {
            theBookmarks = BookmarksUtil.getBookmarks(pBookmarkURL);
        }
        catch (Exception e) {
            theBookmarks = new Bookmarks();
        }
        File tmpFile = new File(pBookmarkURL.getFile());
        if (!tmpFile.exists()) {
            try {
                tmpFile.createNewFile();
            }
            catch (Exception ex) {
                logger.info("Bookmark file may not exist, failed to create new one.");
            }
        }
        try {
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(pBookmarkURL.getFile());
                BookmarksUtil.saveBookmark(theBookmarks, pCategoryName, pDataSource, fos);
                Object var7_10 = null;
                if (fos == null) return true;
            }
            catch (Throwable throwable) {
                Object var7_11 = null;
                if (fos == null) throw throwable;
                fos.close();
                throw throwable;
            }
            fos.close();
            return true;
        }
        catch (JAXBException e) {
            logger.error("Error converting bookmark: " + e.getMessage());
            return false;
        }
        catch (Exception e) {
            logger.error("Unable to save bookmark: " + e.getMessage());
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean saveBookmark(Bookmarks pBookmarks, File pFile) {
        FileOutputStream fos = null;
        fos = new FileOutputStream(pFile);
        BookmarksUtil.saveBookmark(pBookmarks, fos);
        Object var6_3 = null;
        if (fos == null) return true;
        try {
            fos.close();
            return true;
        }
        catch (IOException e2) {
            logger.warn("Unable to close bookmark file: " + e2.getMessage());
        }
        return true;
        {
            catch (Exception e) {
                logger.error("Unable to save bookmark: " + e.getMessage());
                boolean bl = false;
                Object var6_4 = null;
                if (fos == null) return bl;
                try {
                    fos.close();
                    return bl;
                }
                catch (IOException e2) {
                    logger.warn("Unable to close bookmark file: " + e2.getMessage());
                }
                return bl;
            }
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (fos == null) throw throwable;
            try {
                fos.close();
                throw throwable;
            }
            catch (IOException e2) {
                logger.warn("Unable to close bookmark file: " + e2.getMessage());
            }
            throw throwable;
        }
    }

    public static boolean saveBookmark(Bookmarks pBookmarks, OutputStream os) {
        try {
            JAXBContext jc = JAXBContext.newInstance(bookmarkPackageName);
            Marshaller m = jc.createMarshaller();
            m.setProperty("jaxb.formatted.output", Boolean.TRUE);
            m.marshal((Object)pBookmarks, os);
        }
        catch (Exception e) {
            logger.error("Unable to save bookmark: " + e.getMessage());
            return false;
        }
        return true;
    }

    public static void saveBookmark(Bookmarks pBookmarks, String pCategoryName, DataSource pDataSource) {
        Category theCategory;
        List<Category> theCategoryList;
        if (pBookmarks == null) {
            pBookmarks = new Bookmarks();
        }
        if ((theCategoryList = pBookmarks.getCategory()).size() == 0) {
            theCategory = new Category();
            theCategory.setName(pCategoryName);
            theCategoryList.add(theCategory);
        }
        if ((theCategory = BookmarksUtil.getCategory(pCategoryName, theCategoryList)) == null) {
            Category newCategory = new Category();
            newCategory.setName(pCategoryName);
            theCategoryList.add(newCategory);
            theCategory = newCategory;
        }
        List<Object> theObjList = theCategory.getCategoryOrDataSource();
        theObjList.add(pDataSource);
    }

    public static boolean deleteBookmark(String filename, Bookmarks pBookmarks, String pCategoryName, DataSource pDataSource) {
        List<Category> theCategoryList = pBookmarks.getCategory();
        Category theCategory = BookmarksUtil.getCategory(pCategoryName, theCategoryList);
        List<Object> theObjList = theCategory.getCategoryOrDataSource();
        for (int i = 0; i < theObjList.size(); ++i) {
            DataSource theDataSource;
            Object obj = theObjList.get(i);
            if (!(obj instanceof DataSource) || !(theDataSource = (DataSource)obj).getName().equalsIgnoreCase(pDataSource.getName())) continue;
            theObjList.remove(i);
            try {
                JAXBContext jc = JAXBContext.newInstance(bookmarkPackageName);
                Marshaller m = jc.createMarshaller();
                m.setProperty("jaxb.formatted.output", Boolean.TRUE);
                m.marshal((Object)pBookmarks, new FileOutputStream(filename));
            }
            catch (Exception e) {
                logger.error("Unable to update bookmark file after delete: " + e.getMessage());
            }
            return true;
        }
        return false;
    }

    public static boolean deleteBookmark(Bookmarks pBookmarks, String pCategoryName, DataSource pDataSource) {
        if (!BookmarksUtil.isInBookmarks(pBookmarks, pCategoryName, pDataSource)) {
            return false;
        }
        List<Category> theCategoryList = pBookmarks.getCategory();
        Category theCategory = BookmarksUtil.getCategory(pCategoryName, theCategoryList);
        List<Object> theObjList = theCategory.getCategoryOrDataSource();
        for (int i = 0; i < theObjList.size(); ++i) {
            DataSource theDataSource;
            Object obj = theObjList.get(i);
            if (!(obj instanceof DataSource) || !(theDataSource = (DataSource)obj).getName().equalsIgnoreCase(pDataSource.getName())) continue;
            theObjList.remove(i);
        }
        return true;
    }

    public static boolean isInBookmarks(Bookmarks pBookmarks, String pCategoryName, DataSource pDataSource) {
        if (pBookmarks == null) {
            return false;
        }
        List<DataSource> theDataSources = BookmarksUtil.getDataSourceList(pCategoryName, pBookmarks.getCategory());
        if (theDataSources == null || theDataSources.size() == 0) {
            return false;
        }
        for (DataSource theDataSource : theDataSources) {
            if (!theDataSource.getName().equalsIgnoreCase(pDataSource.getName())) continue;
            return true;
        }
        return false;
    }

    public static boolean isInBookmarks(URL pBookmarkURL, String pCategoryName, DataSource pDataSource) {
        Bookmarks theBookmarks = null;
        try {
            theBookmarks = BookmarksUtil.getBookmarks(pBookmarkURL);
        }
        catch (Exception e) {
            return false;
        }
        return BookmarksUtil.isInBookmarks(theBookmarks, pCategoryName, pDataSource);
    }
}

