## ----eval=FALSE------------------------------------------------------------
#  if (!requireNamespace("BiocManager", quietly=TRUE))
#      install.packages("BiocManager")
#  BiocManager::install("CTDquerier")

## ----message=FALSE---------------------------------------------------------
library( CTDquerier )

## ----args_query_gene-------------------------------------------------------
args( query_ctd_gene )

## ----ctd_genes-------------------------------------------------------------
ctd_genes <- query_ctd_gene( 
    terms = c( "APOE", "APOEB", "APOE2", "APOE3" , "APOE4", "APOA1", "APOA5" ) )
ctd_genes

## ----ctd_get_genes---------------------------------------------------------
get_terms( ctd_genes )

## ----ctd_gene_ext_dise-----------------------------------------------------
get_table( ctd_genes , index_name = "diseases" )[ 1:2, 1:3 ]

## ----ctd_gene_ext_tbl------------------------------------------------------
colnames( get_table( ctd_genes, index_name = "chemical interactions" ) )
colnames( get_table( ctd_genes, index_name = "diseases" ) )
colnames( get_table( ctd_genes, index_name = "gene-gene interactions" ) )
colnames( get_table( ctd_genes, index_name = "kegg pathways" ) )
colnames( get_table( ctd_genes, index_name = "go terms" ) )

## ----ctd_gene_hm_chem------------------------------------------------------
plot( ctd_genes, index_name = "chemical interactions", filter.score = 3 )

## ----ctd_gene_hm_dise------------------------------------------------------
plot( ctd_genes, index_name = "disease", filter.score = 115 )

## ----ctd_gene_ntw_gene-----------------------------------------------------
plot( ctd_genes, index_name = "gene-gene interactions", 
    representation = "network", main = "APOE-like gene-gene interactions" )

## ----ctd_gen_ntw_hegg------------------------------------------------------
plot( ctd_genes, index_name = "kegg pathways", 
    representation = "network", main = "KEGG pathways related to APOE genes" )

## ----ctd_gen_ntw_go--------------------------------------------------------
plot( ctd_genes, index_name = "go terms",
    representation = "network", main = "GO terms related to APOE genes",
    ontology = "Molecular Function" )

## ----args_query_chem-------------------------------------------------------
args( query_ctd_chem )

## ----ctd_chem--------------------------------------------------------------
ctd_chem <- query_ctd_chem( terms = c( "Zinc", "Cadmium" ) )
ctd_chem

## ----ctd_get_chem----------------------------------------------------------
get_terms( ctd_chem )

## ----ctd_chem_ext_dise-----------------------------------------------------
get_table( ctd_chem , index_name = "diseases" )[ 1:2, 1:6 ]

## ----ctd_chem_ext_tbl------------------------------------------------------
colnames( get_table( ctd_chem, index_name = "gene interactions" ) )
colnames( get_table( ctd_chem, index_name = "diseases" ) )
colnames( get_table( ctd_chem, index_name = "kegg pathways" ) )
colnames( get_table( ctd_chem, index_name = "go terms" ) )

## ----ctd_chem_hm_gene------------------------------------------------------
plot( ctd_chem, index_name = "gene interactions", filter.score = 5 )

## ----ctd_chem_ntw_gene-----------------------------------------------------
plot( ctd_chem, index_name = "gene interactions", representation = "network",
    filter.score = 3, main = "Gen-Chemical interaction for Zinc and Cadmium" )

## ----ctd_chm_htm_dise------------------------------------------------------
plot( ctd_chem, index_name = "disease" )

## ----ctd_chem_htm_kegg-----------------------------------------------------
plot( ctd_chem, index_name = "kegg pathways", filter.score = 1e-40 )

## ----ctd_chem_htm_go, fig.height=8-----------------------------------------
plot( ctd_chem, index_name = "go terms",
    representation = "network", filter.score = 1e-210 )

## ----args_query_dise-------------------------------------------------------
args( query_ctd_dise )

## ----ctd_dise--------------------------------------------------------------
ctd_diseases <- query_ctd_dise( terms = c( "Dementia", "Alzheimer" ) )
ctd_diseases

## ----ctd_get_dise----------------------------------------------------------
get_terms( ctd_diseases )

## ----ctd_dise_ext_gene-----------------------------------------------------
get_table( ctd_diseases , index_name = "gene interactions" )[ 1:2, 1:5 ]

## ----ctd_dise_ext_tbl------------------------------------------------------
colnames( get_table( ctd_diseases, index_name = "gene interactions" ) )
colnames( get_table( ctd_diseases, index_name = "chemical interactions" ) )
colnames( get_table( ctd_diseases, index_name = "kegg pathways" ) )

## ----ctd_dise_htm_gen, fig.height=8----------------------------------------
plot( ctd_diseases, index_name = "gene interactions", filter.score = 75 )

## ----ctd_dise_htm_chm------------------------------------------------------
plot( ctd_diseases, index_name = "chemical interactions", filter.score = 35 )

## ----ctd_dise_ntw_kegg-----------------------------------------------------
plot( ctd_diseases, index_name = "kegg pathways", 
    representation = "network", subset.disease = "Dementia" )

## ----sessionInfo, echo=FALSE-----------------------------------------------
sessionInfo()

