## ----setup, include=FALSE--------------------------------------------------
knitr::opts_chunk$set(echo = TRUE)

## ----loading_xkr4_tables, warning=FALSE------------------------------------
# Chemicals - XKR4
bq_xkr4_c <- system.file(
  paste0( "extdata", .Platform$file.sep, "bq_xkr4_chem.tsv" ), 
  package="CTDquerier"
)
nrow( read.delim( bq_xkr4_c, sep = "\t" ) )
# Diseses curated - XKR4
bq_xkr4_dC <- system.file(
  paste0( "extdata", .Platform$file.sep, "bq_xkr4_disease_curated.tsv" ), 
  package="CTDquerier"
)
nrow( read.delim( bq_xkr4_dC, sep = "\t" ) )
# Diseases inferred - XKR4
bq_xkr4_dI <- system.file(
  paste0( "extdata", .Platform$file.sep, "bq_xkr4_disease_inferred.tsv" ), 
  package="CTDquerier"
)
nrow( read.delim( bq_xkr4_dI, sep = "\t" ) )
# Diseases all - XKR4
bq_xkr4_dA <- system.file(
  paste0( "extdata", .Platform$file.sep, "bq_xkr4_disease_all.tsv" ), 
  package="CTDquerier"
)
nrow( read.delim( bq_xkr4_dA, sep = "\t" ) )

## ----ctdquerier_xkr4-------------------------------------------------------
library( CTDquerier )
xkr4 <- query_ctd_gene( terms = "XKR4", verbose = TRUE )
xkr4

## ----compare_xkr4_chemicals------------------------------------------------
# How many unique chemicals associations there are in the result object?
xkr4_chem <- get_table( xkr4, index_name = "chemical interactions" )
length( unique( xkr4_chem$Chemical.Name ) )

# How many of the chemicals download using CTDquerier are in the Batch Query files?
bq_xkr4_c <- read.delim( bq_xkr4_c, sep = "\t" )
sum( as.character( bq_xkr4_c[ , 2] ) %in% unique( xkr4_chem$Chemical.Name ) )

## --------------------------------------------------------------------------
dim( get_table( xkr4, index_name = "diseases" ) )

## --------------------------------------------------------------------------
bq_xkr4_dA <- read.delim( bq_xkr4_dA, sep = "\t" )
length( unique( bq_xkr4_dA$DiseaseID ) )

sum( as.character( unique( bq_xkr4_dA$DiseaseID ) ) %in% 
    get_table( xkr4, index_name = "diseases" )$Disease.ID )

## --------------------------------------------------------------------------
bq_xkr4_dA[1:3, ]

## --------------------------------------------------------------------------
tbl <- get_table( xkr4, index_name = "diseases" )
tbl[ tbl$Disease.ID == "MESH:D015746", "Inference.Network" ]

## ----sessionInfo, echo=FALSE-----------------------------------------------
sessionInfo()

