/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.numeric.plot.impl;

import edu.rit.numeric.ListXYSeries;
import edu.rit.numeric.XYSeries;
import edu.rit.numeric.plot.Dots;
import edu.rit.numeric.plot.Strokes;
import java.awt.BasicStroke;
import java.awt.Color;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public abstract class PlotSeries
implements Externalizable {
    private static final long serialVersionUID = 272975169581660883L;
    protected XYSeries myDataSeries;
    protected Dots myDots;
    protected BasicStroke myStroke;
    protected Color myColor;
    protected boolean mySmooth;

    public PlotSeries() {
    }

    public PlotSeries(XYSeries xYSeries, Dots dots, BasicStroke basicStroke, Color color, boolean bl) {
        if (xYSeries == null) {
            throw new NullPointerException();
        }
        this.myDataSeries = xYSeries;
        this.myDots = dots;
        this.myStroke = basicStroke;
        this.myColor = color;
        this.mySmooth = bl;
    }

    public XYSeries getDataSeries() {
        return this.myDataSeries;
    }

    public Dots getDots() {
        return this.myDots;
    }

    public BasicStroke getStroke() {
        return this.myStroke;
    }

    public Color getColor() {
        return this.myColor;
    }

    public boolean isSmooth() {
        return this.mySmooth;
    }

    public abstract int getDotCount();

    public abstract double getDotX(int var1);

    public abstract double getDotY(int var1);

    public abstract int getLineCount();

    public abstract double getLineX1(int var1);

    public abstract double getLineY1(int var1);

    public abstract double getLineX2(int var1);

    public abstract double getLineY2(int var1);

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.myDots);
        Strokes.writeExternal(this.myStroke, objectOutput);
        objectOutput.writeObject(this.myColor);
        objectOutput.writeBoolean(this.mySmooth);
        int n = this.myDataSeries.length();
        objectOutput.writeInt(n);
        for (int i = 0; i < n; ++i) {
            objectOutput.writeDouble(this.myDataSeries.x(i));
            objectOutput.writeDouble(this.myDataSeries.y(i));
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.myDots = (Dots)objectInput.readObject();
        this.myStroke = Strokes.readExternal(objectInput);
        this.myColor = (Color)objectInput.readObject();
        this.mySmooth = objectInput.readBoolean();
        ListXYSeries listXYSeries = new ListXYSeries();
        int n = objectInput.readInt();
        for (int i = 0; i < n; ++i) {
            listXYSeries.add(objectInput.readDouble(), objectInput.readDouble());
        }
        this.myDataSeries = listXYSeries;
    }
}

