/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.numeric;

import edu.rit.numeric.Function;
import edu.rit.numeric.ListXYSeries;
import edu.rit.numeric.MDFunction;
import edu.rit.numeric.MDMinimizationDownhillSimplex;
import edu.rit.numeric.ParameterizedFunction;
import edu.rit.numeric.XYSeries;
import edu.rit.util.Random;
import java.util.Arrays;
import java.util.Comparator;

public class RobustFit {
    public final ParameterizedFunction model;
    public final int M;
    public Function metric = CAUCHY;
    public final double[] param;
    public XYSeries data;
    public double metricValue;
    public double[][] paramSeries;
    public double[] metricSeries;
    public double[] confidenceRegionLowerBound;
    public double[] confidenceRegionUpperBound;
    public double pValue;
    public static final Function NORMAL = new Function(){

        public double f(double d) {
            return 0.5 * d * d;
        }
    };
    public static final Function EXPONENTIAL = new Function(){

        public double f(double d) {
            return Math.abs(d);
        }
    };
    public static final Function CAUCHY = new Function(){

        public double f(double d) {
            return Math.log(1.0 + 0.5 * d * d);
        }
    };
    private MDMinimizationDownhillSimplex minimizer;

    public RobustFit(ParameterizedFunction parameterizedFunction) {
        if (parameterizedFunction == null) {
            throw new NullPointerException("RobustFit(): model is null");
        }
        this.model = parameterizedFunction;
        this.M = parameterizedFunction.parameterLength();
        this.param = new double[this.M];
        this.minimizer = new MDMinimizationDownhillSimplex(new Metric());
    }

    public void fit(XYSeries xYSeries) {
        this.data = xYSeries;
        this.initializeSimplex(this.minimizer);
        this.minimizer.minimize();
        System.arraycopy(this.minimizer.x[0], 0, this.param, 0, this.M);
        this.metricValue = this.minimizer.f[0];
    }

    public void fitWithDistribution(XYSeries xYSeries, int n, Random random, double d) {
        int n2;
        int n3;
        int n4;
        int n5;
        if (0.0 > d || d > 1.0) {
            throw new IllegalArgumentException("RobustFit.fitWithDistribution(): conf = " + d + " illegal");
        }
        int n6 = xYSeries.length();
        this.paramSeries = new double[n][this.M];
        this.metricSeries = new double[n];
        this.confidenceRegionLowerBound = new double[this.M];
        this.confidenceRegionUpperBound = new double[this.M];
        this.data = xYSeries;
        this.initializeSimplex(this.minimizer);
        this.minimizer.minimize();
        System.arraycopy(this.minimizer.x[0], 0, this.param, 0, this.M);
        this.metricValue = this.minimizer.f[0];
        ListXYSeries listXYSeries = new ListXYSeries();
        this.data = listXYSeries;
        for (int i = 0; i < n; ++i) {
            listXYSeries.clear();
            for (n5 = 0; n5 < n6; ++n5) {
                int n7 = random.nextInt(n6);
                listXYSeries.add(xYSeries.x(n7), xYSeries.y(n7));
            }
            this.initializeSimplex(this.minimizer);
            this.minimizer.minimize();
            System.arraycopy(this.minimizer.x[0], 0, this.paramSeries[i], 0, this.M);
            this.metricSeries[i] = this.minimizer.f[0];
        }
        this.data = xYSeries;
        final double[] dArray = new double[n];
        for (n5 = 0; n5 < n; ++n5) {
            double[] dArray2 = this.paramSeries[n5];
            double d2 = 0.0;
            for (n4 = 0; n4 < this.M; ++n4) {
                d2 = Math.max(d2, Math.abs(dArray2[n4] - this.param[n4]));
            }
            dArray[n5] = d2;
        }
        Integer[] integerArray = new Integer[n];
        for (n3 = 0; n3 < n; ++n3) {
            integerArray[n3] = n3;
        }
        Arrays.sort(integerArray, new Comparator<Integer>(){

            @Override
            public int compare(Integer n, Integer n2) {
                return dArray[n] < dArray[n2] ? -1 : (dArray[n] > dArray[n2] ? 1 : 0);
            }
        });
        for (n3 = 0; n3 < this.M; ++n3) {
            this.confidenceRegionLowerBound[n3] = Double.POSITIVE_INFINITY;
            this.confidenceRegionUpperBound[n3] = Double.NEGATIVE_INFINITY;
        }
        n3 = (int)(d * (double)n + 0.5);
        for (n2 = 0; n2 < n3; ++n2) {
            double[] dArray3 = this.paramSeries[integerArray[n2]];
            for (n4 = 0; n4 < this.M; ++n4) {
                this.confidenceRegionLowerBound[n4] = Math.min(this.confidenceRegionLowerBound[n4], dArray3[n4]);
                this.confidenceRegionUpperBound[n4] = Math.max(this.confidenceRegionUpperBound[n4], dArray3[n4]);
            }
        }
        this.pValue = 0.0;
        for (n2 = 0; n2 < n; ++n2) {
            if (!(this.metricSeries[n2] >= this.metricValue)) continue;
            this.pValue += 1.0;
        }
        this.pValue /= (double)n;
    }

    protected void initializeSimplex(MDMinimizationDownhillSimplex mDMinimizationDownhillSimplex) {
        System.arraycopy(this.param, 0, mDMinimizationDownhillSimplex.x[0], 0, this.M);
        for (int i = 1; i <= this.M; ++i) {
            double[] dArray = mDMinimizationDownhillSimplex.x[i];
            System.arraycopy(this.param, 0, dArray, 0, this.M);
            dArray[i - 1] = RobustFit.perturb(dArray[i - 1]);
        }
    }

    private static double perturb(double d) {
        return d == 0.0 ? 0.01 : 1.01 * d;
    }

    private class Metric
    implements MDFunction {
        private Metric() {
        }

        public int argumentLength() {
            return RobustFit.this.M;
        }

        public double f(double[] dArray) {
            double d = 0.0;
            int n = RobustFit.this.data.length();
            for (int i = 0; i < n; ++i) {
                d += RobustFit.this.metric.f(RobustFit.this.data.y(i) - RobustFit.this.model.f(RobustFit.this.data.x(i), dArray));
            }
            return d;
        }
    }
}

