/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.bio;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bridgedb.DataSource;
import org.bridgedb.IDMapper;
import org.bridgedb.IDMapperCapabilities;
import org.bridgedb.IDMapperException;
import org.bridgedb.Xref;
import org.bridgedb.bio.BioDataSource;
import org.bridgedb.impl.InternalUtils;

public class EnsemblCompatibilityMapper
implements IDMapper {
    private final Set<DataSource> oldDataSources = new HashSet<DataSource>();
    private final Set<DataSource> allDataSources;
    private boolean closed = false;

    public Map<Xref, Set<Xref>> mapID(Collection<Xref> srcXrefs, DataSource ... tgtDataSources) throws IDMapperException {
        return InternalUtils.mapMultiFromSingle((IDMapper)this, srcXrefs, (DataSource[])tgtDataSources);
    }

    public Set<Xref> mapID(Xref ref, DataSource ... tgtDataSources) throws IDMapperException {
        HashSet<Xref> result = new HashSet<Xref>();
        if (!this.allDataSources.contains(ref.getDataSource())) {
            return result;
        }
        HashSet<DataSource> dest = new HashSet<DataSource>();
        if (ref.getDataSource() == BioDataSource.ENSEMBL) {
            dest.addAll(this.oldDataSources);
        } else {
            dest.add(BioDataSource.ENSEMBL);
        }
        if (tgtDataSources != null && tgtDataSources.length > 0) {
            dest.retainAll(Arrays.asList(tgtDataSources));
        }
        for (DataSource ds : dest) {
            if (ds == ref.getDataSource()) continue;
            result.add(new Xref(ref.getId(), ds));
        }
        return result;
    }

    public boolean xrefExists(Xref xref) throws IDMapperException {
        return true;
    }

    public Set<Xref> freeSearch(String text, int limit) throws IDMapperException {
        return Collections.emptySet();
    }

    public EnsemblCompatibilityMapper() {
        this.oldDataSources.add(BioDataSource.ENSEMBL_BSUBTILIS);
        this.oldDataSources.add(BioDataSource.ENSEMBL_CELEGANS);
        this.oldDataSources.add(BioDataSource.ENSEMBL_CHICKEN);
        this.oldDataSources.add(BioDataSource.ENSEMBL_CHIMP);
        this.oldDataSources.add(BioDataSource.ENSEMBL_COW);
        this.oldDataSources.add(BioDataSource.ENSEMBL_DOG);
        this.oldDataSources.add(BioDataSource.ENSEMBL_ECOLI);
        this.oldDataSources.add(BioDataSource.ENSEMBL_FRUITFLY);
        this.oldDataSources.add(BioDataSource.ENSEMBL_HORSE);
        this.oldDataSources.add(BioDataSource.ENSEMBL_HUMAN);
        this.oldDataSources.add(BioDataSource.ENSEMBL_MOSQUITO);
        this.oldDataSources.add(BioDataSource.ENSEMBL_MOUSE);
        this.oldDataSources.add(BioDataSource.ENSEMBL_MTUBERCULOSIS);
        this.oldDataSources.add(BioDataSource.ENSEMBL_RAT);
        this.oldDataSources.add(BioDataSource.ENSEMBL_SCEREVISIAE);
        this.oldDataSources.add(BioDataSource.ENSEMBL_XENOPUS);
        this.oldDataSources.add(BioDataSource.ENSEMBL_ZEBRAFISH);
        this.allDataSources = new HashSet<DataSource>(this.oldDataSources);
        this.allDataSources.add(BioDataSource.ENSEMBL);
    }

    public IDMapperCapabilities getCapabilities() {
        return new IDMapperCapabilities(){

            public boolean isMappingSupported(DataSource src, DataSource tgt) throws IDMapperException {
                return EnsemblCompatibilityMapper.this.oldDataSources.contains(src) && tgt == BioDataSource.ENSEMBL || EnsemblCompatibilityMapper.this.oldDataSources.contains(tgt) && src == BioDataSource.ENSEMBL;
            }

            public boolean isFreeSearchSupported() {
                return false;
            }

            public Set<DataSource> getSupportedTgtDataSources() throws IDMapperException {
                return EnsemblCompatibilityMapper.this.allDataSources;
            }

            public Set<DataSource> getSupportedSrcDataSources() throws IDMapperException {
                return EnsemblCompatibilityMapper.this.allDataSources;
            }

            public String getProperty(String key) {
                return null;
            }

            public Set<String> getKeys() {
                return Collections.emptySet();
            }
        };
    }

    public void close() throws IDMapperException {
        this.closed = true;
    }

    public boolean isConnected() {
        return !this.closed;
    }

    public String toString() {
        return "old-ensembl-systemcode-compatbility-mapper";
    }
}

