/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.instance;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.UnsupervisedFilter;

public class RemovePercentage
extends Filter
implements UnsupervisedFilter,
OptionHandler {
    private int m_Percentage = 50;
    private boolean m_Inverse = false;

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(2);
        vector.addElement(new Option("\tSpecifies percentage of instances to select. (default 50)\n", "P", 1, "-P <percentage>"));
        vector.addElement(new Option("\tSpecifies if inverse of selection is to be output.\n", "V", 0, "-V"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('P', stringArray);
        if (string.length() != 0) {
            this.setPercentage(Integer.parseInt(string));
        } else {
            this.setPercentage(50);
        }
        this.setInvertSelection(Utils.getFlag('V', stringArray));
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
    }

    public String[] getOptions() {
        String[] stringArray = new String[5];
        int n = 0;
        stringArray[n++] = "-P";
        stringArray[n++] = "" + this.getPercentage();
        if (this.getInvertSelection()) {
            stringArray[n++] = "-V";
        }
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public String globalInfo() {
        return "A filter that removes a given percentage of a dataset.";
    }

    public String percentageTipText() {
        return "The percentage of the data to select.";
    }

    public int getPercentage() {
        return this.m_Percentage;
    }

    public void setPercentage(int n) {
        if (n < 0 || n > 100) {
            throw new IllegalArgumentException("Percentage must be between 0 and 100.");
        }
        this.m_Percentage = n;
    }

    public String invertSelectionTipText() {
        return "Whether to invert the selection.";
    }

    public boolean getInvertSelection() {
        return this.m_Inverse;
    }

    public void setInvertSelection(boolean bl) {
        this.m_Inverse = bl;
    }

    public boolean setInputFormat(Instances instances) throws Exception {
        super.setInputFormat(instances);
        this.setOutputFormat(instances);
        return true;
    }

    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.m_FirstBatchDone) {
            this.push(instance);
            return true;
        }
        this.bufferInput(instance);
        return false;
    }

    public boolean batchFinished() {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        Instances instances = this.getInputFormat();
        int n = instances.numInstances() * this.m_Percentage / 100;
        if (this.m_Inverse) {
            for (int i = 0; i < n; ++i) {
                this.push(instances.instance(i));
            }
        } else {
            for (int i = n; i < instances.numInstances(); ++i) {
                this.push(instances.instance(i));
            }
        }
        this.flushInput();
        this.m_NewBatch = true;
        this.m_FirstBatchDone = true;
        return this.numPendingOutput() != 0;
    }

    public static void main(String[] stringArray) {
        try {
            if (Utils.getFlag('b', stringArray)) {
                Filter.batchFilterFile(new RemovePercentage(), stringArray);
            } else {
                Filter.filterFile(new RemovePercentage(), stringArray);
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }
}

